/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ValidateUtil {
    public static void validatePositiveNumber(long fieldValue, String fieldName) {
        if (fieldValue <= 0L) {
            ValidateUtil.logAndThrow(String.format("%s should be a positive number: %d", fieldName, fieldValue));
        }
    }

    public static void validateNotNull(Object fieldValue, String fieldName) {
        if (fieldValue == null) {
            ValidateUtil.logAndThrow(String.format("'%s' value should not be NULL", fieldName));
        }
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.getClass().equals(String.class)) {
            return ((String)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        String message = "String, java.lang.Array or java.util.Collection expected but " + obj.getClass().getName() + " was found ";
        ValidateUtil.getLog().error((Object)message);
        throw new IllegalArgumentException(message);
    }

    public static void validateNotEmpty(Object fieldValue, String fieldName) {
        if (ValidateUtil.isEmpty(fieldValue)) {
            ValidateUtil.logAndThrow(String.format("'%s' value should not be empty", fieldName));
        }
    }

    private static void logAndThrow(String msg) {
        LogFactory.getLog(ValidateUtil.class).error((Object)msg);
        throw new IllegalArgumentException(msg);
    }

    private static Log getLog() {
        return LogFactory.getLog(ValidateUtil.class);
    }

    private ValidateUtil() {
    }
}

