/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.processors.request;

import com.rsa.names._2009._12.std_ext.ws_trust1_4.advice.AdviceSetType;
import com.rsa.names._2009._12.std_ext.ws_trust1_4.advice.AdviceType;
import com.rsa.names._2009._12.std_ext.ws_trust1_4.advice.AttributeType;
import com.vmware.vim.sso.client.Advice;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.impl.exception.ParserException;
import com.vmware.vim.sso.client.impl.processors.request.RequestBuilderImpl;
import java.util.List;
import javax.xml.bind.JAXBContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.oasis_open.docs.ws_sx.ws_trust._200512.DelegateToType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.ParticipantType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.ParticipantsType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RenewingType;
import org.oasis_open.docs.ws_sx.ws_trust._200512.RequestSecurityTokenType;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.AttributedString;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.ObjectFactory;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.PasswordString;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.UsernameTokenType;
import org.w3._2005._08.addressing.AttributedURIType;
import org.w3._2005._08.addressing.EndpointReferenceType;

public abstract class AcquireTokenRequestBuilder
extends RequestBuilderImpl {
    protected static final String REQUEST_TYPE_ISSUE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue";
    private static final String SOAP_ACTION_ISSUE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue";
    private static final String PREFFERED_SIGNATURE_ALG = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private static final String HOLDER_OF_KEY_CONFIRMATION_TYPE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey";
    private static final String BEARER_CONFIRMATION_TYPE = "http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer";
    private final TokenSpec _spec;
    private final Log _log = LogFactory.getLog(AcquireTokenRequestBuilder.class);
    private final boolean _hokConfirmation;

    public AcquireTokenRequestBuilder(TokenSpec tokenSpec, boolean hokConfirmation, JAXBContext jaxbContext, int requestValidityInSeconds) {
        super(jaxbContext, requestValidityInSeconds, SOAP_ACTION_ISSUE);
        assert (tokenSpec != null);
        this._spec = tokenSpec;
        this._hokConfirmation = hokConfirmation;
    }

    @Override
    protected final Object createBody(org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory wstFactory) throws ParserException {
        RequestSecurityTokenType request = wstFactory.createRequestSecurityTokenType();
        request.setRequestType(REQUEST_TYPE_ISSUE);
        request.setLifetime(this.createLifetimeElement(this._spec.getTokenLifetime()));
        request.setTokenType("urn:oasis:names:tc:SAML:2.0:assertion");
        request.setRenewing(this.createRenewingElement(wstFactory));
        request.setSignatureAlgorithm(PREFFERED_SIGNATURE_ALG);
        this.setRequestKeyType(request);
        this.addAudienceRestriction(request, wstFactory);
        this.addAdvice(request);
        if (this._spec.getDelegationSpec() != null) {
            request.setDelegatable(this._spec.getDelegationSpec().isDelegable());
            if (this._spec.getDelegationSpec().getDelegateTo() != null) {
                DelegateToType delegateTo = wstFactory.createDelegateToType();
                delegateTo.setAny(this.createUsernameToken(this._spec.getDelegationSpec().getDelegateTo(), null));
                request.setDelegateTo(delegateTo);
            }
        }
        this.addRequestData(request, wstFactory);
        return request;
    }

    protected abstract void addRequestData(RequestSecurityTokenType var1, org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory var2);

    protected final UsernameTokenType createUsernameToken(String subject, String password) {
        ObjectFactory objFactory = new ObjectFactory();
        UsernameTokenType userNameToken = objFactory.createUsernameTokenType();
        AttributedString user = objFactory.createAttributedString();
        user.setValue(subject.toString());
        userNameToken.setUsername(user);
        if (password != null) {
            PasswordString pass = objFactory.createPasswordString();
            pass.setValue(password);
            userNameToken.getAny().add(pass);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Username token for user: " + subject + "created"));
        }
        return userNameToken;
    }

    private RenewingType createRenewingElement(org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory wstFactory) {
        RenewingType renewingType = wstFactory.createRenewingType();
        renewingType.setAllow(this._spec.isRenewable());
        renewingType.setOK(false);
        return renewingType;
    }

    private void setRequestKeyType(RequestSecurityTokenType request) {
        String keyType = this._spec.getConfirmation() == TokenSpec.Confirmation.DEFAULT && this._hokConfirmation ? HOLDER_OF_KEY_CONFIRMATION_TYPE : BEARER_CONFIRMATION_TYPE;
        request.setKeyType(keyType);
    }

    private void addAudienceRestriction(RequestSecurityTokenType request, org.oasis_open.docs.ws_sx.ws_trust._200512.ObjectFactory wstFactory) {
        if (!this._spec.getAudienceRestriction().isEmpty()) {
            ParticipantsType participants = wstFactory.createParticipantsType();
            List<ParticipantType> participantsList = participants.getParticipant();
            for (String participant : this._spec.getAudienceRestriction()) {
                org.w3._2005._08.addressing.ObjectFactory wsaFactory = new org.w3._2005._08.addressing.ObjectFactory();
                EndpointReferenceType endpoint = wsaFactory.createEndpointReferenceType();
                AttributedURIType address = wsaFactory.createAttributedURIType();
                address.setValue(participant);
                endpoint.setAddress(address);
                ParticipantType partElement = wstFactory.createParticipantType();
                partElement.setEndpointReference(endpoint);
                participantsList.add(partElement);
            }
            request.setParticipants(participants);
        }
    }

    private void addAdvice(RequestSecurityTokenType request) {
        if (!this._spec.getAdvice().isEmpty()) {
            com.rsa.names._2009._12.std_ext.ws_trust1_4.advice.ObjectFactory adviceFactory = new com.rsa.names._2009._12.std_ext.ws_trust1_4.advice.ObjectFactory();
            AdviceSetType adviceSet = adviceFactory.createAdviceSetType();
            for (Advice advice : this._spec.getAdvice()) {
                AdviceType wsAdvice = adviceFactory.createAdviceType();
                wsAdvice.setAdviceSource(advice.getSource());
                List<AttributeType> attributeList = wsAdvice.getAttribute();
                for (Advice.AdviceAttribute attribute : advice.getAttributes()) {
                    AttributeType attr = adviceFactory.createAttributeType();
                    attr.setName(attribute.getName());
                    for (String attributeValue : attribute.getValue()) {
                        attr.getAttributeValue().add(attributeValue);
                    }
                    attributeList.add(attr);
                }
                adviceSet.getAdvice().add(wsAdvice);
            }
            request.setAdviceSet(adviceSet);
        }
    }

    @Override
    protected String createRedactedDescription() {
        return this.getClass().getSimpleName() + " [tokenSpec=" + this._spec + ", hokConfirmation=" + this._hokConfirmation + "]";
    }
}

