/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin;

import com.vmware.vim.sso.admin.impl.util.ValidateUtil;
import java.util.Arrays;

public final class SmtpConfig {
    private final String _host;
    private final int _port;
    private final boolean _isAuthenticate;
    private final String _user;
    private final char[] _password;

    public SmtpConfig(String host, int port, boolean isAuthenticate, String user, char[] password) {
        ValidateUtil.validateNotNull(host, "SMTP server hostname");
        ValidateUtil.validatePositiveNumber(port, "SMTP port");
        this._host = host;
        this._port = port;
        this._isAuthenticate = isAuthenticate;
        this._user = user;
        this._password = password != null ? Arrays.copyOf(password, password.length) : null;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public boolean isAuthenticate() {
        return this._isAuthenticate;
    }

    public String getUser() {
        return this._user;
    }

    public char[] getPassword() {
        return this._password;
    }
}

