/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.exception;

import com.vmware.vim.sso.admin.exception.ServiceException;

public class GroupCyclicDependencyException
extends ServiceException {
    private static final long serialVersionUID = -2000985479801427514L;
    private final String groupBeingAdded;
    private final String existingGroup;

    public GroupCyclicDependencyException(String groupBeingAdded, String existingGroup) {
        super(GroupCyclicDependencyException.getDefaultMessage(groupBeingAdded, existingGroup));
        assert (null != groupBeingAdded);
        assert (null != existingGroup);
        this.groupBeingAdded = groupBeingAdded;
        this.existingGroup = existingGroup;
    }

    public static String getDefaultMessage(String groupBeingAdded, String existingGroup) {
        return "Cannot add group '" + groupBeingAdded + "' as a member of local group '" + existingGroup + "' as it is already a parent of that group.";
    }

    public GroupCyclicDependencyException(Throwable cause, String groupBeingAdded, String existingGroup) {
        super(GroupCyclicDependencyException.getDefaultMessage(groupBeingAdded, existingGroup));
        assert (null != groupBeingAdded);
        assert (null != existingGroup);
        this.groupBeingAdded = groupBeingAdded;
        this.existingGroup = existingGroup;
    }

    public String getGroupBeingAdded() {
        return this.groupBeingAdded;
    }

    public String getExistingGroup() {
        return this.existingGroup;
    }
}

