/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.impl.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ValidateUtil {
    public static void validatePositiveNumber(long fieldValue, String fieldName) {
        if (fieldValue <= 0L) {
            ValidateUtil.logAndThrow(String.format("%s should be a positive number: %d", fieldName, fieldValue));
        }
    }

    public static void validateRange(long fieldValue, String fieldName, long lower, long upper) {
        if (fieldValue < lower || fieldValue > upper) {
            ValidateUtil.logAndThrow(String.format("%s should in [%d-%d] but was %d", fieldName, lower, upper, fieldValue));
        }
    }

    public static void validateNotNull(Object fieldValue, String fieldName) {
        if (fieldValue == null) {
            ValidateUtil.logAndThrow(String.format("'%s' value should not be NULL", fieldName));
        }
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.getClass().equals(String.class)) {
            return ((String)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        String message = "String, java.lang.Array or java.util.Collection expected but " + obj.getClass().getName() + " was found ";
        ValidateUtil.getLog().error((Object)message);
        throw new IllegalArgumentException(message);
    }

    public static void validateNotEmpty(Object fieldValue, String fieldName) {
        if (ValidateUtil.isEmpty(fieldValue)) {
            ValidateUtil.logAndThrow(String.format("'%s' value should not be empty", fieldName));
        }
    }

    public static <T> T[] notNullValueOf(Class<T> clazz, T[] ... sources) {
        if (sources == null) {
            return ValidateUtil.newArray(clazz, 0);
        }
        if (sources.length == 1 && sources[0] != null) {
            return ValidateUtil.trimNulls(sources[0], clazz);
        }
        int totalSize = 0;
        for (T[] src : sources) {
            if (src == null) continue;
            totalSize += src.length;
        }
        T[] copyOfSources = ValidateUtil.newArray(clazz, totalSize);
        int copyPos = 0;
        for (T[] src : sources) {
            if (src == null) continue;
            System.arraycopy(src, 0, copyOfSources, copyPos, src.length);
            copyPos += src.length;
        }
        return ValidateUtil.trimNulls(copyOfSources, clazz);
    }

    private static void logAndThrow(String msg) {
        LogFactory.getLog(ValidateUtil.class).error((Object)msg);
        throw new IllegalArgumentException(msg);
    }

    private static Log getLog() {
        return LogFactory.getLog(ValidateUtil.class);
    }

    private ValidateUtil() {
    }

    private static <T> T[] trimNulls(T[] source, Class<T> clazz) {
        assert (source != null);
        assert (clazz != null);
        int nullsCount = 0;
        for (T data : source) {
            if (data != null) continue;
            ++nullsCount;
        }
        if (nullsCount == 0) {
            return source;
        }
        T[] trimmed = ValidateUtil.newArray(clazz, source.length - nullsCount);
        int i = 0;
        for (T data : source) {
            if (data == null) continue;
            trimmed[i++] = data;
        }
        assert (i == trimmed.length) : i + " <> " + trimmed.length;
        if (LogFactory.getLog(ValidateUtil.class).isDebugEnabled()) {
            LogFactory.getLog(ValidateUtil.class).debug((Object)("Null elements stripped from the array of " + clazz.getSimpleName() + ": " + Arrays.deepToString(source)));
        }
        return trimmed;
    }

    private static <T> T[] newArray(Class<T> clazz, int length) {
        return (Object[])Array.newInstance(clazz, length);
    }
}

