/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.admin.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import javax.naming.Name;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public final class EmptyUtil {
    private static final Log log = LogFactory.getLog(EmptyUtil.class);

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj.getClass() == String.class) {
            return EmptyUtil.isEmpty((String)obj);
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Name) {
            return ((Name)obj).getAll().hasMoreElements();
        }
        throw new IllegalArgumentException("Object or java.lang.Array expected but " + obj.getClass().getName() + " was found ");
    }

    public static void validateNotNull(Object fieldValue, String fieldName) throws IllegalArgumentException {
        if (fieldValue == null) {
            throw new IllegalArgumentException(String.format("'%s' value should not be NULL", fieldName));
        }
    }

    public static void validateNotEmpty(Object fieldValue, String fieldName) throws IllegalArgumentException {
        if (EmptyUtil.isEmpty(fieldValue)) {
            throw new IllegalArgumentException(String.format("'%s' value should not be empty", fieldName));
        }
    }

    public static <T> T[] notNullValueOf(Class<T> clazz, T[] ... sources) {
        if (sources == null) {
            return EmptyUtil.newArray(clazz, 0);
        }
        if (sources.length == 1 && sources[0] != null) {
            return EmptyUtil.trimNulls(sources[0], clazz);
        }
        int totalSize = 0;
        for (T[] src : sources) {
            if (src == null) continue;
            totalSize += src.length;
        }
        T[] copyOfSources = EmptyUtil.newArray(clazz, totalSize);
        int copyPos = 0;
        for (T[] src : sources) {
            if (src == null) continue;
            System.arraycopy(src, 0, copyOfSources, copyPos, src.length);
            copyPos += src.length;
        }
        return EmptyUtil.trimNulls(copyOfSources, clazz);
    }

    private EmptyUtil() {
    }

    private static <T> T[] trimNulls(T[] source, Class<T> clazz) {
        assert (source != null);
        assert (clazz != null);
        int nullsCount = 0;
        for (T data : source) {
            if (data != null) continue;
            ++nullsCount;
        }
        if (nullsCount == 0) {
            return source;
        }
        T[] trimmed = EmptyUtil.newArray(clazz, source.length - nullsCount);
        int i = 0;
        for (T data : source) {
            if (data == null) continue;
            trimmed[i++] = data;
        }
        assert (i == trimmed.length) : i + " <> " + trimmed.length;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Null elements stripped from the array of " + clazz.getSimpleName() + ": " + Arrays.deepToString(source)));
        }
        return trimmed;
    }

    private static <T> T[] newArray(Class<T> clazz, int length) {
        return (Object[])Array.newInstance(clazz, length);
    }
}

