@echo off

rem ##############################################################################
rem #
rem # Copyright (c) 2013 VMware, Inc. All rights reserved.
rem # -- VMware Confidential
rem #
rem ##############################################################################

rem set NGC_INSTALL_DIR by reading registry
set NGC_REG_KEY="HKEY_LOCAL_MACHINE\SOFTWARE\VMware, Inc.\VMware Infrastructure\vSphere Web Client"

rem check if reg entry exists
reg query %NGC_REG_KEY% 2>&1
if ERRORLEVEL 1 (
   goto :installCheckFail
)

set NGC_INSTALL_DIR=
for /f "tokens=1,2*" %%a in ('reg query %NGC_REG_KEY% /v "InstallPath"') do (
   if "%%a"=="InstallPath" (
      set "NGC_INSTALL_DIR=%%c"
   )
)

if "%NGC_INSTALL_DIR%"=="" (
   goto :installCheckFail
)

call "%~dp0common" The vSphere installation directory is set to "%NGC_INSTALL_DIR%"

if "%PROGRAMDATA%"=="" (
   set "DATA_DIR=%ALLUSERSPROFILE%\Application Data"
) else (
   set "DATA_DIR=%PROGRAMDATA%"
)

rem get ls url from registry
set NGC_LS_URL=
for /f "tokens=1,2*" %%a in ('reg query %NGC_REG_KEY% /v "LsUrl"') do (
   if "%%a"=="LsUrl" (
      set "NGC_LS_URL=%%c"
   )
)

if "%NGC_LS_URL%"=="" (
   set last_error=Cannot find the Lookup Service URL in the registry
   set EXIT_CODE=3
   goto :endFailure
)

call "%~dp0common" Lookup Service URL is set to "%NGC_LS_URL%"

set "ADMIN_USER=%sso_admin_user%"
set "ADMIN_PASS=%sso_admin_password%"

set "NGC_SSL_DIR=%DATA_DIR%\VMware\vSphere Web Client\ssl"
set "NGC_REG_TOOL_CMD=%NGC_INSTALL_DIR%\SsoRegTool\regTool.cmd"
set "NGC_SERVICE_ID_FILE=%NGC_INSTALL_DIR%\serviceId"
set "VMWARE_SSL_DIR=%DATA_DIR%\VMware\SSL"
set "DOT_STARTED=%NGC_INSTALL_DIR%\.started"

rem Strip spaces from JAVA_HOME
set JAVA_HOME=%JAVA_HOME:"=%
rem Check JAVA_HOME
if "%JAVA_HOME%"=="" (
   set last_error=JAVA_HOME variable is not set
   set EXIT_CODE=3
   goto :endFailure
)

rem validate LS connection, validate credentials, and save certs
call "%~dp0common" Validating Lookup Service connection and retrieving LS cert chain
call "%NGC_REG_TOOL_CMD%" validateLsConnection --cert "%VMWARE_SSL_DIR%" --ls-url "%NGC_LS_URL%" --username "%ADMIN_USER%" --password "%ADMIN_PASS%"
if NOT "%ERRORLEVEL%"=="0" (
   set last_error=Cannot validate the Lookup Service connection - errorlevel is %ERRORLEVEL%
   set EXIT_CODE=1
   goto :endFailure
)

rem Stop NGC
call "%~dp0common" Stopping the vSphere Web Client
echo Stopping the vSphere Web Client... 1>&2
net stop vspherewebclientsvc 2>&1
rem if already stopped, ignore error
if "%ERRORLEVEL%"=="2" (
   call "%~dp0common" The vSphere Web Client is already stopped.
   goto :serviceStopEndIf
)
if "%ERRORLEVEL%"=="0" (
   goto :serviceStopEndIf
)
set last_error=Failed to stop the vSphere Web Client due to error code %ERRORLEVEL%
set EXIT_CODE=1
goto :endFailure
:serviceStopEndIf
echo vSphere Web Client stopped. 1>&2

rem remove .started file
call "%~dp0common" Removing .started file
if EXIST "%DOT_STARTED%" (
   del /F "%DOT_STARTED%"
)

rem if service-id file does not exist, NGC is already unregistered
if NOT EXIST "%NGC_SERVICE_ID_FILE%" goto :register

rem unregister with SSO
call "%~dp0common" Unregistering vSphere Web Client from Single Sign-On
call "%NGC_REG_TOOL_CMD%" unregisterService -si "%NGC_SERVICE_ID_FILE%" -d "%NGC_LS_URL%" -u "%ADMIN_USER%" -p "%ADMIN_PASS%"
if "%ERRORLEVEL%"=="8" (
   call "%~dp0common" Service entry not found, skipping unregister
   goto :skipUnregister
)
if NOT "%ERRORLEVEL%"=="0" (
   set last_error=Cannot unregister vSphere Web Client from Single Sign-On - errorlevel is %ERRORLEVEL%
   set EXIT_CODE=1
   goto :endFailure
)

:skipUnregister
rem delete old service files
del /F "%NGC_SERVICE_ID_FILE%"

rem if NGC_CRT_PATH is set, this indicates that this is an SSL update
if NOT EXIST "%NGC_CRT_PATH%" goto :register

call "%~dp0common" Determining if the new Web Client certificate is already registered with Single Sign-On ...
rem check if new certificate is already registered with SSO
call "%NGC_REG_TOOL_CMD%" validateUsername -d %NGC_LS_URL% -u "%ADMIN_USER%" -p "%ADMIN_PASS%" -su GARBAGE_VALUE -sr "%NGC_CRT_PATH%"
rem returns 12 if the new certificate is already registered with SSO
if "%ERRORLEVEL%"=="12" (
	set last_error=New Web Client certificate is already registered with Single Sign-On. Use a unique certificate - errorlevel is %ERRORLEVEL%
   set EXIT_CODE=1
	goto :endFailure
)

:register
rem re-register with SSO
call "%~dp0common" Re-registering vSphere Web Client with Single Sign-On
call "%NGC_REG_TOOL_CMD%" registerService --cert "%NGC_SSL_DIR%" --ls-url "%NGC_LS_URL%" --username "%ADMIN_USER%" --password "%ADMIN_PASS%" --dir "%NGC_INSTALL_DIR%\SsoRegTool\sso_conf" --ip "*.*" --serviceId-file "%NGC_SERVICE_ID_FILE%"
if NOT "%ERRORLEVEL%"=="0" (
   set last_error=Cannot register vSphere Web Client with Single Sign-On - errorlevel is %ERRORLEVEL%
   set EXIT_CODE=1
   goto :endFailure
)

rem Start NGC and wait for deployment to finish
call "%~dp0ngcutils\start-and-wait.bat"
if ERRORLEVEL 1 (
   goto :endFailure
)

call "%~dp0common" The vSphere Web Client was started

set ADMIN_PASS=
set NGC_CRT_PATH=
call "%~dp0common" Successfully updated the vSphere Web Client Trust to Single Sign-On
exit /B 0

:endFailure
set ADMIN_PASS=
call "%~dp0common" "%last_error%"
exit /B %EXIT_CODE%

:installCheckFail
set last_error=Cannot find the vSphere Web Client installation directory in the registry
set EXIT_CODE=2
goto :endFailure
