@echo off

rem ##############################################################################
rem #
rem # Copyright (c) 2013 VMware, Inc. All rights reserved.
rem # -- VMware Confidential
rem #
rem ##############################################################################

if "%JAVA_HOME%" == "" (
   call "%~dp0common" Error: JAVA_HOME environment variable is not set.
   exit /B 1
)

set VCO_SSL_TOOL_JAR=%~dp0\vco-updater.jar
set VCO_SSL_TOOL_LOG=%LOGS_FOLDER%\vco-update-ssl.log

if "%1"=="-rollback" (
	call "%~dp0common" Rolling back to the previous settings
	"%JAVA_HOME%\bin\java" -Dvco.tool.log-file="%VCO_SSL_TOOL_LOG%" -jar "%VCO_SSL_TOOL_JAR%" -rollback
	if errorlevel 201 goto :exit201
	if errorlevel 3 goto :exit3

	goto :restarting
)

"%JAVA_HOME%\bin\java" -Dvco.tool.log-file="%VCO_SSL_TOOL_LOG%" -jar "%VCO_SSL_TOOL_JAR%" "%vco_cert_chain%" "%vco_private_key%"

if errorlevel 200 goto :exit200
if errorlevel 12 goto :exit12
if errorlevel 3 goto :exit3
if errorlevel 2 goto :exit2
if errorlevel 1 goto :exit1



:restarting
rem Restarting the Orchestrator. The unexisting service is an legitimate case
call "%~dp0common" Stopping Orchestrator Service...
net stop VMwareOrchestrator 2> nul
if errorlevel 1 goto :doneOrchestra
:reLoopO
ping loopback -n 2 -w 500 > nul
sc query VMwareOrchestrator | find " STOPPED"
if errorlevel 1 goto :reLoopO
call "%~dp0common" Starting Orchestrator Service...
sc start VMwareOrchestrator RUNNING
:reLoopOS
ping loopback -n 2 -w 500 > nul
sc query VMwareOrchestrator | find " RUNNING"
if not errorlevel 1 goto :doneOrchestra
sc query VMwareOrchestrator | find " STOPPED"
if not errorlevel 1 goto :exitOrchestra
goto :reLoopOS
:doneOrchestra

call "%~dp0common" Stopping Orchestrator Configuration Service...
net stop vCOConfiguration 2> nul
if errorlevel 1 goto :doneConfig
:reLoopC
ping loopback -n 2 -w 500 > nul
sc query vCOConfiguration | find " STOPPED"
if errorlevel 1 goto :reLoopC
call "%~dp0common" Starting Orchestrator Configuration Service...
sc start vCOConfiguration RUNNING
:reLoopOC
ping loopback -n 2 -w 500 > nul
sc query vCOConfiguration | find " RUNNING"
if not errorlevel 1 goto :doneConfig
sc query vCOConfiguration | find " START_PENDING"
if not errorlevel 1 goto :reLoopOC
sc query vCOConfiguration | find " STOPPED"
if not errorlevel 1 goto :exitConfig
goto :reLoopOC
:doneConfig

call "%~dp0common" Successfully updated the vCenter Orchestrator SSL certificate
exit /b 0

:exit201
set last_error=Cannot restore the vCenter Orchestrator keystore
exit /b 1

:exit200
set last_error=Cannot backup the vCenter Orchestrator keystore
exit /b 1

:exit12
set last_error=The certificate is already registered
exit /b 12

:exit3
set last_error=Cannot find the input files
exit /b 3

:exit2
set last_error=Cannot find vCenter Orchestrator
exit /b 2

:exit1
set last_error=Cannot read the new SSL key pair for vCenter Orchestrator
exit /b 1

:exitConfig
set last_error=Cannot restart the vCenter Orchestrator Configuration service
sc query vCOConfiguration | find /I "STATE"
exit /b 1

:exitOrchestra
set last_error=Cannot restart vCenter Orchestrator Server
sc query VMwareOrchestrator | find /I "STATE"
exit /b 1

