@echo off

REM **********************************************************
REM Copyright 2011 VMware, Inc.  All rights reserved
REM **********************************************************

REM
REM VC to Inventory Service registration script
REM
REM Run as:
REM
REM  register-is.bat <vCenter Server URL>
REM                  <Inventory Service URL>
REM                  <Lookup Service URL>
REM

if "%3" == "" (
   goto :badUsage
)

if NOT("%4" == "") (
   goto :badUsage
)

for /f "delims=" %%x in ('cscript //nologo GetAppDataDir.vbs') do @set DATA_DIR=%%x
set DATA_DIR=%DATA_DIR%\VMware\VMware VirtualCenter
echo Using Program data directory %DATA_DIR%

set PROGRAM_DIR=%~dp0..
echo Using Program files directory %PROGRAM_DIR%

set COMMAND="%~dp0vcregtool.bat" -action register -vcurl %1 -isurl %2 -lookupserviceurl %3 -vccert "%DATA_DIR%\SSL\sso.crt" -vcprivkey "%DATA_DIR%\SSL\sso.key" -vcinstancecfg "%DATA_DIR%\instance.cfg" -vcendpointsdir "%PROGRAM_DIR%\endpoints" -vcextensionsdir "%PROGRAM_DIR%\extensions" -vcforceregister true
REM echo Running command: %COMMAND%
call %COMMAND%

goto :end

:badUsage
   echo Wrong number of arguments
   echo Usage:
   echo register-is.bat ^<vCenter Server URL^> ^<Inventory Service URL^> ^<Lookup Service URL^>
   exit /B -1

:end
   echo %ERRORLEVEL%
   exit /B %ERRORLEVEL%exit: 0
