SET NUMERIC_ROUNDABORT OFF
GO
SET ANSI_PADDING, ANSI_WARNINGS, CONCAT_NULL_YIELDS_NULL, ARITHABORT, QUOTED_IDENTIFIER, ANSI_NULLS ON
GO
IF EXISTS (SELECT * FROM tempdb..sysobjects WHERE id=OBJECT_ID('tempdb..#tmpErrors')) DROP TABLE #tmpErrors
GO
CREATE TABLE #tmpErrors (Error int)
GO
SET XACT_ABORT ON
GO
SET TRANSACTION ISOLATION LEVEL SERIALIZABLE
GO

PRINT N'Updating foreign keys to [dbo].[UserLog]'
GO
UPDATE [dbo].[UserLog]
SET GroupID = NULL
WHERE GroupID NOT IN ( SELECT Distinct GroupID FROM [dbo].[ProvisioningGroup] ) 
GO

ALTER TABLE [dbo].[UserLog] 
DROP CONSTRAINT [FK_UserLog_Group]
GO

ALTER TABLE [dbo].[UserLog] ADD
CONSTRAINT [FK_UserLog_Group] FOREIGN KEY ([GroupID]) REFERENCES [dbo].[ProvisioningGroup] ([GroupID]) ON DELETE SET NULL
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO

PRINT N'Updating Reports Stored Procedures.'
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_ReportCapacityUsageByHostGrid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_ReportCapacityUsageByHostGrid]
GO
CREATE PROCEDURE [dbo].[usp_ReportCapacityUsageByHostGrid]
	@hostName NVarChar(1024) = NULL
AS
BEGIN
-- Region Parameters
DECLARE @p0 NVarChar(1000) = 'Yes'
DECLARE @p1 NVarChar(1000) = 'No'
DECLARE @p2 NVarChar(1000) = 'On'
DECLARE @p3 Float = 1024
DECLARE @p4 Float = 1024
DECLARE @p5 Float = 0
DECLARE @p6 BigInt = 0
DECLARE @p7 Float = 0
DECLARE @p8 Float = 100
DECLARE @p9 Float = 0
DECLARE @p10 Float = 1024
DECLARE @p11 Float = 0
DECLARE @p12 BigInt = 0
DECLARE @p13 Float = 0
DECLARE @p14 BigInt = 100
DECLARE @p15 Float = 0
DECLARE @p16 Float = 1024
DECLARE @p17 Float = 1024
DECLARE @p18 Float = 0
DECLARE @p19 BigInt = 0
DECLARE @p20 Float = 0
DECLARE @p21 BigInt = 100
DECLARE @p22 Float = 0
DECLARE @p23 Float = 1024
DECLARE @p24 Float = 0
DECLARE @p25 BigInt = 0
DECLARE @p26 Float = 0
DECLARE @p27 BigInt = 100
DECLARE @p28 Float = 0
DECLARE @p29 Float = 1024
DECLARE @p30 NVarChar(1024) = @hostName
DECLARE @p31 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
-- EndRegion
SELECT [t24].[HostName], [t24].[value] AS [NumOfVMsCreated], [t24].[value2] AS [IsManaged], [t24].[value3] AS [NumOfVMsPoweredOn], [t24].[value4] AS [HostProcessors], [t24].[value5] AS [HostTotalMemoryGB], [t24].[value6] AS [HostReservedMemoryGB], [t24].[value7] AS [PercentMemoryReserved], [t24].[value8] AS [HostAllocatedMemoryGB], [t24].[value9] AS [PercentMemoryAllocated], [t24].[value10] AS [HostTotalStorageTB], [t24].[value11] AS [HostReservedStorageTB], [t24].[value12] AS [PercentStorageReserved], [t24].[value13] AS [HostAllocatedStorageTB], [t24].[value14] AS [PercentStorageAllocated], [t24].[value15] AS [HostUsedFlCloneStorageTB]
FROM (
    SELECT [t0].[HostName], (
        SELECT COUNT(*)
        FROM [VirtualMachine] AS [t1]
        WHERE (NOT ([t1].[IsTemplate] = 1)) AND ([t1].[HostID] = [t0].[HostID])
        ) AS [value], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [AdminGroupToHost] AS [t2]
                WHERE [t2].[HostID] = [t0].[HostID]
                ) THEN @p0
            ELSE CONVERT(NVarChar(3),@p1)
         END) AS [value2], (
        SELECT COUNT(*)
        FROM [VirtualMachine] AS [t3]
        WHERE ([t3].[VirtualMachineState] = @p2) AND ([t3].[HostID] = [t0].[HostID])
        ) AS [value3], COALESCE([t0].[HostProcessors],0) AS [value4], (CONVERT(Float,COALESCE([t0].[HostTotalMemoryMB],0))) / @p3 AS [value5], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t4]
                WHERE [t4].[HostID] = [t0].[HostID]
                ) THEN (CONVERT(Float,(
                SELECT SUM([t6].[value])
                FROM (
                    SELECT COALESCE([t5].[ReservationMemorySizeMB],0) AS [value], [t5].[HostID]
                    FROM [HostReservation] AS [t5]
                    ) AS [t6]
                WHERE [t6].[HostID] = [t0].[HostID]
                ))) / @p4
            ELSE @p5
         END) AS [value6], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t7]
                WHERE [t7].[HostID] = [t0].[HostID]
                ) THEN 
                (CASE 
                    WHEN (COALESCE([t0].[HostTotalMemoryMB],0)) = @p6 THEN @p7
                    ELSE @p8 * (CONVERT(Float,((
                        SELECT SUM([t9].[value])
                        FROM (
                            SELECT COALESCE([t8].[ReservationMemorySizeMB],0) AS [value], [t8].[HostID]
                            FROM [HostReservation] AS [t8]
                            ) AS [t9]
                        WHERE [t9].[HostID] = [t0].[HostID]
                        )) / (COALESCE([t0].[HostTotalMemoryMB],0))))
                 END)
            ELSE @p9
         END) AS [value7], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t10]
                WHERE [t10].[HostID] = [t0].[HostID]
                ) THEN (CONVERT(Float,(
                SELECT SUM([t11].[MemoryAllocated])
                FROM [HostReservation] AS [t11]
                WHERE [t11].[HostID] = [t0].[HostID]
                ))) / @p10
            ELSE @p11
         END) AS [value8], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t12]
                WHERE [t12].[HostID] = [t0].[HostID]
                ) THEN 
                (CASE 
                    WHEN (COALESCE([t0].[HostTotalMemoryMB],0)) = @p12 THEN @p13
                    ELSE (CONVERT(Float,@p14 * ((
                        SELECT SUM([t13].[MemoryAllocated])
                        FROM [HostReservation] AS [t13]
                        WHERE [t13].[HostID] = [t0].[HostID]
                        )))) / (CONVERT(Float,COALESCE([t0].[HostTotalMemoryMB],0)))
                 END)
            ELSE @p15
         END) AS [value9], (CONVERT(Float,COALESCE([t0].[HostTotalStorageGB],0))) / @p16 AS [value10], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t14]
                WHERE [t14].[HostID] = [t0].[HostID]
                ) THEN (CONVERT(Float,(
                SELECT SUM([t16].[value])
                FROM (
                    SELECT COALESCE([t15].[ReservationStorageSizeGB],0) AS [value], [t15].[HostID]
                    FROM [HostReservation] AS [t15]
                    ) AS [t16]
                WHERE [t16].[HostID] = [t0].[HostID]
                ))) / @p17
            ELSE @p18
         END) AS [value11], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t17]
                WHERE [t17].[HostID] = [t0].[HostID]
                ) THEN 
                (CASE 
                    WHEN (COALESCE([t0].[HostTotalStorageGB],0)) = @p19 THEN @p20
                    ELSE (CONVERT(Float,@p21 * ((
                        SELECT SUM([t19].[value])
                        FROM (
                            SELECT COALESCE([t18].[ReservationStorageSizeGB],0) AS [value], [t18].[HostID]
                            FROM [HostReservation] AS [t18]
                            ) AS [t19]
                        WHERE [t19].[HostID] = [t0].[HostID]
                        )))) / (CONVERT(Float,COALESCE([t0].[HostTotalStorageGB],0)))
                 END)
            ELSE @p22
         END) AS [value12], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t20]
                WHERE [t20].[HostID] = [t0].[HostID]
                ) THEN (CONVERT(Float,(
                SELECT SUM([t21].[StorageAllocated])
                FROM [HostReservation] AS [t21]
                WHERE [t21].[HostID] = [t0].[HostID]
                ))) / @p23
            ELSE @p24
         END) AS [value13], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t22]
                WHERE [t22].[HostID] = [t0].[HostID]
                ) THEN 
                (CASE 
                    WHEN (COALESCE([t0].[HostTotalStorageGB],0)) = @p25 THEN @p26
                    ELSE (CONVERT(Float,@p27 * ((
                        SELECT SUM([t23].[StorageAllocated])
                        FROM [HostReservation] AS [t23]
                        WHERE [t23].[HostID] = [t0].[HostID]
                        )))) / (CONVERT(Float,COALESCE([t0].[HostTotalStorageGB],0)))
                 END)
            ELSE @p28
         END) AS [value14], (CONVERT(Float,COALESCE([t0].[HostUsedStorageGB],0))) / @p29 AS [value15], [t0].[ClusterHostID], [t0].[HostID]
    FROM [Host] AS [t0]
    ) AS [t24]
WHERE ([t24].[ClusterHostID] IS NULL) AND (([t24].[HostName] = @p30) OR (@p30 IS NULL)) AND ([t24].[HostID] <> @p31)
ORDER BY [t24].[HostName]
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_ReportCapacityUsageByProvisioningGroupVirtualGrid]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_ReportCapacityUsageByProvisioningGroupVirtualGrid]
GO
CREATE PROCEDURE [dbo].[usp_ReportCapacityUsageByProvisioningGroupVirtualGrid]
	@groupName NVarChar(1024) = NULL
AS
BEGIN
-- Region Parameters
DECLARE @p0 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p1 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p2 Float = 1024
DECLARE @p3 Float = 0
DECLARE @p4 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p5 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p6 Float = 1024
DECLARE @p7 Float = 0
DECLARE @p8 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p9 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p10 BigInt = 0
DECLARE @p11 Float = 0
DECLARE @p12 BigInt = 100
DECLARE @p13 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p14 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p15 Float = 0
DECLARE @p16 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p17 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p18 Decimal(4,0) = 1024
DECLARE @p19 Decimal(1,0) = 0
DECLARE @p20 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p21 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p22 Float = 1024
DECLARE @p23 Float = 0
DECLARE @p24 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p25 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p26 Float = 1024
DECLARE @p27 Float = 0
DECLARE @p28 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p29 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p30 BigInt = 0
DECLARE @p31 Float = 0
DECLARE @p32 BigInt = 100
DECLARE @p33 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p34 UniqueIdentifier = '00000000-0000-0000-0000-000000000000'
DECLARE @p35 Float = 0
DECLARE @p36 NVarChar(1024) = @groupName
DECLARE @p37 Int = 0
-- EndRegion
SELECT [t23].[GroupName], [t23].[value] AS [GroupReservedStorageTB], [t23].[value2] AS [GroupUsedStorageTB], [t23].[value3] AS [PercentStorageAllocated], [t23].[value4] AS [GroupUsedFlCloneStorageTB], [t23].[value5] AS [GroupReservedMemoryGB], [t23].[value6] AS [GroupUsedMemoryGB], [t23].[value7] AS [PercentMemoryAllocated]
FROM (
    SELECT [t0].[GroupName], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t1]
                WHERE ([t1].[HostID] <> @p0) AND ([t1].[GroupID] = [t0].[GroupID])
                ) THEN (CONVERT(Float,(
                SELECT SUM([t3].[value])
                FROM (
                    SELECT COALESCE([t2].[ReservationStorageSizeGB],0) AS [value], [t2].[HostID], [t2].[GroupID]
                    FROM [HostReservation] AS [t2]
                    ) AS [t3]
                WHERE ([t3].[HostID] <> @p1) AND ([t3].[GroupID] = [t0].[GroupID])
                ))) / @p2
            ELSE @p3
         END) AS [value], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t4]
                WHERE ([t4].[HostID] <> @p4) AND ([t4].[GroupID] = [t0].[GroupID])
                ) THEN (CONVERT(Float,(
                SELECT SUM([t5].[StorageAllocated])
                FROM [HostReservation] AS [t5]
                WHERE ([t5].[HostID] <> @p5) AND ([t5].[GroupID] = [t0].[GroupID])
                ))) / @p6
            ELSE @p7
         END) AS [value2], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t6]
                WHERE ([t6].[HostID] <> @p8) AND ([t6].[GroupID] = [t0].[GroupID])
                ) THEN 
                (CASE 
                    WHEN ((
                        SELECT SUM([t8].[value])
                        FROM (
                            SELECT COALESCE([t7].[ReservationStorageSizeGB],0) AS [value], [t7].[HostID], [t7].[GroupID]
                            FROM [HostReservation] AS [t7]
                            ) AS [t8]
                        WHERE ([t8].[HostID] <> @p9) AND ([t8].[GroupID] = [t0].[GroupID])
                        )) = @p10 THEN @p11
                    ELSE (CONVERT(Float,@p12 * ((
                        SELECT SUM([t9].[StorageAllocated])
                        FROM [HostReservation] AS [t9]
                        WHERE ([t9].[HostID] <> @p13) AND ([t9].[GroupID] = [t0].[GroupID])
                        )))) / (CONVERT(Float,(
                        SELECT SUM([t11].[value])
                        FROM (
                            SELECT COALESCE([t10].[ReservationStorageSizeGB],0) AS [value], [t10].[HostID], [t10].[GroupID]
                            FROM [HostReservation] AS [t10]
                            ) AS [t11]
                        WHERE ([t11].[HostID] <> @p14) AND ([t11].[GroupID] = [t0].[GroupID])
                        )))
                 END)
            ELSE @p15
         END) AS [value3], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t12]
                WHERE ([t12].[HostID] <> @p16) AND ([t12].[GroupID] = [t0].[GroupID])
                ) THEN ((
                SELECT SUM([t13].[StorageUsed])
                FROM [HostReservation] AS [t13]
                WHERE ([t13].[HostID] <> @p17) AND ([t13].[GroupID] = [t0].[GroupID])
                )) / @p18
            ELSE @p19
         END) AS [value4], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t14]
                WHERE ([t14].[HostID] <> @p20) AND ([t14].[GroupID] = [t0].[GroupID])
                ) THEN (CONVERT(Float,COALESCE((
                SELECT SUM([t15].[ReservationMemorySizeMB])
                FROM [HostReservation] AS [t15]
                WHERE ([t15].[HostID] <> @p21) AND ([t15].[GroupID] = [t0].[GroupID])
                ),0))) / @p22
            ELSE @p23
         END) AS [value5], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t16]
                WHERE ([t16].[HostID] <> @p24) AND ([t16].[GroupID] = [t0].[GroupID])
                ) THEN (CONVERT(Float,(
                SELECT SUM([t17].[MemoryAllocated])
                FROM [HostReservation] AS [t17]
                WHERE ([t17].[HostID] <> @p25) AND ([t17].[GroupID] = [t0].[GroupID])
                ))) / @p26
            ELSE @p27
         END) AS [value6], 
        (CASE 
            WHEN EXISTS(
                SELECT NULL AS [EMPTY]
                FROM [HostReservation] AS [t18]
                WHERE ([t18].[HostID] <> @p28) AND ([t18].[GroupID] = [t0].[GroupID])
                ) THEN 
                (CASE 
                    WHEN ((
                        SELECT SUM([t19].[MemoryAllocated])
                        FROM [HostReservation] AS [t19]
                        WHERE ([t19].[HostID] <> @p29) AND ([t19].[GroupID] = [t0].[GroupID])
                        )) = @p30 THEN @p31
                    ELSE (CONVERT(Float,@p32 * ((
                        SELECT SUM([t20].[MemoryAllocated])
                        FROM [HostReservation] AS [t20]
                        WHERE ([t20].[HostID] <> @p33) AND ([t20].[GroupID] = [t0].[GroupID])
                        )))) / (CONVERT(Float,(
                        SELECT SUM([t22].[value])
                        FROM (
                            SELECT COALESCE([t21].[ReservationMemorySizeMB],0) AS [value], [t21].[HostID], [t21].[GroupID]
                            FROM [HostReservation] AS [t21]
                            ) AS [t22]
                        WHERE ([t22].[HostID] <> @p34) AND ([t22].[GroupID] = [t0].[GroupID])
                        )))
                 END)
            ELSE @p35
         END) AS [value7], [t0].[GroupType]
    FROM [ProvisioningGroup] AS [t0]
    ) AS [t23]
WHERE (([t23].[GroupName] = @p36) OR (@p36 IS NULL)) AND ([t23].[GroupType] = @p37)
ORDER BY [t23].[GroupName]
END
GO
IF @@ERROR<>0 AND @@TRANCOUNT>0 ROLLBACK TRANSACTION
GO
IF @@TRANCOUNT=0 BEGIN INSERT INTO #tmpErrors (Error) SELECT 1 BEGIN TRANSACTION END
GO

IF @@TRANCOUNT>0 BEGIN
PRINT 'The database update succeeded'
COMMIT TRANSACTION
END
ELSE PRINT 'The database update failed'
GO
DROP TABLE #tmpErrors
GO