#!/usr/bin/python
import sys
from bag import Bag
from hostname import Hostname

hostname_file = '/etc/sysconfig/network'
if len(sys.argv) > 1:
    hostname_file = sys.argv[1]

h = Hostname(Bag('properties.xml'))

lines = []
lines.append("HOSTNAME=%s\n" % h.get_hostname())
for line in open(hostname_file):
    if not line.startswith("HOSTNAME"):
        lines.append(line)

open(hostname_file, 'w').write("".join(lines))

# vim: ts=4 sw=4 et
