#!/bin/bash

path=/usr/share/gugent/rungugent.sh
VRMServer=$1
IsSSL=$2
sslparam=""

if [ "$IsSSL" == "ssl" ]; then
sslparam="--ssl"
fi

echo '#!/bin/bash' > $path
echo 'export AXIS2C_HOME=axis2' >> $path
echo 'export LD_LIBRARY_PATH=axis2/lib' >> $path
echo 'export PYTHONPATH=/usr/share/gugent/site/dops' >> $path
echo 'while true; do' >> $path
echo "/usr/bin/gugent --host=$VRMServer $sslparam --config=/usr/share/gugent/gugent.properties --script=/usr/share/gugent/site" >> $path
echo 'rc=$?' >> $path
echo 'if [ $rc -eq 255 ]; then' >> $path
echo 'break' >> $path
echo 'fi' >> $path
echo 'sleep 30' >> $path
echo 'done' >> $path

chmod a+x vrm-agent
chmod a+x vrm-agentd
chmod a+x /usr/bin/gugent
chmod a+x VRM_daemon.pl
chmod a+x rungugent.sh

cp vrm-agent /etc/init.d
/sbin/chkconfig --add vrm-agent
mkdir /usr/share/log

exit 0
