class Hostname:
    def __init__(self, bag):
        self.bag = bag

    def name(self):
        return "VirtualMachine.Admin.Name"

    def default_network_offset(self):
        return "VirtualMachine.Network.Default"

    def is_default_network_offset(self):
        return self.bag.has_key(self.default_network_offset())

    def default_dns_suffix(self):
        return "VirtualMachine.Network%s.DnsSuffix" % self.bag[self.default_network_offset()]

    def is_default_dns_suffix(self):
        return self.bag.has_key(self.default_dns_suffix())

    def get_dns_suffix(self):
        if not self.is_default_network_offset() or not self.is_default_dns_suffix():
            return ''

        default_network_offset = self.bag[self.default_network_offset()]
        return ".%s" % self.bag[self.default_dns_suffix()]

    def get_hostname(self):
        return "%s%s" % (self.bag[self.name()], self.get_dns_suffix())

# vim: sw=4 ts=4 et
