from bag import Bag

class ResolvConf:
    def __init__(self, bag, offset):
        self.bag = bag
        self.offset = offset

    def dns_search_suffixes(self):
        return "VirtualMachine.Network%s.DnsSearchSuffixes" % self.offset

    def is_dns_search_suffixes(self):
        return self.bag.has_key(self.dns_search_suffixes())

    def primary_dns(self):
        return "VirtualMachine.Network%s.PrimaryDns" % self.offset

    def is_primary_dns(self):
        return self.bag.has_key(self.primary_dns())

    def secondary_dns(self):
        return "VirtualMachine.Network%s.SecondaryDns" % self.offset

    def is_secondary_dns(self):
        return self.bag.has_key(self.secondary_dns())

    def get_nameserver_lines(self, lines):
        lines.append("nameserver %s" % self.bag[self.primary_dns()])
        if self.is_secondary_dns():
            lines.append("nameserver %s" % self.bag[self.secondary_dns()])

        return lines

    def get_search_line(self):
        return "search %s" % self.bag[self.dns_search_suffixes()]

    def lines(self, resolv_conf_lines):
        lines = []
        for line in resolv_conf_lines:
            if self.is_primary_dns() and line.startswith('nameserver'):
                continue
            elif self.is_dns_search_suffixes() and line.startswith('search'):
                continue
            else:
                lines.append(line.strip())

        if self.is_primary_dns():
            self.get_nameserver_lines(lines)
        if self.is_dns_search_suffixes():
            lines.append(self.get_search_line())

        return lines

# vim: sw=4 ts=4 et
