
-- --------------------------------------------------
-- Entity Designer DDL Script for SQL Server 2005, 2008, and Azure
-- --------------------------------------------------
-- Date Created: 04/23/2012 10:08:29
-- Generated from EDMX file: C:\TFS\branches\Trunk\src\models\AmazonWSModel\DynamicOps.AmazonWSModel\AmazonWSModelEntities.edmx
-- --------------------------------------------------

SET QUOTED_IDENTIFIER OFF;
GO
IF SCHEMA_ID(N'DynamicOps.AmazonWSModel') IS NULL EXECUTE(N'CREATE SCHEMA [DynamicOps.AmazonWSModel]');
GO

-- --------------------------------------------------
-- Dropping existing FOREIGN KEY constraints
-- --------------------------------------------------

IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_AvailabilityZoneRegion]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[AvailabilityZones] DROP CONSTRAINT [FK_AvailabilityZoneRegion];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_KeyPairRegion]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[KeyPairs] DROP CONSTRAINT [FK_KeyPairRegion];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_RegionAccessKey]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[Regions] DROP CONSTRAINT [FK_RegionAccessKey];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_RegionImage_Region]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[RegionImage] DROP CONSTRAINT [FK_RegionImage_Region];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_RegionImage_Image]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[RegionImage] DROP CONSTRAINT [FK_RegionImage_Image];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_AvailabilityZoneElasticBlockStorageVolume]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticBlockStorageVolumes] DROP CONSTRAINT [FK_AvailabilityZoneElasticBlockStorageVolume];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_AvailabilityZoneSubnet]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[Subnets] DROP CONSTRAINT [FK_AvailabilityZoneSubnet];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_VirtualPrivateCloudSubnet]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[Subnets] DROP CONSTRAINT [FK_VirtualPrivateCloudSubnet];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_ElasticLoadBalancerSubnet_ElasticLoadBalancer]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerSubnet] DROP CONSTRAINT [FK_ElasticLoadBalancerSubnet_ElasticLoadBalancer];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_ElasticLoadBalancerSubnet_Subnet]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerSubnet] DROP CONSTRAINT [FK_ElasticLoadBalancerSubnet_Subnet];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_VirtualPrivateCloudSecurityGroup]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[SecurityGroups] DROP CONSTRAINT [FK_VirtualPrivateCloudSecurityGroup];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_ElasticLoadBalancerAvailabilityZone_ElasticLoadBalancer]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerAvailabilityZone] DROP CONSTRAINT [FK_ElasticLoadBalancerAvailabilityZone_ElasticLoadBalancer];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_ElasticLoadBalancerAvailabilityZone_AvailabilityZone]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerAvailabilityZone] DROP CONSTRAINT [FK_ElasticLoadBalancerAvailabilityZone_AvailabilityZone];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_SecurityGroupRegion]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[SecurityGroups] DROP CONSTRAINT [FK_SecurityGroupRegion];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_ElasticIpAddressRegion]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticIpAddresses] DROP CONSTRAINT [FK_ElasticIpAddressRegion];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_ListenersElasticLoadBalancer]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[Listeners] DROP CONSTRAINT [FK_ListenersElasticLoadBalancer];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_CloudReservationSecurityGroup_CloudReservation]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationSecurityGroup] DROP CONSTRAINT [FK_CloudReservationSecurityGroup_CloudReservation];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_CloudReservationSecurityGroup_SecurityGroup]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationSecurityGroup] DROP CONSTRAINT [FK_CloudReservationSecurityGroup_SecurityGroup];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_CloudReservationSubnet_CloudReservation]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationSubnet] DROP CONSTRAINT [FK_CloudReservationSubnet_CloudReservation];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_CloudReservationSubnet_Subnet]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationSubnet] DROP CONSTRAINT [FK_CloudReservationSubnet_Subnet];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_CloudReservationAvailabilityZone_CloudReservation]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationAvailabilityZone] DROP CONSTRAINT [FK_CloudReservationAvailabilityZone_CloudReservation];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_CloudReservationAvailabilityZone_AvailabilityZone]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationAvailabilityZone] DROP CONSTRAINT [FK_CloudReservationAvailabilityZone_AvailabilityZone];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_CloudBlueprintInstanceType_CloudBlueprint]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[CloudBlueprintInstanceType] DROP CONSTRAINT [FK_CloudBlueprintInstanceType_CloudBlueprint];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_CloudBlueprintInstanceType_InstanceType]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[CloudBlueprintInstanceType] DROP CONSTRAINT [FK_CloudBlueprintInstanceType_InstanceType];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_CloudBlueprintImage]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[AmazonVirtualMachineTemplates] DROP CONSTRAINT [FK_CloudBlueprintImage];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_ElasticLoadBalancerElasticLoadBalancerInstanceState]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerInstanceStates] DROP CONSTRAINT [FK_ElasticLoadBalancerElasticLoadBalancerInstanceState];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_InstanceElasticLoadBalancerInstanceState]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerInstanceStates] DROP CONSTRAINT [FK_InstanceElasticLoadBalancerInstanceState];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_InstanceSubnet]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[Instances] DROP CONSTRAINT [FK_InstanceSubnet];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_InstanceElasticIpAddress]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticIpAddresses] DROP CONSTRAINT [FK_InstanceElasticIpAddress];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_InstanceElasticBlockStorageVolume]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticBlockStorageVolumes] DROP CONSTRAINT [FK_InstanceElasticBlockStorageVolume];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_RegionVirtualPrivateCloud]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[VirtualPrivateClouds] DROP CONSTRAINT [FK_RegionVirtualPrivateCloud];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_InstanceAvailabilityZone]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[Instances] DROP CONSTRAINT [FK_InstanceAvailabilityZone];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_RegionElasticLoadBalancer]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancers] DROP CONSTRAINT [FK_RegionElasticLoadBalancer];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_InstanceKeyPair]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[Instances] DROP CONSTRAINT [FK_InstanceKeyPair];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_AmazonHostReservationKeyPair]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservations] DROP CONSTRAINT [FK_AmazonHostReservationKeyPair];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_InstanceSecurityGroup_Instance]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[InstanceSecurityGroup] DROP CONSTRAINT [FK_InstanceSecurityGroup_Instance];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_InstanceSecurityGroup_SecurityGroup]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[InstanceSecurityGroup] DROP CONSTRAINT [FK_InstanceSecurityGroup_SecurityGroup];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_AmazonHostReservationElasticLoadBalancer_AmazonHostReservation]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservationElasticLoadBalancer] DROP CONSTRAINT [FK_AmazonHostReservationElasticLoadBalancer_AmazonHostReservation];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[FK_AmazonHostReservationElasticLoadBalancer_ElasticLoadBalancer]', 'F') IS NOT NULL
    ALTER TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservationElasticLoadBalancer] DROP CONSTRAINT [FK_AmazonHostReservationElasticLoadBalancer_ElasticLoadBalancer];
GO

-- --------------------------------------------------
-- Dropping existing tables
-- --------------------------------------------------

IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[Images]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[Images];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[SecurityGroups]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[SecurityGroups];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[KeyPairs]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[KeyPairs];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[AvailabilityZones]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[AvailabilityZones];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[AccessKeys]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[AccessKeys];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[InstanceTypes]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[InstanceTypes];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[Regions]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[Regions];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[ElasticLoadBalancers]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancers];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[VirtualPrivateClouds]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[VirtualPrivateClouds];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[ElasticBlockStorageVolumes]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[ElasticBlockStorageVolumes];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[Subnets]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[Subnets];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[ElasticIpAddresses]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[ElasticIpAddresses];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[Listeners]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[Listeners];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[AmazonHostReservations]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservations];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[AmazonVirtualMachineTemplates]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[AmazonVirtualMachineTemplates];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[Instances]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[Instances];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[ElasticLoadBalancerInstanceStates]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerInstanceStates];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[RegionImage]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[RegionImage];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[ElasticLoadBalancerSubnet]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerSubnet];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[ElasticLoadBalancerAvailabilityZone]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerAvailabilityZone];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[CloudReservationSecurityGroup]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[CloudReservationSecurityGroup];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[CloudReservationSubnet]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[CloudReservationSubnet];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[CloudReservationAvailabilityZone]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[CloudReservationAvailabilityZone];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[CloudBlueprintInstanceType]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[CloudBlueprintInstanceType];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[InstanceSecurityGroup]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[InstanceSecurityGroup];
GO
IF OBJECT_ID(N'[DynamicOps.AmazonWSModel].[AmazonHostReservationElasticLoadBalancer]', 'U') IS NOT NULL
    DROP TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservationElasticLoadBalancer];
GO

-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'Images'
CREATE TABLE [DynamicOps.AmazonWSModel].[Images] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [AmazonImageId] nvarchar(127)  NOT NULL,
    [Location] nvarchar(511)  NOT NULL,
    [ImageState] nvarchar(127)  NULL,
    [AmazonOwnerId] nvarchar(127)  NULL,
    [IsPublic] bit  NOT NULL,
    [ImageType] nvarchar(127)  NULL,
    [AmazonKernelId] nvarchar(127)  NULL,
    [AmazonRamdiskId] nvarchar(127)  NULL,
    [OwnerAlias] nvarchar(127)  NULL,
    [Name] nvarchar(511)  NULL,
    [Description] nvarchar(255)  NULL,
    [RootDeviceType] nvarchar(127)  NULL,
    [RootDeviceName] nvarchar(127)  NULL,
    [PlatformName] nvarchar(127)  NULL,
    [ArchitectureName] nvarchar(127)  NULL,
    [RegionName] nvarchar(127)  NULL
);
GO

-- Creating table 'SecurityGroups'
CREATE TABLE [DynamicOps.AmazonWSModel].[SecurityGroups] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(127)  NOT NULL,
    [Description] nvarchar(255)  NOT NULL,
    [AmazonOwnerId] nvarchar(127)  NOT NULL,
    [VpcId] int  NULL,
    [AmazonSecurityGroupId] nvarchar(127)  NOT NULL,
    [Region_Id] int  NULL
);
GO

-- Creating table 'KeyPairs'
CREATE TABLE [DynamicOps.AmazonWSModel].[KeyPairs] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(127)  NOT NULL,
    [Fingerprint] nvarchar(255)  NULL,
    [SecretKey] nvarchar(max)  NULL,
    [IsBeingCreated] bit  NOT NULL,
    [IsDeleted] bit  NOT NULL,
    [IsBeingDeleted] bit  NOT NULL,
    [ProvisioningGroupId] uniqueidentifier  NULL,
    [VirtualMachineId] uniqueidentifier  NULL,
    [Region_Id] int  NOT NULL
);
GO

-- Creating table 'AvailabilityZones'
CREATE TABLE [DynamicOps.AmazonWSModel].[AvailabilityZones] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(127)  NOT NULL,
    [AvailabilityZoneState] nvarchar(127)  NULL,
    [Message] nvarchar(max)  NOT NULL,
    [RegionName] nvarchar(127)  NOT NULL,
    [Region_Id] int  NOT NULL
);
GO

-- Creating table 'AccessKeys'
CREATE TABLE [DynamicOps.AmazonWSModel].[AccessKeys] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(127)  NOT NULL,
    [AmazonAccessKeyID] nvarchar(127)  NOT NULL,
    [SecretAccessKey] nvarchar(255)  NOT NULL,
    [ManagementEndpointId] uniqueidentifier  NOT NULL
);
GO

-- Creating table 'InstanceTypes'
CREATE TABLE [DynamicOps.AmazonWSModel].[InstanceTypes] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(127)  NOT NULL,
    [SizeName] nvarchar(127)  NOT NULL,
    [Memory] decimal(10,5)  NOT NULL,
    [ComputeUnits] decimal(10,5)  NOT NULL,
    [InstanceStorage] decimal(10,5)  NOT NULL,
    [ApiName] nvarchar(127)  NOT NULL,
    [IOPerformanceName] nvarchar(127)  NOT NULL,
    [VirtualCores] smallint  NOT NULL
);
GO

-- Creating table 'Regions'
CREATE TABLE [DynamicOps.AmazonWSModel].[Regions] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(127)  NOT NULL,
    [ServiceUrl] nvarchar(127)  NOT NULL,
    [HostId] uniqueidentifier  NOT NULL,
    [AccessKey_Id] int  NOT NULL
);
GO

-- Creating table 'ElasticLoadBalancers'
CREATE TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancers] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(127)  NOT NULL,
    [CanonicalHostedZoneName] nvarchar(127)  NOT NULL,
    [CanonicalHostedZoneNameID] nvarchar(127)  NOT NULL,
    [CreatedTime] datetime  NOT NULL,
    [DNSName] nvarchar(127)  NOT NULL,
    [HealthyThreshold] int  NOT NULL,
    [Interval] int  NOT NULL,
    [Target] nvarchar(255)  NOT NULL,
    [Timeout] int  NOT NULL,
    [UnhealthyThreshold] int  NOT NULL,
    [TotalManagedInstances] smallint  NOT NULL,
    [TotalHealthyInstances] smallint  NOT NULL,
    [Region_Id] int  NOT NULL
);
GO

-- Creating table 'VirtualPrivateClouds'
CREATE TABLE [DynamicOps.AmazonWSModel].[VirtualPrivateClouds] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [CidrBlock] nvarchar(40)  NOT NULL,
    [InstanceTenancy] nvarchar(127)  NOT NULL,
    [AmazonVpcId] nvarchar(127)  NOT NULL,
    [VpcState] nvarchar(127)  NOT NULL,
    [Region_Id] int  NOT NULL
);
GO

-- Creating table 'ElasticBlockStorageVolumes'
CREATE TABLE [DynamicOps.AmazonWSModel].[ElasticBlockStorageVolumes] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Size] nvarchar(127)  NOT NULL,
    [Status] nvarchar(127)  NOT NULL,
    [AmazonEbsVolumeId] nvarchar(127)  NULL,
    [CreateTime] datetime  NULL,
    [AttachTime] datetime  NULL,
    [Name] nvarchar(255)  NOT NULL,
    [DeviceName] nvarchar(127)  NULL,
    [Description] nvarchar(255)  NULL,
    [ReclamationStatus] nvarchar(127)  NULL,
    [DcacOwner] nvarchar(255)  NOT NULL,
    [IsBeingCreated] bit  NOT NULL,
    [IsBeingDeleted] bit  NOT NULL,
    [AvailabilityZone_Id] int  NOT NULL,
    [Instance_Id] int  NULL
);
GO

-- Creating table 'Subnets'
CREATE TABLE [DynamicOps.AmazonWSModel].[Subnets] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [AvailableIpAddresses] decimal(18,0)  NOT NULL,
    [CidrBlock] nvarchar(40)  NOT NULL,
    [AmazonSubnetId] nvarchar(127)  NOT NULL,
    [SubnetState] nvarchar(127)  NOT NULL,
    [VpcId] int  NOT NULL,
    [AvailabilityZone_Id] int  NOT NULL
);
GO

-- Creating table 'ElasticIpAddresses'
CREATE TABLE [DynamicOps.AmazonWSModel].[ElasticIpAddresses] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Address] nvarchar(127)  NOT NULL,
    [Scope] nvarchar(127)  NOT NULL,
    [Status] nvarchar(127)  NOT NULL,
    [AmazonAssociationId] nvarchar(127)  NULL,
    [AmazonAllocationId] nvarchar(127)  NULL,
    [Region_Id] int  NOT NULL,
    [Instance_Id] int  NULL
);
GO

-- Creating table 'Listeners'
CREATE TABLE [DynamicOps.AmazonWSModel].[Listeners] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [LoadBalancerPort] int  NOT NULL,
    [LoadBalancerProtocol] nvarchar(127)  NOT NULL,
    [InstancePort] int  NOT NULL,
    [InstanceProtocol] nvarchar(127)  NOT NULL,
    [SSLCertificate] nvarchar(max)  NULL,
    [ElasticLoadBalancer_Id] int  NULL
);
GO

-- Creating table 'AmazonHostReservations'
CREATE TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservations] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [HostReservationId] uniqueidentifier  NOT NULL,
    [StorageQuota] smallint  NULL,
    [KeyPairSelection] nvarchar(127)  NOT NULL,
    [KeyPair_Id] int  NULL
);
GO

-- Creating table 'AmazonVirtualMachineTemplates'
CREATE TABLE [DynamicOps.AmazonWSModel].[AmazonVirtualMachineTemplates] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [VirtualMachineTemplateId] uniqueidentifier  NOT NULL,
    [KeyPairSelection] nvarchar(127)  NOT NULL,
    [EnableAdvandedCapabilities] bit  NOT NULL,
    [Image_Id] int  NULL
);
GO

-- Creating table 'Instances'
CREATE TABLE [DynamicOps.AmazonWSModel].[Instances] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [AmazonInstanceId] nvarchar(127)  NOT NULL,
    [VirtualMachineId] uniqueidentifier  NOT NULL,
    [AdminPassword] nvarchar(127)  NULL,
    [AmazonReconfigureProfileId] int  NOT NULL,
    [PrivateDNSName] nvarchar(256)  NULL,
    [PrivateIPAddress] nvarchar(127)  NULL,
    [Subnet_Id] int  NULL,
    [AvailabilityZone_Id] int  NULL,
    [KeyPair_Id] int  NULL
);
GO

-- Creating table 'ElasticLoadBalancerInstanceStates'
CREATE TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerInstanceStates] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [InstanceState] nvarchar(127)  NOT NULL,
    [ReasonCode] nvarchar(127)  NOT NULL,
    [Description] nvarchar(255)  NOT NULL,
    [ElasticLoadBalancer_Id] int  NOT NULL,
    [Instance_Id] int  NOT NULL
);
GO

-- Creating table 'RegionImage'
CREATE TABLE [DynamicOps.AmazonWSModel].[RegionImage] (
    [Regions_Id] int  NOT NULL,
    [Images_Id] int  NOT NULL
);
GO

-- Creating table 'ElasticLoadBalancerSubnet'
CREATE TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerSubnet] (
    [ElasticLoadBalancers_Id] int  NOT NULL,
    [Subnets_Id] int  NOT NULL
);
GO

-- Creating table 'ElasticLoadBalancerAvailabilityZone'
CREATE TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerAvailabilityZone] (
    [ElasticLoadBalancers_Id] int  NOT NULL,
    [AvailabilityZones_Id] int  NOT NULL
);
GO

-- Creating table 'CloudReservationSecurityGroup'
CREATE TABLE [DynamicOps.AmazonWSModel].[CloudReservationSecurityGroup] (
    [CloudReservations_Id] int  NOT NULL,
    [SecurityGroups_Id] int  NOT NULL
);
GO

-- Creating table 'CloudReservationSubnet'
CREATE TABLE [DynamicOps.AmazonWSModel].[CloudReservationSubnet] (
    [CloudReservations_Id] int  NOT NULL,
    [Subnets_Id] int  NOT NULL
);
GO

-- Creating table 'CloudReservationAvailabilityZone'
CREATE TABLE [DynamicOps.AmazonWSModel].[CloudReservationAvailabilityZone] (
    [CloudReservations_Id] int  NOT NULL,
    [AvailabilityZones_Id] int  NOT NULL
);
GO

-- Creating table 'CloudBlueprintInstanceType'
CREATE TABLE [DynamicOps.AmazonWSModel].[CloudBlueprintInstanceType] (
    [CloudBlueprints_Id] int  NOT NULL,
    [InstanceTypes_Id] int  NOT NULL
);
GO

-- Creating table 'InstanceSecurityGroup'
CREATE TABLE [DynamicOps.AmazonWSModel].[InstanceSecurityGroup] (
    [Instances_Id] int  NOT NULL,
    [SecurityGroups_Id] int  NOT NULL
);
GO

-- Creating table 'AmazonHostReservationElasticLoadBalancer'
CREATE TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservationElasticLoadBalancer] (
    [AmazonHostReservations_Id] int  NOT NULL,
    [ElasticLoadBalancers_Id] int  NOT NULL
);
GO

-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [Id] in table 'Images'
ALTER TABLE [DynamicOps.AmazonWSModel].[Images]
ADD CONSTRAINT [PK_Images]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'SecurityGroups'
ALTER TABLE [DynamicOps.AmazonWSModel].[SecurityGroups]
ADD CONSTRAINT [PK_SecurityGroups]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'KeyPairs'
ALTER TABLE [DynamicOps.AmazonWSModel].[KeyPairs]
ADD CONSTRAINT [PK_KeyPairs]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'AvailabilityZones'
ALTER TABLE [DynamicOps.AmazonWSModel].[AvailabilityZones]
ADD CONSTRAINT [PK_AvailabilityZones]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'AccessKeys'
ALTER TABLE [DynamicOps.AmazonWSModel].[AccessKeys]
ADD CONSTRAINT [PK_AccessKeys]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'InstanceTypes'
ALTER TABLE [DynamicOps.AmazonWSModel].[InstanceTypes]
ADD CONSTRAINT [PK_InstanceTypes]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'Regions'
ALTER TABLE [DynamicOps.AmazonWSModel].[Regions]
ADD CONSTRAINT [PK_Regions]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'ElasticLoadBalancers'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancers]
ADD CONSTRAINT [PK_ElasticLoadBalancers]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'VirtualPrivateClouds'
ALTER TABLE [DynamicOps.AmazonWSModel].[VirtualPrivateClouds]
ADD CONSTRAINT [PK_VirtualPrivateClouds]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'ElasticBlockStorageVolumes'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticBlockStorageVolumes]
ADD CONSTRAINT [PK_ElasticBlockStorageVolumes]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'Subnets'
ALTER TABLE [DynamicOps.AmazonWSModel].[Subnets]
ADD CONSTRAINT [PK_Subnets]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'ElasticIpAddresses'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticIpAddresses]
ADD CONSTRAINT [PK_ElasticIpAddresses]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'Listeners'
ALTER TABLE [DynamicOps.AmazonWSModel].[Listeners]
ADD CONSTRAINT [PK_Listeners]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'AmazonHostReservations'
ALTER TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservations]
ADD CONSTRAINT [PK_AmazonHostReservations]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'AmazonVirtualMachineTemplates'
ALTER TABLE [DynamicOps.AmazonWSModel].[AmazonVirtualMachineTemplates]
ADD CONSTRAINT [PK_AmazonVirtualMachineTemplates]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'Instances'
ALTER TABLE [DynamicOps.AmazonWSModel].[Instances]
ADD CONSTRAINT [PK_Instances]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'ElasticLoadBalancerInstanceStates'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerInstanceStates]
ADD CONSTRAINT [PK_ElasticLoadBalancerInstanceStates]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Regions_Id], [Images_Id] in table 'RegionImage'
ALTER TABLE [DynamicOps.AmazonWSModel].[RegionImage]
ADD CONSTRAINT [PK_RegionImage]
    PRIMARY KEY NONCLUSTERED ([Regions_Id], [Images_Id] ASC);
GO

-- Creating primary key on [ElasticLoadBalancers_Id], [Subnets_Id] in table 'ElasticLoadBalancerSubnet'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerSubnet]
ADD CONSTRAINT [PK_ElasticLoadBalancerSubnet]
    PRIMARY KEY NONCLUSTERED ([ElasticLoadBalancers_Id], [Subnets_Id] ASC);
GO

-- Creating primary key on [ElasticLoadBalancers_Id], [AvailabilityZones_Id] in table 'ElasticLoadBalancerAvailabilityZone'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerAvailabilityZone]
ADD CONSTRAINT [PK_ElasticLoadBalancerAvailabilityZone]
    PRIMARY KEY NONCLUSTERED ([ElasticLoadBalancers_Id], [AvailabilityZones_Id] ASC);
GO

-- Creating primary key on [CloudReservations_Id], [SecurityGroups_Id] in table 'CloudReservationSecurityGroup'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationSecurityGroup]
ADD CONSTRAINT [PK_CloudReservationSecurityGroup]
    PRIMARY KEY NONCLUSTERED ([CloudReservations_Id], [SecurityGroups_Id] ASC);
GO

-- Creating primary key on [CloudReservations_Id], [Subnets_Id] in table 'CloudReservationSubnet'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationSubnet]
ADD CONSTRAINT [PK_CloudReservationSubnet]
    PRIMARY KEY NONCLUSTERED ([CloudReservations_Id], [Subnets_Id] ASC);
GO

-- Creating primary key on [CloudReservations_Id], [AvailabilityZones_Id] in table 'CloudReservationAvailabilityZone'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationAvailabilityZone]
ADD CONSTRAINT [PK_CloudReservationAvailabilityZone]
    PRIMARY KEY NONCLUSTERED ([CloudReservations_Id], [AvailabilityZones_Id] ASC);
GO

-- Creating primary key on [CloudBlueprints_Id], [InstanceTypes_Id] in table 'CloudBlueprintInstanceType'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudBlueprintInstanceType]
ADD CONSTRAINT [PK_CloudBlueprintInstanceType]
    PRIMARY KEY NONCLUSTERED ([CloudBlueprints_Id], [InstanceTypes_Id] ASC);
GO

-- Creating primary key on [Instances_Id], [SecurityGroups_Id] in table 'InstanceSecurityGroup'
ALTER TABLE [DynamicOps.AmazonWSModel].[InstanceSecurityGroup]
ADD CONSTRAINT [PK_InstanceSecurityGroup]
    PRIMARY KEY NONCLUSTERED ([Instances_Id], [SecurityGroups_Id] ASC);
GO

-- Creating primary key on [AmazonHostReservations_Id], [ElasticLoadBalancers_Id] in table 'AmazonHostReservationElasticLoadBalancer'
ALTER TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservationElasticLoadBalancer]
ADD CONSTRAINT [PK_AmazonHostReservationElasticLoadBalancer]
    PRIMARY KEY NONCLUSTERED ([AmazonHostReservations_Id], [ElasticLoadBalancers_Id] ASC);
GO

-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [Region_Id] in table 'AvailabilityZones'
ALTER TABLE [DynamicOps.AmazonWSModel].[AvailabilityZones]
ADD CONSTRAINT [FK_AvailabilityZoneRegion]
    FOREIGN KEY ([Region_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Regions]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_AvailabilityZoneRegion'
CREATE INDEX [IX_FK_AvailabilityZoneRegion]
ON [DynamicOps.AmazonWSModel].[AvailabilityZones]
    ([Region_Id]);
GO

-- Creating foreign key on [Region_Id] in table 'KeyPairs'
ALTER TABLE [DynamicOps.AmazonWSModel].[KeyPairs]
ADD CONSTRAINT [FK_KeyPairRegion]
    FOREIGN KEY ([Region_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Regions]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_KeyPairRegion'
CREATE INDEX [IX_FK_KeyPairRegion]
ON [DynamicOps.AmazonWSModel].[KeyPairs]
    ([Region_Id]);
GO

-- Creating foreign key on [AccessKey_Id] in table 'Regions'
ALTER TABLE [DynamicOps.AmazonWSModel].[Regions]
ADD CONSTRAINT [FK_RegionAccessKey]
    FOREIGN KEY ([AccessKey_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[AccessKeys]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_RegionAccessKey'
CREATE INDEX [IX_FK_RegionAccessKey]
ON [DynamicOps.AmazonWSModel].[Regions]
    ([AccessKey_Id]);
GO

-- Creating foreign key on [Regions_Id] in table 'RegionImage'
ALTER TABLE [DynamicOps.AmazonWSModel].[RegionImage]
ADD CONSTRAINT [FK_RegionImage_Region]
    FOREIGN KEY ([Regions_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Regions]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Images_Id] in table 'RegionImage'
ALTER TABLE [DynamicOps.AmazonWSModel].[RegionImage]
ADD CONSTRAINT [FK_RegionImage_Image]
    FOREIGN KEY ([Images_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Images]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_RegionImage_Image'
CREATE INDEX [IX_FK_RegionImage_Image]
ON [DynamicOps.AmazonWSModel].[RegionImage]
    ([Images_Id]);
GO

-- Creating foreign key on [AvailabilityZone_Id] in table 'ElasticBlockStorageVolumes'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticBlockStorageVolumes]
ADD CONSTRAINT [FK_AvailabilityZoneElasticBlockStorageVolume]
    FOREIGN KEY ([AvailabilityZone_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[AvailabilityZones]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_AvailabilityZoneElasticBlockStorageVolume'
CREATE INDEX [IX_FK_AvailabilityZoneElasticBlockStorageVolume]
ON [DynamicOps.AmazonWSModel].[ElasticBlockStorageVolumes]
    ([AvailabilityZone_Id]);
GO

-- Creating foreign key on [AvailabilityZone_Id] in table 'Subnets'
ALTER TABLE [DynamicOps.AmazonWSModel].[Subnets]
ADD CONSTRAINT [FK_AvailabilityZoneSubnet]
    FOREIGN KEY ([AvailabilityZone_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[AvailabilityZones]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_AvailabilityZoneSubnet'
CREATE INDEX [IX_FK_AvailabilityZoneSubnet]
ON [DynamicOps.AmazonWSModel].[Subnets]
    ([AvailabilityZone_Id]);
GO

-- Creating foreign key on [VpcId] in table 'Subnets'
ALTER TABLE [DynamicOps.AmazonWSModel].[Subnets]
ADD CONSTRAINT [FK_VirtualPrivateCloudSubnet]
    FOREIGN KEY ([VpcId])
    REFERENCES [DynamicOps.AmazonWSModel].[VirtualPrivateClouds]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_VirtualPrivateCloudSubnet'
CREATE INDEX [IX_FK_VirtualPrivateCloudSubnet]
ON [DynamicOps.AmazonWSModel].[Subnets]
    ([VpcId]);
GO

-- Creating foreign key on [ElasticLoadBalancers_Id] in table 'ElasticLoadBalancerSubnet'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerSubnet]
ADD CONSTRAINT [FK_ElasticLoadBalancerSubnet_ElasticLoadBalancer]
    FOREIGN KEY ([ElasticLoadBalancers_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[ElasticLoadBalancers]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Subnets_Id] in table 'ElasticLoadBalancerSubnet'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerSubnet]
ADD CONSTRAINT [FK_ElasticLoadBalancerSubnet_Subnet]
    FOREIGN KEY ([Subnets_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Subnets]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ElasticLoadBalancerSubnet_Subnet'
CREATE INDEX [IX_FK_ElasticLoadBalancerSubnet_Subnet]
ON [DynamicOps.AmazonWSModel].[ElasticLoadBalancerSubnet]
    ([Subnets_Id]);
GO

-- Creating foreign key on [VpcId] in table 'SecurityGroups'
ALTER TABLE [DynamicOps.AmazonWSModel].[SecurityGroups]
ADD CONSTRAINT [FK_VirtualPrivateCloudSecurityGroup]
    FOREIGN KEY ([VpcId])
    REFERENCES [DynamicOps.AmazonWSModel].[VirtualPrivateClouds]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_VirtualPrivateCloudSecurityGroup'
CREATE INDEX [IX_FK_VirtualPrivateCloudSecurityGroup]
ON [DynamicOps.AmazonWSModel].[SecurityGroups]
    ([VpcId]);
GO

-- Creating foreign key on [ElasticLoadBalancers_Id] in table 'ElasticLoadBalancerAvailabilityZone'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerAvailabilityZone]
ADD CONSTRAINT [FK_ElasticLoadBalancerAvailabilityZone_ElasticLoadBalancer]
    FOREIGN KEY ([ElasticLoadBalancers_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[ElasticLoadBalancers]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [AvailabilityZones_Id] in table 'ElasticLoadBalancerAvailabilityZone'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerAvailabilityZone]
ADD CONSTRAINT [FK_ElasticLoadBalancerAvailabilityZone_AvailabilityZone]
    FOREIGN KEY ([AvailabilityZones_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[AvailabilityZones]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ElasticLoadBalancerAvailabilityZone_AvailabilityZone'
CREATE INDEX [IX_FK_ElasticLoadBalancerAvailabilityZone_AvailabilityZone]
ON [DynamicOps.AmazonWSModel].[ElasticLoadBalancerAvailabilityZone]
    ([AvailabilityZones_Id]);
GO

-- Creating foreign key on [Region_Id] in table 'SecurityGroups'
ALTER TABLE [DynamicOps.AmazonWSModel].[SecurityGroups]
ADD CONSTRAINT [FK_SecurityGroupRegion]
    FOREIGN KEY ([Region_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Regions]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_SecurityGroupRegion'
CREATE INDEX [IX_FK_SecurityGroupRegion]
ON [DynamicOps.AmazonWSModel].[SecurityGroups]
    ([Region_Id]);
GO

-- Creating foreign key on [Region_Id] in table 'ElasticIpAddresses'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticIpAddresses]
ADD CONSTRAINT [FK_ElasticIpAddressRegion]
    FOREIGN KEY ([Region_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Regions]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ElasticIpAddressRegion'
CREATE INDEX [IX_FK_ElasticIpAddressRegion]
ON [DynamicOps.AmazonWSModel].[ElasticIpAddresses]
    ([Region_Id]);
GO

-- Creating foreign key on [ElasticLoadBalancer_Id] in table 'Listeners'
ALTER TABLE [DynamicOps.AmazonWSModel].[Listeners]
ADD CONSTRAINT [FK_ListenersElasticLoadBalancer]
    FOREIGN KEY ([ElasticLoadBalancer_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[ElasticLoadBalancers]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ListenersElasticLoadBalancer'
CREATE INDEX [IX_FK_ListenersElasticLoadBalancer]
ON [DynamicOps.AmazonWSModel].[Listeners]
    ([ElasticLoadBalancer_Id]);
GO

-- Creating foreign key on [CloudReservations_Id] in table 'CloudReservationSecurityGroup'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationSecurityGroup]
ADD CONSTRAINT [FK_CloudReservationSecurityGroup_CloudReservation]
    FOREIGN KEY ([CloudReservations_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[AmazonHostReservations]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [SecurityGroups_Id] in table 'CloudReservationSecurityGroup'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationSecurityGroup]
ADD CONSTRAINT [FK_CloudReservationSecurityGroup_SecurityGroup]
    FOREIGN KEY ([SecurityGroups_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[SecurityGroups]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_CloudReservationSecurityGroup_SecurityGroup'
CREATE INDEX [IX_FK_CloudReservationSecurityGroup_SecurityGroup]
ON [DynamicOps.AmazonWSModel].[CloudReservationSecurityGroup]
    ([SecurityGroups_Id]);
GO

-- Creating foreign key on [CloudReservations_Id] in table 'CloudReservationSubnet'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationSubnet]
ADD CONSTRAINT [FK_CloudReservationSubnet_CloudReservation]
    FOREIGN KEY ([CloudReservations_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[AmazonHostReservations]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Subnets_Id] in table 'CloudReservationSubnet'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationSubnet]
ADD CONSTRAINT [FK_CloudReservationSubnet_Subnet]
    FOREIGN KEY ([Subnets_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Subnets]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_CloudReservationSubnet_Subnet'
CREATE INDEX [IX_FK_CloudReservationSubnet_Subnet]
ON [DynamicOps.AmazonWSModel].[CloudReservationSubnet]
    ([Subnets_Id]);
GO

-- Creating foreign key on [CloudReservations_Id] in table 'CloudReservationAvailabilityZone'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationAvailabilityZone]
ADD CONSTRAINT [FK_CloudReservationAvailabilityZone_CloudReservation]
    FOREIGN KEY ([CloudReservations_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[AmazonHostReservations]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [AvailabilityZones_Id] in table 'CloudReservationAvailabilityZone'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudReservationAvailabilityZone]
ADD CONSTRAINT [FK_CloudReservationAvailabilityZone_AvailabilityZone]
    FOREIGN KEY ([AvailabilityZones_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[AvailabilityZones]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_CloudReservationAvailabilityZone_AvailabilityZone'
CREATE INDEX [IX_FK_CloudReservationAvailabilityZone_AvailabilityZone]
ON [DynamicOps.AmazonWSModel].[CloudReservationAvailabilityZone]
    ([AvailabilityZones_Id]);
GO

-- Creating foreign key on [CloudBlueprints_Id] in table 'CloudBlueprintInstanceType'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudBlueprintInstanceType]
ADD CONSTRAINT [FK_CloudBlueprintInstanceType_CloudBlueprint]
    FOREIGN KEY ([CloudBlueprints_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[AmazonVirtualMachineTemplates]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [InstanceTypes_Id] in table 'CloudBlueprintInstanceType'
ALTER TABLE [DynamicOps.AmazonWSModel].[CloudBlueprintInstanceType]
ADD CONSTRAINT [FK_CloudBlueprintInstanceType_InstanceType]
    FOREIGN KEY ([InstanceTypes_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[InstanceTypes]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_CloudBlueprintInstanceType_InstanceType'
CREATE INDEX [IX_FK_CloudBlueprintInstanceType_InstanceType]
ON [DynamicOps.AmazonWSModel].[CloudBlueprintInstanceType]
    ([InstanceTypes_Id]);
GO

-- Creating foreign key on [Image_Id] in table 'AmazonVirtualMachineTemplates'
ALTER TABLE [DynamicOps.AmazonWSModel].[AmazonVirtualMachineTemplates]
ADD CONSTRAINT [FK_CloudBlueprintImage]
    FOREIGN KEY ([Image_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Images]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_CloudBlueprintImage'
CREATE INDEX [IX_FK_CloudBlueprintImage]
ON [DynamicOps.AmazonWSModel].[AmazonVirtualMachineTemplates]
    ([Image_Id]);
GO

-- Creating foreign key on [ElasticLoadBalancer_Id] in table 'ElasticLoadBalancerInstanceStates'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerInstanceStates]
ADD CONSTRAINT [FK_ElasticLoadBalancerElasticLoadBalancerInstanceState]
    FOREIGN KEY ([ElasticLoadBalancer_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[ElasticLoadBalancers]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ElasticLoadBalancerElasticLoadBalancerInstanceState'
CREATE INDEX [IX_FK_ElasticLoadBalancerElasticLoadBalancerInstanceState]
ON [DynamicOps.AmazonWSModel].[ElasticLoadBalancerInstanceStates]
    ([ElasticLoadBalancer_Id]);
GO

-- Creating foreign key on [Instance_Id] in table 'ElasticLoadBalancerInstanceStates'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancerInstanceStates]
ADD CONSTRAINT [FK_InstanceElasticLoadBalancerInstanceState]
    FOREIGN KEY ([Instance_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Instances]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_InstanceElasticLoadBalancerInstanceState'
CREATE INDEX [IX_FK_InstanceElasticLoadBalancerInstanceState]
ON [DynamicOps.AmazonWSModel].[ElasticLoadBalancerInstanceStates]
    ([Instance_Id]);
GO

-- Creating foreign key on [Subnet_Id] in table 'Instances'
ALTER TABLE [DynamicOps.AmazonWSModel].[Instances]
ADD CONSTRAINT [FK_InstanceSubnet]
    FOREIGN KEY ([Subnet_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Subnets]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_InstanceSubnet'
CREATE INDEX [IX_FK_InstanceSubnet]
ON [DynamicOps.AmazonWSModel].[Instances]
    ([Subnet_Id]);
GO

-- Creating foreign key on [Instance_Id] in table 'ElasticIpAddresses'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticIpAddresses]
ADD CONSTRAINT [FK_InstanceElasticIpAddress]
    FOREIGN KEY ([Instance_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Instances]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_InstanceElasticIpAddress'
CREATE INDEX [IX_FK_InstanceElasticIpAddress]
ON [DynamicOps.AmazonWSModel].[ElasticIpAddresses]
    ([Instance_Id]);
GO

-- Creating foreign key on [Instance_Id] in table 'ElasticBlockStorageVolumes'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticBlockStorageVolumes]
ADD CONSTRAINT [FK_InstanceElasticBlockStorageVolume]
    FOREIGN KEY ([Instance_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Instances]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_InstanceElasticBlockStorageVolume'
CREATE INDEX [IX_FK_InstanceElasticBlockStorageVolume]
ON [DynamicOps.AmazonWSModel].[ElasticBlockStorageVolumes]
    ([Instance_Id]);
GO

-- Creating foreign key on [Region_Id] in table 'VirtualPrivateClouds'
ALTER TABLE [DynamicOps.AmazonWSModel].[VirtualPrivateClouds]
ADD CONSTRAINT [FK_RegionVirtualPrivateCloud]
    FOREIGN KEY ([Region_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Regions]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_RegionVirtualPrivateCloud'
CREATE INDEX [IX_FK_RegionVirtualPrivateCloud]
ON [DynamicOps.AmazonWSModel].[VirtualPrivateClouds]
    ([Region_Id]);
GO

-- Creating foreign key on [AvailabilityZone_Id] in table 'Instances'
ALTER TABLE [DynamicOps.AmazonWSModel].[Instances]
ADD CONSTRAINT [FK_InstanceAvailabilityZone]
    FOREIGN KEY ([AvailabilityZone_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[AvailabilityZones]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_InstanceAvailabilityZone'
CREATE INDEX [IX_FK_InstanceAvailabilityZone]
ON [DynamicOps.AmazonWSModel].[Instances]
    ([AvailabilityZone_Id]);
GO

-- Creating foreign key on [Region_Id] in table 'ElasticLoadBalancers'
ALTER TABLE [DynamicOps.AmazonWSModel].[ElasticLoadBalancers]
ADD CONSTRAINT [FK_RegionElasticLoadBalancer]
    FOREIGN KEY ([Region_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Regions]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_RegionElasticLoadBalancer'
CREATE INDEX [IX_FK_RegionElasticLoadBalancer]
ON [DynamicOps.AmazonWSModel].[ElasticLoadBalancers]
    ([Region_Id]);
GO

-- Creating foreign key on [KeyPair_Id] in table 'Instances'
ALTER TABLE [DynamicOps.AmazonWSModel].[Instances]
ADD CONSTRAINT [FK_InstanceKeyPair]
    FOREIGN KEY ([KeyPair_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[KeyPairs]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_InstanceKeyPair'
CREATE INDEX [IX_FK_InstanceKeyPair]
ON [DynamicOps.AmazonWSModel].[Instances]
    ([KeyPair_Id]);
GO

-- Creating foreign key on [KeyPair_Id] in table 'AmazonHostReservations'
ALTER TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservations]
ADD CONSTRAINT [FK_AmazonHostReservationKeyPair]
    FOREIGN KEY ([KeyPair_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[KeyPairs]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_AmazonHostReservationKeyPair'
CREATE INDEX [IX_FK_AmazonHostReservationKeyPair]
ON [DynamicOps.AmazonWSModel].[AmazonHostReservations]
    ([KeyPair_Id]);
GO

-- Creating foreign key on [Instances_Id] in table 'InstanceSecurityGroup'
ALTER TABLE [DynamicOps.AmazonWSModel].[InstanceSecurityGroup]
ADD CONSTRAINT [FK_InstanceSecurityGroup_Instance]
    FOREIGN KEY ([Instances_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[Instances]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [SecurityGroups_Id] in table 'InstanceSecurityGroup'
ALTER TABLE [DynamicOps.AmazonWSModel].[InstanceSecurityGroup]
ADD CONSTRAINT [FK_InstanceSecurityGroup_SecurityGroup]
    FOREIGN KEY ([SecurityGroups_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[SecurityGroups]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_InstanceSecurityGroup_SecurityGroup'
CREATE INDEX [IX_FK_InstanceSecurityGroup_SecurityGroup]
ON [DynamicOps.AmazonWSModel].[InstanceSecurityGroup]
    ([SecurityGroups_Id]);
GO

-- Creating foreign key on [AmazonHostReservations_Id] in table 'AmazonHostReservationElasticLoadBalancer'
ALTER TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservationElasticLoadBalancer]
ADD CONSTRAINT [FK_AmazonHostReservationElasticLoadBalancer_AmazonHostReservation]
    FOREIGN KEY ([AmazonHostReservations_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[AmazonHostReservations]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [ElasticLoadBalancers_Id] in table 'AmazonHostReservationElasticLoadBalancer'
ALTER TABLE [DynamicOps.AmazonWSModel].[AmazonHostReservationElasticLoadBalancer]
ADD CONSTRAINT [FK_AmazonHostReservationElasticLoadBalancer_ElasticLoadBalancer]
    FOREIGN KEY ([ElasticLoadBalancers_Id])
    REFERENCES [DynamicOps.AmazonWSModel].[ElasticLoadBalancers]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_AmazonHostReservationElasticLoadBalancer_ElasticLoadBalancer'
CREATE INDEX [IX_FK_AmazonHostReservationElasticLoadBalancer_ElasticLoadBalancer]
ON [DynamicOps.AmazonWSModel].[AmazonHostReservationElasticLoadBalancer]
    ([ElasticLoadBalancers_Id]);
GO

-- --------------------------------------------------
-- Script has ended
-- --------------------------------------------------