
/*
Purpose: Granting Manager Service service account access to ASP session state database

Note:
Replace $(ServiceUser) variable with Manager Service User account in the domain\user format
before executing this script under ASP session state database context.

If ASP session state database creation involves the use of tempdb then please run this same
script under tempdb database as well.
*/

/* If login user does not exist then create it */
IF NOT EXISTS (SELECT * FROM sys.syslogins WHERE name='$(ServiceUser)')
BEGIN
	CREATE LOGIN [$(ServiceUser)] FROM WINDOWS
END
GO

/* Create ServiceUser that maps to login user */
IF NOT EXISTS (SELECT * FROM sys.database_principals WHERE name = N'ServiceUser')
BEGIN
	CREATE USER ServiceUser FOR LOGIN [$(ServiceUser)]
		WITH DEFAULT_SCHEMA=[dbo];
END

GO
/* If Vrm_Manager role does not exist then add this role */
IF NOT EXISTS( SELECT 1 FROM [dbo].[sysusers] WHERE name=N'Vrm_Manager' and issqlrole=1 )
BEGIN
	EXEC sp_addrole N'Vrm_Manager'
END
GO

-- add ServiceUser as a member of Vrm_Manager role
exec sp_addrolemember 'Vrm_Manager', 'ServiceUser'

-- add ServiceUser as a member db_owner role
exec sp_addrolemember 'db_owner', 'ServiceUser'
GO
