﻿-- Add the Vrm_Manager role that has access to all stored procedures.
IF NOT EXISTS( SELECT 1 FROM [dbo].[sysusers] WHERE name=N'Task_Manager' and issqlrole=1 )
 BEGIN

	EXEC sp_addrole N'Task_Manager'

END
GO
-- This script creates the tables needed by the Task Execution subsystem of VRM.

CREATE TABLE [vrm_tasks_TaskExecutionAgents] (
	TaskExecutionAgentId uniqueidentifier not null primary key,
	ExpirationDateTimeUtc datetime)
GO

CREATE TABLE [vrm_tasks_Tasks] (
	TaskId uniqueidentifier not null primary key,
	TaskData varbinary(max) not null,
	IdleTimeout datetime,
	NonExistentResourcesTimeout datetime,
	ExecutionTimeout datetime,
	StatusUpdateTimeout datetime,
	TaskExecutionStatus int not null)
GO

CREATE TABLE [vrm_tasks_RequestHandlers] (
	RequestHandlerId uniqueidentifier not null primary key)
GO

CREATE TABLE [vrm_tasks_RequestHandlerResources] (
	RequestHandlerId uniqueidentifier 
		not null 
		foreign key references [vrm_tasks_RequestHandlers] (RequestHandlerId)
			on delete cascade,
	ResourceName varchar(200) not null,
	ResourceValue varchar(200))
GO

CREATE TABLE [vrm_tasks_Requests] (
	RequestId uniqueidentifier not null primary key,
	Idle bit not null)
GO

CREATE TABLE [vrm_tasks_RequestResources] (
	RequestId uniqueidentifier 
		not null 
		foreign key references [vrm_tasks_Requests] (RequestId)
			on delete cascade,
	ResourceName varchar(200) not null,
	ResourceValue varchar(200) not null,
	Usage decimal(28,6) not null,
	AllowedUsage decimal(28,6) not null,
	Explicit bit not null)
GO
