SET QUOTED_IDENTIFIER OFF;
GO
USE [$(DBName)];
GO
IF SCHEMA_ID(N'dbo') IS NULL EXECUTE(N'CREATE SCHEMA [dbo]');
GO

-- --------------------------------------------------
-- Dropping existing FOREIGN KEY constraints
-- --------------------------------------------------
IF OBJECT_ID(N'[dbo].[FK_BootPolicyTenant]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[BootPolicies] DROP CONSTRAINT [FK_BootPolicyTenant];
GO
IF OBJECT_ID(N'[dbo].[FK_PoolPhysicalMachine_PhysicalMachine]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[PoolPhysicalMachine] DROP CONSTRAINT [FK_PoolPhysicalMachine_PhysicalMachine];
GO
IF OBJECT_ID(N'[dbo].[FK_PoolPhysicalMachine_Pool]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[PoolPhysicalMachine] DROP CONSTRAINT [FK_PoolPhysicalMachine_Pool];
GO
IF OBJECT_ID(N'[dbo].[FK_ServiceProfileVirtualMachine]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ServiceProfiles] DROP CONSTRAINT [FK_ServiceProfileVirtualMachine];
GO
IF OBJECT_ID(N'[dbo].[FK_VirtualMachineTemplateServiceProfileTemplate]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[VirtualMachineTemplate] DROP CONSTRAINT [FK_VirtualMachineTemplateServiceProfileTemplate];
GO
IF OBJECT_ID(N'[dbo].[FK_TenantTenant]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[Tenants] DROP CONSTRAINT [FK_TenantTenant];
GO
IF OBJECT_ID(N'[dbo].[FK_TenantPhysicalController]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[Tenants] DROP CONSTRAINT [FK_TenantPhysicalController];
GO
IF OBJECT_ID(N'[dbo].[FK_TenantPhysicalController]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[Tenants] DROP CONSTRAINT [FK_TenantPhysicalController];
GO
IF OBJECT_ID(N'[dbo].[FK_TenantPool]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[Pools] DROP CONSTRAINT [FK_TenantPool];
GO
IF OBJECT_ID(N'[dbo].[FK_TenantServiceProfile]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ServiceProfiles] DROP CONSTRAINT [FK_TenantServiceProfile];
GO
IF OBJECT_ID(N'[dbo].[FK_TenantServiceProfileTemplate]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ServiceProfileTemplates] DROP CONSTRAINT [FK_TenantServiceProfileTemplate];
GO

-- --------------------------------------------------
-- Dropping existing INDEX
-- --------------------------------------------------

IF INDEXPROPERTY(OBJECT_ID('[dbo].[VirtualMachineTemplate]'), N'IX_FK_VirtualMachineTemplateServiceProfileTemplate', N'IndexID') IS NOT NULL
	DROP INDEX [IX_FK_VirtualMachineTemplateServiceProfileTemplate] ON [dbo].[VirtualMachineTemplate];
GO

-- --------------------------------------------------
-- Dropping existing COLUMNS
-- --------------------------------------------------

IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS 
		   WHERE TABLE_NAME=N'VirtualMachineTemplate' AND COLUMN_NAME=N'ServiceProfileTemplate_Id')
	ALTER TABLE [dbo].[VirtualMachineTemplate] DROP COLUMN [ServiceProfileTemplate_Id]
GO

-- --------------------------------------------------
-- Dropping existing tables
-- --------------------------------------------------
IF OBJECT_ID(N'[dbo].[BootPolicies]', 'U') IS NOT NULL
    DROP TABLE [dbo].[BootPolicies];
GO
IF OBJECT_ID(N'[dbo].[PoolPhysicalMachine]', 'U') IS NOT NULL
    DROP TABLE [dbo].[PoolPhysicalMachine];
GO
IF OBJECT_ID(N'[dbo].[Pools]', 'U') IS NOT NULL
    DROP TABLE [dbo].[Pools];
GO
IF OBJECT_ID(N'[dbo].[ServiceProfiles]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ServiceProfiles];
GO
IF OBJECT_ID(N'[dbo].[ServiceProfileTemplates]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ServiceProfileTemplates];
GO
IF OBJECT_ID(N'[dbo].[Tenants]', 'U') IS NOT NULL
    DROP TABLE [dbo].[Tenants];
GO

-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'ServiceProfiles'
CREATE TABLE [dbo].[ServiceProfiles] (
    [Name] nvarchar(256)  NOT NULL,
    [PnDn] nvarchar(512)  NULL,
    [Dn] nvarchar(512)  NOT NULL,
    [Id] int IDENTITY(1,1) NOT NULL,
    [VirtualMachine_VirtualMachineID] uniqueidentifier  NOT NULL,
    [Tenant_Id] int  NOT NULL
);
GO

-- Creating table 'ServiceProfileTemplates'
CREATE TABLE [dbo].[ServiceProfileTemplates] (
    [Name] nvarchar(256)  NOT NULL,
    [Dn] nvarchar(512)  NOT NULL,
    [Id] int IDENTITY(1,1) NOT NULL,
    [Description] nvarchar(max)  NOT NULL,
    [Tenant_Id] int  NOT NULL
);
GO

-- Creating table 'Pools'
CREATE TABLE [dbo].[Pools] (
    [Name] nvarchar(256)  NOT NULL,
    [Dn] nvarchar(512)  NOT NULL,
    [Id] int IDENTITY(1,1) NOT NULL,
    [Description] nvarchar(max)  NOT NULL,
    [Tenant_Id] int  NOT NULL
);
GO

-- Creating table 'Tenants'
CREATE TABLE [dbo].[Tenants] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Description] nvarchar(max)  NOT NULL,
    [Dn] nvarchar(512)  NOT NULL,
    [Name] nvarchar(256)  NOT NULL,
	[Level] int NOT NULL,
    [Parent_Id] int  NULL,
    [PhysicalController_PhysicalControllerID] uniqueidentifier  NOT NULL
);
GO

-- Creating table 'BootPolicies'
CREATE TABLE [dbo].[BootPolicies] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Dn] nvarchar(512)  NOT NULL,
    [Description] nvarchar(max)  NOT NULL,
    [Name] nvarchar(256)  NOT NULL,
	[BootSequence] nvarchar(128)  NOT NULL,
    [Tenant_Id] int  NOT NULL
);
GO

-- Creating table 'PoolPhysicalMachine'
CREATE TABLE [dbo].[PoolPhysicalMachine] (
    [PhysicalMachines_PhysicalMachineID] uniqueidentifier  NOT NULL,
    [Pools_Id] int  NOT NULL
);
GO

-- --------------------------------------------------
-- Creating new columns
-- --------------------------------------------------

-- Creating columns in table 'VirtualMachineTemplates'
ALTER TABLE [dbo].[VirtualMachineTemplate]
    ADD [ServiceProfileTemplate_Id] int  NULL
GO

-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [Id] in table 'ServiceProfiles'
ALTER TABLE [dbo].[ServiceProfiles]
ADD CONSTRAINT [PK_ServiceProfiles]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'ServiceProfileTemplates'
ALTER TABLE [dbo].[ServiceProfileTemplates]
ADD CONSTRAINT [PK_ServiceProfileTemplates]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'Pools'
ALTER TABLE [dbo].[Pools]
ADD CONSTRAINT [PK_Pools]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [PhysicalMachines_PhysicalMachineID], [Pools_Id] in table 'PoolPhysicalMachine'
ALTER TABLE [dbo].[PoolPhysicalMachine]
ADD CONSTRAINT [PK_PoolPhysicalMachine]
    PRIMARY KEY NONCLUSTERED ([PhysicalMachines_PhysicalMachineID], [Pools_Id] ASC);
GO

-- Creating primary key on [Id] in table 'Tenants'
ALTER TABLE [dbo].[Tenants]
ADD CONSTRAINT [PK_Tenants]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'BootPolicies'
ALTER TABLE [dbo].[BootPolicies]
ADD CONSTRAINT [PK_BootPolicies]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [Parent_Id] in table 'Tenants'
ALTER TABLE [dbo].[Tenants]
ADD CONSTRAINT [FK_TenantTenant]
    FOREIGN KEY ([Parent_Id])
    REFERENCES [dbo].[Tenants]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_TenantTenant'
CREATE INDEX [IX_FK_TenantTenant]
ON [dbo].[Tenants]
    ([Parent_Id]);
GO

-- Creating foreign key on [PhysicalController_PhysicalControllerID] in table 'Tenants'
ALTER TABLE [dbo].[Tenants]
ADD CONSTRAINT [FK_TenantPhysicalController]
    FOREIGN KEY ([PhysicalController_PhysicalControllerID])
    REFERENCES [dbo].[PhysicalControllers]
        ([PhysicalControllerID])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_TenantPhysicalController'
CREATE INDEX [IX_FK_TenantPhysicalController]
ON [dbo].[Tenants]
    ([PhysicalController_PhysicalControllerID]);
GO

-- Creating foreign key on [Tenant_Id] in table 'BootPolicies'
ALTER TABLE [dbo].[BootPolicies]
ADD CONSTRAINT [FK_BootPolicyTenant]
    FOREIGN KEY ([Tenant_Id])
    REFERENCES [dbo].[Tenants]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_BootPolicyTenant'
CREATE INDEX [IX_FK_BootPolicyTenant]
ON [dbo].[BootPolicies]
    ([Tenant_Id]);
GO

-- Creating foreign key on [Tenant_Id] in table 'Pools'
ALTER TABLE [dbo].[Pools]
ADD CONSTRAINT [FK_TenantPool]
    FOREIGN KEY ([Tenant_Id])
    REFERENCES [dbo].[Tenants]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_TenantPool'
CREATE INDEX [IX_FK_TenantPool]
ON [dbo].[Pools]
    ([Tenant_Id]);
GO

-- Creating foreign key on [Tenant_Id] in table 'ServiceProfiles'
ALTER TABLE [dbo].[ServiceProfiles]
ADD CONSTRAINT [FK_TenantServiceProfile]
    FOREIGN KEY ([Tenant_Id])
    REFERENCES [dbo].[Tenants]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_TenantServiceProfile'
CREATE INDEX [IX_FK_TenantServiceProfile]
ON [dbo].[ServiceProfiles]
    ([Tenant_Id]);
GO

-- Creating foreign key on [Tenant_Id] in table 'ServiceProfileTemplates'
ALTER TABLE [dbo].[ServiceProfileTemplates]
ADD CONSTRAINT [FK_TenantServiceProfileTemplate]
    FOREIGN KEY ([Tenant_Id])
    REFERENCES [dbo].[Tenants]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_TenantServiceProfileTemplate'
CREATE INDEX [IX_FK_TenantServiceProfileTemplate]
ON [dbo].[ServiceProfileTemplates]
    ([Tenant_Id]);
GO

-- Creating foreign key on [VirtualMachine_VirtualMachineID] in table 'ServiceProfiles'
ALTER TABLE [dbo].[ServiceProfiles]
ADD CONSTRAINT [FK_ServiceProfileVirtualMachine]
    FOREIGN KEY ([VirtualMachine_VirtualMachineID])
    REFERENCES [dbo].[VirtualMachine]
        ([VirtualMachineID])
    ON DELETE CASCADE ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_ServiceProfileVirtualMachine'
CREATE INDEX [IX_FK_ServiceProfileVirtualMachine]
ON [dbo].[ServiceProfiles]
    ([VirtualMachine_VirtualMachineID]);
GO

-- Creating foreign key on [PhysicalMachines_PhysicalMachineID] in table 'PoolPhysicalMachine'
ALTER TABLE [dbo].[PoolPhysicalMachine]
ADD CONSTRAINT [FK_PoolPhysicalMachine_PhysicalMachine]
    FOREIGN KEY ([PhysicalMachines_PhysicalMachineID])
    REFERENCES [dbo].[PhysicalMachines]
        ([PhysicalMachineID])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating foreign key on [Pools_Id] in table 'PoolPhysicalMachine'
ALTER TABLE [dbo].[PoolPhysicalMachine]
ADD CONSTRAINT [FK_PoolPhysicalMachine_Pool]
    FOREIGN KEY ([Pools_Id])
    REFERENCES [dbo].[Pools]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_PoolPhysicalMachine_Pool'
CREATE INDEX [IX_FK_PoolPhysicalMachine_Pool]
ON [dbo].[PoolPhysicalMachine]
    ([Pools_Id]);
GO

-- Creating foreign key on [ServiceProfileTemplate_Id] in table 'VirtualMachineTemplates'
ALTER TABLE [dbo].[VirtualMachineTemplate]
ADD CONSTRAINT [FK_VirtualMachineTemplateServiceProfileTemplate]
    FOREIGN KEY ([ServiceProfileTemplate_Id])
    REFERENCES [dbo].[ServiceProfileTemplates]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;

-- Creating non-clustered index for FOREIGN KEY 'FK_VirtualMachineTemplateServiceProfileTemplate'
CREATE INDEX [IX_FK_VirtualMachineTemplateServiceProfileTemplate]
ON [dbo].[VirtualMachineTemplate]
    ([ServiceProfileTemplate_Id]);
GO


-- --------------------------------------------------
-- Script has ended
-- --------------------------------------------------