﻿SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DivideAsDecimal]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[DivideAsDecimal]
GO
CREATE FUNCTION [dbo].[DivideAsDecimal] (@Value bigint, @DivideBy bigint)
	RETURNS Decimal(28,2) AS
BEGIN
	RETURN CAST(CAST(@Value as decimal(28,3))/NULLIF(@DivideBy,0) as decimal(28,2)) 
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DiffNoNegBigInt]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[DiffNoNegBigInt]
GO
CREATE FUNCTION [dbo].[DiffNoNegBigInt] (@p1 bigint, @p2 bigint)
	RETURNS bigint AS
BEGIN
	RETURN case when @p1 <= @p2 then 0 else @p1-@p2 end 
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PercentageAsDecimal]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[PercentageAsDecimal]
GO
CREATE FUNCTION [dbo].[PercentageAsDecimal] (@Value bigint, @Other bigint)
	RETURNS Decimal(28,2) AS
BEGIN
	RETURN CAST(ISNULL(CAST(@Value as decimal(28,3)) * 100 / NULLIF(@Other,0), 0) as decimal(28,2)) 
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Percentage]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[Percentage]
GO
CREATE FUNCTION [dbo].[Percentage] (@Value bigint, @Other bigint)
	RETURNS int AS
BEGIN
	RETURN CAST(ROUND(ISNULL(CAST(@Value as decimal(28,3)) * 100 / NULLIF(@Other,0), 0), 0) as int) 
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetEnterpriseAdminNamesForHost]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[GetEnterpriseAdminNamesForHost]
GO
CREATE FUNCTION [dbo].[GetEnterpriseAdminNamesForHost] (@HostID uniqueidentifier)

RETURNS nvarchar(4000) AS

BEGIN
	DECLARE @Concat nvarchar(4000), @Delimiter nvarchar(1);
	SET @Concat = '';
	SET @Delimiter = ';'
	SELECT @Concat = @Concat + @Delimiter + LTRIM(AdminName)
		 FROM (SELECT DISTINCT AdminName FROM dbo.AdminGroupToHost a 
			   INNER JOIN EnterpriseAdminGroups e ON a.EnterpriseAdminID = e.EnterpriseAdminID
			   WHERE a.HostID = @HostID) derived
	RETURN SUBSTRING(@Concat, 2, LEN(@Concat));
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHostNamesForEnterpriseAdmin]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[GetHostNamesForEnterpriseAdmin]
GO
CREATE FUNCTION [dbo].[GetHostNamesForEnterpriseAdmin] (@EnterpriseAdminGroupID uniqueidentifier)

RETURNS nvarchar(4000) AS

BEGIN
	DECLARE @Concat nvarchar(4000), @Delimiter nvarchar(1);
	SET @Concat = '';
	SET @Delimiter = ';'
	SELECT @Concat = @Concat + @Delimiter + LTRIM(HostName)
		 FROM (SELECT DISTINCT h.HostName FROM dbo.AdminGroupToHost a 
			   INNER JOIN Host h ON a.HostID = h.HostID
			   WHERE a.EnterpriseAdminID = @EnterpriseAdminGroupID) derived
	RETURN SUBSTRING(@Concat, 2, LEN(@Concat));
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNetworkNamesForReservation]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[GetNetworkNamesForReservation]
GO
CREATE FUNCTION [dbo].[GetNetworkNamesForReservation] (@HostReservationID uniqueidentifier)

RETURNS nvarchar(4000) AS

BEGIN
	DECLARE @Concat nvarchar(4000), @Delimiter nvarchar(1);
	SET @Concat = '';
	SET @Delimiter = ';'
	SELECT @Concat = @Concat + @Delimiter + LTRIM(NetworkName)
		 FROM (SELECT DISTINCT n.NetworkName FROM dbo.HostNic n 
			   INNER JOIN HostNicToReservation nr ON nr.HostNicID = n.HostNicID
			   WHERE nr.HostReservationID = @HostReservationID) derived
	RETURN SUBSTRING(@Concat, 2, LEN(@Concat));
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetStoragePathsForReservation]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[GetStoragePathsForReservation]
GO
CREATE FUNCTION [dbo].[GetStoragePathsForReservation] (@HostReservationID uniqueidentifier)

RETURNS nvarchar(4000) AS

BEGIN
	DECLARE @Concat nvarchar(4000), @Delimiter nvarchar(1);
	SET @Concat = '';
	SET @Delimiter = ';'
	SELECT @Concat = @Concat + @Delimiter + LTRIM(StoragePath)
		 FROM (SELECT DISTINCT hs.StoragePath FROM dbo.HostToStorage hs 
			   INNER JOIN HostReservationToStorage sr ON sr.HostToStorageID = hs.HostToStorageID
			   WHERE sr.HostReservationID = @HostReservationID) derived
	RETURN SUBSTRING(@Concat, 2, LEN(@Concat));
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetGroupNamesForTemplate]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[GetGroupNamesForTemplate]
GO
CREATE FUNCTION [dbo].[GetGroupNamesForTemplate] (@VirtualMachineTemplateID uniqueidentifier)

RETURNS nvarchar(4000) AS

BEGIN
	DECLARE @Concat nvarchar(4000), @Delimiter nvarchar(2);
	SET @Concat = '';
	SET @Delimiter = ', '
	SELECT @Concat = @Concat + @Delimiter + LTRIM(GroupName)
		 FROM (SELECT DISTINCT g.GroupName FROM ProvisioningGroup g 
			   INNER JOIN GroupToTemplate gt ON gt.GroupID = g.GroupID
			   WHERE gt.VirtualMachineTemplateID = @VirtualMachineTemplateID) derived
	RETURN SUBSTRING(@Concat, 3, LEN(@Concat));
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetVirtualMachinePropertyValue]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[GetVirtualMachinePropertyValue]
GO
CREATE FUNCTION [dbo].[GetVirtualMachinePropertyValue] (@VirtualMachineId uniqueidentifier,	@PropertyName nvarchar(128))
RETURNS nvarchar(max)
AS
	BEGIN
		DECLARE @ResultVar nvarchar(max)

		SELECT @ResultVar = PropertyValue
			FROM VirtualMachineProperties vmp
			WHERE vmp.PropertyName = @PropertyName
				AND vmp.EntityID = @VirtualMachineId

		RETURN @ResultVar
	END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostBasicView]'))
DROP VIEW [dbo].[HostBasicView]
GO
CREATE VIEW [dbo].[HostBasicView]
AS
	SELECT 
		Host.HostID
		,ClusterHostID
		,Host.PhysicalLocationID
		,Host.CostProfileID
		,Host.ManagementEndpointID
		,HostName
		,HostComments
		,HostOSType
		,HostManufacturer
		,HostModel
		,HostUniqueID
		,IsCluster
		,HostProcessors
		,HostProcessorSpeed
		,HostProcessorType
		,RecCreationTime
		,RecDeleteTime
		,RecUpdateTime
		,HostStateID
		,HostTotalMemoryMB
		,v1.HostUsedMemoryMB
		,v1.HostUsedStorageGB 
		,HostUsedFlCloneStorageGB  
		,HostTotalStorageGB
		,ProvisioningAgentID
		,(SELECT TOP 1 EnterpriseAdminID FROM AdminGroupToHost a WHERE a.HostID = Host.HostID) EnterpriseAdminGroupID         
		,dbo.GetEnterpriseAdminNamesForHost(Host.HostID) EnterpriseAdminGroups
		,CostProfileName
		,AgentName
		,AgentAlive
		,PhysicalLocationName        
		,NumOfVMsCreated  
		,NumOfVMsNonMissing
		,NumOfVMsManagedMissing
		,NumOfVMsCreatedHasReservation  
		,NumOfVMsUnregistered
		,(SELECT COUNT(r.HostReservationID) From HostReservation r WHERE r.HostID = Host.HostID) NumOfHostReservations
		,IsVRMManaged
		,HostDNSName 
	FROM [Host] LEFT OUTER JOIN 
		Agent ON Agent.AgentID = Host.ProvisioningAgentID LEFT OUTER JOIN
		CostProfile ON CostProfile.CostProfileID = Host.CostProfileID LEFT OUTER JOIN
		PhysicalLocation ON PhysicalLocation.PhysicalLocationID = Host.PhysicalLocationID
	LEFT OUTER JOIN
	(
		SELECT
				v.HostID
			,	SUM(CASE WHEN v.IsRunning = 1 THEN v.VMTotalMemoryMB END) AS HostUsedMemoryMB
			,	SUM(v.VMTotalStorageGB) AS HostUsedStorageGB
			,	SUM(v.VMUsedStorageGB) AS HostUsedFlCloneStorageGB
			,	SUM(CASE WHEN 
					v.IsTemplate = 0 and (v.IsMissing = 0 or v.VirtualMachineTemplateID is not null) 
					THEN 1 ELSE 0 END) AS NumOfVMsCreated
			,	SUM(CASE WHEN 
					v.IsTemplate = 0 and v.IsMissing = 0
					THEN 1 ELSE 0 END) AS NumOfVMsNonMissing
			,	SUM(CASE WHEN 
					v.IsTemplate = 0 and v.IsMissing = 1 and v.VirtualMachineTemplateID is not null
					THEN 1 ELSE 0 END) AS NumOfVMsManagedMissing
			,	SUM(CASE WHEN 
					v.HostReservationID is not null AND v.IsTemplate = 0
					THEN 1 ELSE 0 END) AS NumOfVMsCreatedHasReservation
			,	SUM(CASE WHEN 
					v.VirtualMachineTemplateID is null AND v.IsTemplate = 0 and v.IsMissing = 0
					THEN 1 ELSE 0 END) AS NumOfVMsUnregistered
		FROM VirtualMachine v
		GROUP BY v.HostID
	) v1 ON  v1.HostID = Host.HostID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
-- This view is duplicate of HostBasicView except relationship with EnterpriseAdminGroup
-- Merge these views once the capacity calculations based on HostBasicView are fixed
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostBasicView1]'))
DROP VIEW [dbo].[HostBasicView1]
GO
CREATE VIEW [dbo].[HostBasicView1]
AS
	SELECT 
		Host.HostID
		,ClusterHostID
		,Host.PhysicalLocationID
		,Host.CostProfileID
		,HostName
		,HostComments
		,HostOSType
		,HostManufacturer
		,HostModel
		,HostUniqueID
		,IsCluster
		,HostProcessors
		,HostProcessorSpeed
		,HostProcessorType
		,RecCreationTime
		,RecDeleteTime
		,RecUpdateTime
		,HostStateID
		,HostTotalMemoryMB
		,(SELECT SUM(v.VMTotalMemoryMB) From VirtualMachine v WHERE v.HostID = Host.HostID and v.IsRunning=1) HostUsedMemoryMB  
		,(SELECT SUM(v.VMTotalStorageGB) From VirtualMachine v WHERE v.HostID = Host.HostID) HostUsedStorageGB  
		,(SELECT SUM(v.VMUsedStorageGB) From VirtualMachine v WHERE v.HostID = Host.HostID) HostUsedFlCloneStorageGB  
		,HostTotalStorageGB
		,ProvisioningAgentID
		,AdminGroupToHost.EnterpriseAdminID EnterpriseAdminGroupID         
		,AdminName EnterpriseAdminGroups
		,CostProfileName
		,AgentName
		,AgentAlive
		,PhysicalLocationName        
		,(SELECT COUNT(v.VirtualMachineID) From VirtualMachine v WHERE v.HostID = Host.HostID) NumOfVMsCreated  
		,(SELECT COUNT(v.VirtualMachineID) From VirtualMachine v WHERE v.HostID = Host.HostID and v.HostReservationID is not null) NumOfVMsCreatedHasReservation  
		,(SELECT COUNT(v.VirtualMachineID) From VirtualMachine v WHERE v.HostID = Host.HostID and v.VirtualMachineTemplateID is null) NumOfVMsUnregistered
		,(SELECT COUNT(r.HostReservationID) From HostReservation r WHERE r.HostID = Host.HostID) NumOfHostReservations  
		,IsVRMManaged
		,HostDNSName 
	FROM [Host] LEFT OUTER JOIN 
		Agent ON Agent.AgentID = Host.ProvisioningAgentID LEFT OUTER JOIN
		CostProfile ON CostProfile.CostProfileID = Host.CostProfileID LEFT OUTER JOIN
		PhysicalLocation ON PhysicalLocation.PhysicalLocationID = Host.PhysicalLocationID LEFT OUTER JOIN
		AdminGroupToHost ON AdminGroupToHost.HostID = Host.HostID LEFT OUTER JOIN
		EnterpriseAdminGroups ON AdminGroupToHost.EnterpriseAdminID = EnterpriseAdminGroups.EnterpriseAdminID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostCapacityViewInt]'))
DROP VIEW [dbo].[HostCapacityViewInt]
GO
CREATE VIEW [dbo].[HostCapacityViewInt]
AS
	SELECT 
		h.HostID
		,h.ClusterHostID
		,h.PhysicalLocationID
		,h.CostProfileID
		,h.HostName
		,h.HostComments
		,h.HostOSType
		,h.HostManufacturer
		,h.HostModel
		,h.HostUniqueID
		,h.IsCluster
		,h.HostProcessors
		,h.HostProcessorSpeed
		,h.HostProcessorType
		,h.RecCreationTime
		,h.RecDeleteTime
		,h.RecUpdateTime
		,h.HostStateID
		,h.HostTotalMemoryMB
		,h.HostTotalStorageGB
		,h.HostUsedStorageGB HostActualUsedStorageGB
		,h.ProvisioningAgentID
		,h.EnterpriseAdminGroupID         
		,h.EnterpriseAdminGroups
		,h.CostProfileName
		,h.AgentName
		,h.AgentAlive
		,h.PhysicalLocationName        
		,h.NumOfVMsCreatedHasReservation
		,h.NumOfVMsCreated
		,h.NumOfVMsNonMissing
		,h.NumOfVMsManagedMissing
		,h.NumOfVMsUnregistered
		,h.NumOfHostReservations  
		,(SELECT COUNT(v.VirtualMachineID) From VirtualMachine v WHERE v.HostID = h.HostID and v.IsRunning=1) NumOfVMsPoweredOn  
		,(SELECT COUNT(v.VirtualMachineID) From VirtualMachine v WHERE v.HostID = h.HostID and v.IsRunning=1 and v.HostReservationID is not null) NumOfVMsPoweredOnHasReservation  
		,(SELECT SUM(v.VMTotalMemoryMB) From VirtualMachine v WHERE v.HostID = h.HostID and v.IsRunning=1) HostUsedMemoryMB  
		,(SELECT SUM(v.VMTotalStorageGB) From VirtualMachine v WHERE v.HostID = h.HostID) HostUsedStorageGB  
		,(SELECT SUM(v.VMUsedStorageGB) From VirtualMachine v WHERE v.HostID = h.HostID) HostUsedFlCloneStorageGB  
		,(SELECT SUM(r.ReservationMemorySizeMB) From HostReservation r WHERE r.HostID = h.HostID) HostReservedMemoryMB  
		,(SELECT SUM(r.ReservationStorageSizeGB) From HostReservation r WHERE r.HostID = h.HostID) HostReservedStorageGB  
		,
		MaxVMsPowerOn =
		CASE 
			WHEN 0 = ANY (SELECT r.MaxVMsPowerOn From HostReservation r WHERE r.HostID = h.HostID) THEN 0 ELSE (SELECT SUM(r.MaxVMsPowerOn) From HostReservation r WHERE r.HostID = h.HostID) 
		END 
		,(SELECT SUM(r.MaxVMsCreate) From HostReservation r WHERE r.HostID = h.HostID) MaxVMsCreate
		,h.IsVRMManaged
		,HostDNSName 
	FROM HostBasicView h
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostCapacityViewInt1]'))
DROP VIEW [dbo].[HostCapacityViewInt1]
GO
CREATE VIEW [dbo].[HostCapacityViewInt1]
AS
	SELECT 
		h.*
		,case when MaxVMsPowerOn <= NumOfVMsCreatedHasReservation then 0 else (MaxVMsPowerOn - NumOfVMsCreatedHasReservation) end FreeCreateVMQuota   
		,case when MaxVMsPowerOn <= NumOfVMsPoweredOnHasReservation then 0 else (MaxVMsPowerOn - NumOfVMsPoweredOnHasReservation) end FreePowerOnVMQuota  
		,case when HostTotalMemoryMB <= HostReservedMemoryMB then 0 else (HostTotalMemoryMB - HostReservedMemoryMB) end HostUnreservedMemoryMB  
		-- assume that if reservation is not there then use the total number to avoid negatives
		,dbo.DiffNoNegBigInt(ISNULL(HostReservedMemoryMB, HostTotalMemoryMB), HostUsedMemoryMB) HostFreeMemoryMB  
		,case when HostTotalStorageGB <= HostReservedStorageGB then 0 else (HostTotalStorageGB - HostReservedStorageGB) end HostUnreservedStorageGB  
		,dbo.DiffNoNegBigInt(ISNULL(HostReservedStorageGB, HostTotalStorageGB),  HostUsedStorageGB) HostFreeStorageGB  
		,(HostUsedStorageGB - HostUsedFlCloneStorageGB) HostFlCloneStorageSavingsGB  
	FROM HostCapacityViewInt h
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostCapacityView]'))
DROP VIEW [dbo].[HostCapacityView]
GO
CREATE VIEW [dbo].[HostCapacityView]
AS
	SELECT 
		h.*
		,dbo.Percentage(FreeCreateVMQuota, MaxVMsPowerOn) PercentFreeCreateVMQuota   
		,dbo.Percentage(NumOfVMsCreatedHasReservation, MaxVMsPowerOn) PercentUsedCreateVMQuota   
		,dbo.Percentage(FreePowerOnVMQuota, MaxVMsPowerOn) PercentFreePowerOnVMQuota  
		,dbo.Percentage(NumOfVMsCreatedHasReservation, MaxVMsPowerOn) PercentUsedPowerOnVMQuota  
		,dbo.Percentage(HostReservedMemoryMB, HostTotalMemoryMB) PercentMemoryReserved
		,dbo.Percentage(HostUnreservedMemoryMB, HostTotalMemoryMB) PercentMemoryUnreserved
		,dbo.Percentage(HostUsedMemoryMB, HostTotalMemoryMB) PercentMemoryAllocated
		,dbo.Percentage(HostFreeMemoryMB, HostTotalMemoryMB) PercentMemoryFree
		,dbo.DivideAsDecimal(HostTotalMemoryMB, 1024) HostTotalMemoryGB
		,dbo.DivideAsDecimal(HostReservedMemoryMB, 1024) HostReservedMemoryGB
		,dbo.DivideAsDecimal(HostUsedMemoryMB, 1024) HostAllocatedMemoryGB
		,dbo.DivideAsDecimal(HostFreeMemoryMB, 1024) HostFreeMemoryGB  
		,dbo.Percentage(HostReservedStorageGB, HostTotalStorageGB) PercentStorageReserved
		,dbo.Percentage(HostUnreservedStorageGB, HostTotalStorageGB) PercentStorage
		,dbo.Percentage(HostUsedStorageGB, HostTotalStorageGB) PercentStorageAllocated
		,dbo.Percentage(HostFreeStorageGB, HostTotalStorageGB) PercentStorageFree
		,dbo.Percentage(HostUsedFlCloneStorageGB, HostTotalStorageGB) HostPercentUsedFlConeStorage
		,dbo.Percentage(HostFlCloneStorageSavingsGB, HostUsedStorageGB) HostPercentSpaceEfficiency
		,dbo.DivideAsDecimal(HostTotalStorageGB, 1024) HostTotalStorageTB
		,dbo.DivideAsDecimal(HostReservedStorageGB, 1024) HostReservedStorageTB
		,dbo.DivideAsDecimal(HostUsedStorageGB, 1024) HostAllocatedStorageTB
		,dbo.DivideAsDecimal(HostFreeStorageGB, 1024) HostFreeStorageTB  
		,dbo.DivideAsDecimal(HostUsedFlCloneStorageGB, 1024) HostUsedFlCloneStorageTB  
	FROM HostCapacityViewInt1 h
	WHERE ClusterHostID is null -- return for non cluster members only
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[DataCollectionStatusViewInt]'))
DROP VIEW [dbo].[DataCollectionStatusViewInt]
GO
CREATE VIEW [dbo].[DataCollectionStatusViewInt]
AS
	SELECT
		DataCollectionStatusID 
		,s.AgentID
		,g.FilterSpecGroupID
		,g.FilterSpecGroupName
		,f.FilterSpecID
		,f.FilterSpecName
		,LastCollectedTime
		,LastCollectedStatus
		,CollectionStartTime
		,ScheduleExpression
		,DependsOnFilterSpecGroupID
		,AgentName
		,EntityID
		,h.HostName EntityName
		,s.IsDisabled
		,CASE WHEN h.HostID IS NULL THEN 1 ELSE h.IsVRMManaged END IsVRMManaged
		,CASE WHEN s.Frequency IS NULL THEN FrequencyInMinutes ELSE s.Frequency END FrequencyInMinutes
	FROM [DataCollectionStatus] s
		INNER JOIN FilterSpec f ON f.FilterSpecID = s.FilterSpecID
		INNER JOIN FilterSpecGroup g ON g.FilterSpecGroupID = f.FilterSpecGroupID
		INNER JOIN CollectionSchedule c ON g.ScheduleID = c.ScheduleID
		LEFT OUTER JOIN Agent a ON a.AgentID = s.AgentID
		LEFT OUTER JOIN Host h ON h.HostID = s.EntityID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[DataCollectionStatusView]'))
DROP VIEW [dbo].[DataCollectionStatusView]
GO
CREATE VIEW [dbo].[DataCollectionStatusView]
AS
	SELECT s.*
		   ,(SELECT LastCollectedStatus FROM [DataCollectionStatusViewInt] d 
			 WHERE (s.AgentID IS NULL OR d.AgentID = s.AgentID) AND 
				    (s.EntityID IS NULL OR d.EntityID = s.EntityID) AND 
				    d.FilterSpecGroupID = s.DependsOnFilterSpecGroupID) DependsOnLastCollectedStatus 
	FROM [DataCollectionStatusViewInt] s
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[LoggedOnCollectionStatusView]'))
DROP VIEW [dbo].[LoggedOnCollectionStatusView]
GO
CREATE VIEW [dbo].[LoggedOnCollectionStatusView]
AS
	select vm.VirtualMachineID, VirtualMachineName, VMDNSName, lu.LastUpdated, lu.AgentID, lu.ErrorCode from VirtualMachine vm left outer join 
		VMLoginUser lu on ( lu.VirtualMachineID = vm.VirtualMachineID AND 
			lu.LastUpdated = (select MAX(LastUpdated) from VMLoginUser lumax where lumax.VirtualMachineID = vm.VirtualMachineID))
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ReservationStorageSizeView]'))
DROP VIEW [dbo].[ReservationStorageSizeView]
GO
CREATE VIEW [dbo].[ReservationStorageSizeView]
AS
      SELECT r.HostReservationID, 
      
            SUM(CASE WHEN COALESCE(h.Flags, 0) <> 0 THEN 0
				ELSE COALESCE(s.MaxCapacity, 0) END) ReservationStorageSizeGB,
				
            SUM(CASE WHEN COALESCE(h.Flags, 0) <> 0 THEN 0
                WHEN COALESCE(s.Enabled, 0) = 1 THEN COALESCE(s.MaxCapacity, 0) 
				ELSE 0 END) ReservationStorageWithoutDisabledPathsSizeGB,
            
            MAX((CASE WHEN COALESCE(h.Flags, 0) <> 0 THEN 0
				      WHEN COALESCE(s.Enabled, 0) = 1 THEN COALESCE(st.StorageFreeCapacityGB, 0) 
                      ELSE 0 END)
                ) AS LargestFreeCapacityGB
                
      FROM [HostReservation] r
      LEFT OUTER JOIN 
            HostReservationToStorage s ON r.HostReservationID = s.HostReservationID
      LEFT OUTER JOIN
            HostToStorage h ON h.HostToStorageID = s.HostToStorageID
      LEFT OUTER JOIN
            Storage st ON st.StorageID = h.StorageID
      GROUP BY r.HostReservationID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ReservationUsedStorageSizeView]'))
DROP VIEW [dbo].[ReservationUsedStorageSizeView]
GO
CREATE VIEW [dbo].[ReservationUsedStorageSizeView]
AS
	-- TODO: DEPRECATE this view is not referenced by parent objects or application directly
	SELECT r.HostReservationID,
		COALESCE(SUM(v.VMTotalStorageGB), 0) ResUsedStorageGB,
		COALESCE(SUM(v.VMUsedStorageGB), 0) ResUsedFlCloneStorageGB,
		COALESCE(COUNT(v.VirtualMachineID), 0) ResNumOfVMsCreated
	FROM [HostReservation] r LEFT OUTER JOIN 
		HostReservationToStorage s ON r.HostReservationID = s.HostReservationID LEFT OUTER JOIN
		HostToStorage h ON h.HostToStorageID = s.HostToStorageID LEFT OUTER JOIN
		VirtualMachine v on v.HostStorageReservationID = s.HostReservationToStorageID
	WHERE s.Enabled = 1 and COALESCE(h.Flags, 0) = 0
	GROUP BY r.HostReservationID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ReservationView]'))
DROP VIEW [dbo].[ReservationView]
GO
CREATE VIEW [dbo].[ReservationView]
AS
	SELECT 
		 r.HostReservationID
		,HostReservationName
		,r.Enabled
		,r.GroupID
		,ReservationMemorySizeMB
		,rv.ReservationStorageSizeGB
		,MaxVMsPowerOn
		,MaxVMsCreate
		,r.ResourcePoolID
		,r.HostID
		,g.GroupName
		,h.HostName
		,StorageAllocationPolicyID
		,CurrentStorageAllocationIndex
		,CurrentNetworkAllocationIndex
		,ReservationPriority
		,r.ReservationPolicyID
		,r.IsFileLevelCloningEnabled
		,r.MachineType
		,(SELECT TOP 1 NetworkName FROM HostNic hn INNER JOIN HostNicToReservation nr ON nr.HostNicID = hn.HostNicID WHERE nr.HostReservationID = r.HostReservationID ORDER BY NetworkName) NetworkName
		,(SELECT TOP 1 StoragePath FROM HostToStorage hs INNER JOIN HostReservationToStorage a ON hs.HostToStorageID = a.HostToStorageID 
				WHERE a.HostReservationID = r.HostReservationID ORDER BY StoragePath) ReservationPath
		,rp.ResourcePoolName
		,p.name ReservationPolicyName
	FROM [HostReservation] r INNER JOIN 
		ReservationStorageSizeView rv on rv.HostReservationID = r.HostReservationID LEFT OUTER JOIN 
		ResourcePool rp ON rp.ResourcePoolID = r.ResourcePoolID LEFT OUTER JOIN 
		ProvisioningGroup g ON g.GroupID = r.GroupID LEFT OUTER JOIN 
		Host h ON h.HostID = r.HostID left outer join
		HostReservationPolicy p on p.id = r.ReservationPolicyID
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ReservationInfoView]'))
DROP VIEW [dbo].[ReservationInfoView]
GO
CREATE VIEW [dbo].[ReservationInfoView]
AS
	SELECT 
		r.*
		,(SELECT COUNT(v.VirtualMachineID) From VirtualMachine v WHERE v.HostReservationID = r.HostReservationID) ResNumOfVMsCreated  
		,(SELECT COUNT(v.VirtualMachineID) From VirtualMachine v WHERE v.HostReservationID = r.HostReservationID and v.IsRunning=1) ResNumOfVMsPoweredOn  
		,(SELECT SUM(v.VMTotalMemoryMB) From VirtualMachine v WHERE v.HostReservationID = r.HostReservationID and v.IsRunning=1) ResUsedMemoryMB  
		,(SELECT SUM(v.VMTotalStorageGB) From VirtualMachine v WHERE v.HostReservationID = r.HostReservationID) ResUsedStorageGB  
		,(SELECT SUM(v.VMEstimatedUsedSpace) From VirtualMachine v WHERE v.HostReservationID = r.HostReservationID) ResUsedFlCloneStorageGB  
		,(SELECT SUM(h.HostTotalMemoryMB) From Host h WHERE h.HostID = r.HostID) HostPhysicalMemoryMB  
		,(SELECT SUM(h.HostTotalStorageGB) From Host h WHERE h.HostID = r.HostID) HostPhysicalStorageGB 
		,(SELECT dbo.GetNetworkNamesForReservation(r.HostReservationID)) NetworkNames 
		,(SELECT dbo.GetStoragePathsForReservation(r.HostReservationID)) StoragePathNames 
		,ReservationMemorySizeMB/1024 ReservationMemoryGB
	FROM ReservationView r
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ReservationInfoExView]'))
DROP VIEW [dbo].[ReservationInfoExView]
GO
CREATE VIEW [dbo].[ReservationInfoExView]
AS
	SELECT 
		r.*
		,(MaxVMsCreate - ResNumOfVMsCreated) ResFreeCreateVMQuota   
		,(MaxVMsPowerOn - ResNumOfVMsPoweredOn) ResFreePowerOnVMQuota  
		,(ReservationMemorySizeMB - ResUsedMemoryMB) ResFreeMemoryMB  
		,(ReservationStorageSizeGB - ResUsedStorageGB) ResFreeStorageGB 
		,(ResUsedStorageGB - ResUsedFlCloneStorageGB) ResFlCloneStorageSavingsGB  
		,dbo.Percentage(ResUsedFlCloneStorageGB, ReservationStorageSizeGB) ResPercentUsedFlConeStorage
		,100 * (1 - (ResUsedFlCloneStorageGB/ResUsedStorageGB)) ResPercentSpaceEfficiency
	FROM ReservationInfoView r
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[RequestLastAction]'))
DROP VIEW [dbo].[RequestLastAction]
GO
CREATE VIEW [dbo].[RequestLastAction]
AS
	SELECT *
	FROM RequestAudit a 
	WHERE a.RequestAuditDate = 
	   (SELECT MAX(RequestAuditDate) 
		FROM (SELECT * FROM RequestAudit WHERE RequestAuditUser IS NOT NULL) b
		WHERE b.RequestID = a.RequestID AND a.RequestAuditUser IS NOT NULL)
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostStorageReservationUsedView]'))
DROP VIEW [dbo].[HostStorageReservationUsedView]
GO
CREATE VIEW [dbo].[HostStorageReservationUsedView]
AS
	SELECT	hts.StorageID
		,	SUM(ISNULL(vmd.Capacity, VMTotalStorageGB)) ReservedUsedCapacityInGB
		,	SUM(ISNULL(vmd.UsedCapacity, VMUsedStorageGB)) ReservedUsedFlCloneCapacityInGB
	FROM VirtualMachine v 
	LEFT JOIN VMDiskHardware vmd on vmd.VirtualMachineID = v.VirtualMachineID
	JOIN HostReservationToStorage r ON r.HostReservationToStorageID = v.HostStorageReservationID
	JOIN HostToStorage hts ON hts.HostToStorageID = ISNULL(vmd.HostToStorageID, r.HostToStorageID)
	GROUP BY hts.StorageID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostStorageReservationView]'))
DROP VIEW [dbo].[HostStorageReservationView]
GO
CREATE VIEW [dbo].[HostStorageReservationView]
AS
	SELECT hts.StorageID, COALESCE(SUM(MaxCapacity), 0) ReservedCapacityInGB 
	FROM HostReservationToStorage hrs 
		JOIN HostToStorage hts ON hts.HostToStorageID = hrs.HostToStorageID
	GROUP BY hts.StorageID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[uv_VirtualMachineCostView]'))
DROP VIEW [dbo].[uv_VirtualMachineCostView]
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [dbo].[uv_VirtualMachineCostView]
AS
SELECT     
    vm.VirtualMachineID,
	ISNULL(cp.CpuCost, 0) * vm.VMCPUs AS CpuCost,
	ISNULL(cp.MemoryCost,0) * vm.VMTotalMemoryMB / 1024 MemoryCost,
	storagetotalcost.HostDiskCost,
	storagetotalcost.StorageDiskCost AS StoragDiskCost,
	storagetotalcost.DiskCost,
	storagetotalcost.StorageUsedCost DiskFlCloneCost,
	ISNULL(vmt.Cost, 0) TemplateCost,
	(ISNULL(cp.MemoryCost,0) * vm.VMTotalMemoryMB / 1024) 
		+ storagetotalcost.DiskCost 
		+ (ISNULL(cp.CpuCost, 0) * vm.VMCPUs) 
		+  ISNULL(vmt.Cost, 0) AS VMCost
FROM    VirtualMachine vm
LEFT OUTER JOIN VirtualMachineTemplate AS vmt ON vmt.VirtualMachineTemplateID = vm.VirtualMachineTemplateID
LEFT OUTER JOIN Host AS h ON h.HostID = vm.HostID
LEFT OUTER JOIN CostProfile cp ON h.CostProfileID = cp.CostProfileID
LEFT OUTER JOIN
(
	-- calculate storage cost by machine id
	SELECT	m.VirtualMachineID,
			SUM(COALESCE(cp.DiskCost, 0) * COALESCE(vmd.Capacity, m.VMTotalStorageGB, 0))	AS HostDiskCost,
			SUM(COALESCE(scp.DiskCost, 0) * COALESCE(vmd.Capacity, m.VMTotalStorageGB, 0))	AS StorageDiskCost,
			SUM(COALESCE(scp.DiskCost, cp.DiskCost, 0) * COALESCE(vmd.Capacity, m.VMTotalStorageGB, 0))	AS DiskCost,
			SUM(COALESCE(scp.DiskCost, cp.DiskCost, 0) * COALESCE(vmd.UsedCapacity, m.VMUsedStorageGB, 0))	AS StorageUsedCost
	FROM	VirtualMachine m
	LEFT OUTER JOIN Host h				ON h.HostID = m.HostID 
	LEFT OUTER JOIN CostProfile cp		ON cp.CostProfileID = h.CostProfileID 
	LEFT OUTER JOIN VMDiskHardware vmd	on vmd.VirtualMachineID = m.VirtualMachineID
	LEFT OUTER JOIN HostToStorage hs		ON hs.HostToStorageID = vmd.HostToStorageID 
	LEFT OUTER JOIN StorageCostProfiles scp	ON scp.Id = hs.StorageCostProfileId
	GROUP BY m.VirtualMachineID
)  AS storagetotalcost  ON vm.VirtualMachineID = storagetotalcost.VirtualMachineID

GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[uv_ProvisioningGroupCostView]'))
DROP VIEW [dbo].[uv_ProvisioningGroupCostView]
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [dbo].[uv_ProvisioningGroupCostView]
AS
SELECT     
	PG.GroupID,
	MIN(CP.MemoryCost) AS MinMemoryCost,
	MAX(CP.MemoryCost) AS MaxMemoryCost,
	MIN(CP.DiskCost) AS MinDiskCost,
	MAX(CP.DiskCost) AS MaxDiskCost
FROM
	dbo.ProvisioningGroup PG
	INNER JOIN dbo.HostReservation R ON (PG.GroupID = R.GroupID)
	INNER JOIN dbo.Host AS H ON (H.HostID = R.HostID)
	INNER JOIN dbo.CostProfile CP ON (H.CostProfileID = CP.CostProfileID)
GROUP BY
	PG.GroupID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[RequestView]'))
DROP VIEW [dbo].[RequestView]
GO
CREATE VIEW [dbo].[RequestView]
AS
	SELECT 
		R.RequestID
		,U.UserName AS RequestUser
		,RequestDate
		,RequestComments
		,RequestFilter
		,RequestDescription
		,R.VirtualMachineID
		,R.HostID
		,R.VirtualMachineTemplateID
		,R.GroupID
		,RequestState
		,CompleteDate
		,RequestTypeID
		,ReasonFlags
		,R.WorkflowID
		,WI.WorkflowName
		,G.GroupName
		,H.HostName
		,VM.VirtualMachineName
		,VM.VirtualMachineState
		,LA.RequestAuditTypeID
		,LA.RequestAuditState
		,LA.RequestAuditDate
		,LA.RequestAuditUser
		,VM.Flags VirtualMachineFlags
		,VMC.VMCost Cost
	FROM
		[Request] R
		LEFT OUTER JOIN [RequestLastAction] LA ON (LA.RequestID = R.RequestID)
		LEFT OUTER JOIN ProvisioningGroup G ON (G.GroupID = R.GroupID)
		LEFT OUTER JOIN VirtualMachine VM ON (R.VirtualMachineID = VM.VirtualMachineID)
		LEFT OUTER JOIN WorkflowInfo WI ON (R.WorkflowID = WI.WorkflowID)
		LEFT OUTER JOIN uv_VirtualMachineCostView VMC ON (VM.VirtualMachineID = VMC.VirtualMachineID)
		LEFT OUTER JOIN Host H ON (R.HostID = H.HostID)
		LEFT OUTER JOIN Users U ON U.UserID = R.RequestUser
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[LastLogonUserView]'))
DROP VIEW [dbo].[LastLogonUserView]
GO
CREATE VIEW [dbo].[LastLogonUserView]
AS
	select lu.VirtualMachineID, lu.LoginUserName, MAX(lu.LastLoginDate) LastLoginDate 
	from VMLoginUser lu 
	where lu.LoginUserName not in (select iu.LoginUserName from LastLoginIgnoreUser iu where iu.VirtualMachineID = lu.VirtualMachineID) and 
	lu.LoginUserName <> 'error'
	and lu.LastLoginDate is not null
	GROUP BY lu.LoginUserName, lu.VirtualMachineID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[VMTemplateView]'))
DROP VIEW [dbo].[VMTemplateView]
GO
CREATE VIEW [dbo].[VMTemplateView]
AS
	SELECT 
		VMT.VirtualMachineTemplateID
		,VMT.VirtualMachineTemplateName
		,VMT.VirtualMachineTemplateDescription
		,VMT.ExpireDays
		,VMT.LeaseDays
		,VMT.Enabled
		,VMT.RequiresApproval
		,VMT.Master
		,VMT.IsGlobal
		,VMT.BlueprintType
		,TG.GlobalProfileID
		,VMT.MemoryMB
		,VMT.MemoryMaxMB
		,VMT.DiskSize0GB
		,VMT.DiskSizeMaxGB
		,VMT.CPUCount
		,VMT.CPUCountMax
		,VMT.MachinePrefix
		,VMT.Cost
		,VMT.MaxVMsPerUser
		,VMT.InheritsFromVMTemplateID
		,G.GroupID
		,G.GroupName
		,G.AdministratorEmail
		,G.IsTestGroup
		,W.WorkflowID
		,W.WorkflowName
		,W.AssemblyFQN
		,W.WorkflowDescription
		,VMT.RecCreationTime
		,VMT.RecDeleteTime
		,VMT.RecUpdateTime
		,VMT.ApprovalPolicyId
		,VMT.LeaseDaysMax
		,VMT.ReservationPolicyID
		,VMT.MachineType
	FROM VirtualMachineTemplate AS VMT LEFT OUTER JOIN
	GroupToTemplate AS GT ON GT.VirtualMachineTemplateID = VMT.VirtualMachineTemplateID LEFT OUTER JOIN
	TemplateToGlobalProfiles AS TG ON TG.VirtualMachineTemplateID = VMT.VirtualMachineTemplateID LEFT OUTER JOIN
	[ProvisioningGroup] AS G ON G.GroupID = GT.GroupID LEFT OUTER JOIN
	[WorkflowInfo] AS W ON W.WorkflowID = VMT.WorkflowID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[uv_VirtualMachineView]'))
DROP VIEW [dbo].[uv_VirtualMachineView]
GO
CREATE VIEW [dbo].[uv_VirtualMachineView]
AS
SELECT     v.VirtualMachineID, v.HostID, v.VirtualMachineTemplateID, v.IsManaged, v.HostReservationID, v.ResourcePoolID, v.VirtualMachineName, v.Expires, v.ExpireDays, v.BlueprintType, v.InitiatorType, 
					  v.Notes, v.GuestOS, v.VMUniqueID, v.PlatformDetails, v.VMCreationDate, v.VMDeleteDate, v.LastLoggedDate, v.LastLoggedUser, v.LastPowerOffDate, 
					  v.LastPowerOnDate, v.OwnerExists, v.UsageIndex, v.UsageIndexIgnoreBy, v.IsDeleted, v.IsMissing, v.IsRogue, v.IsRunning, v.RecCreationTime, v.RecDeleteTime, 
					  v.RecUpdateTime, v.Flags, v.Text1, v.Text2, v.VMCPUs, v.VMTotalMemoryMB, v.VMTotalStorageGB, v.GuestOSFamily, v.VirtualMachineState, v.IsComponent,
					  v.HostStorageReservationID, v.StoragePath, v.IsTemplate, v.ConnectToVdi, v.VMDNSName, v.VMUsedStorageGB, v.FileLevelCloneImageName, v.VMInitialUsedSpace, v.VMEstimatedUsedSpace, 
					  v.PhysicalMachineID, v.MachineType, h.HostName, hr.HostReservationName, r.ResourcePoolName, t.VirtualMachineTemplateName, g.GroupID, g.GroupName, uApprover.UserName as Approver, uOwner.UserName as Owner,
					  v.CurrentTask
FROM         dbo.VirtualMachine AS v LEFT OUTER JOIN
					  dbo.HostReservation AS hr ON hr.HostReservationID = v.HostReservationID LEFT OUTER JOIN
					  dbo.Host AS h ON h.HostID = v.HostID LEFT OUTER JOIN
					  dbo.VirtualMachineTemplate AS t ON t.VirtualMachineTemplateID = v.VirtualMachineTemplateID LEFT OUTER JOIN
					  dbo.ProvisioningGroup AS g ON g.GroupID = hr.GroupID LEFT OUTER JOIN
					  dbo.ResourcePool AS r ON r.ResourcePoolID = v.ResourcePoolID LEFT OUTER JOIN
					  dbo.Users AS uOwner ON v.Owner = uOwner.UserID LEFT OUTER JOIN
					  dbo.Users AS uApprover ON v.Approver = uApprover.UserID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[VirtualMachineInfoView]'))
DROP VIEW [dbo].[VirtualMachineInfoView]
GO
CREATE VIEW [dbo].[VirtualMachineInfoView]
AS
SELECT     
	v.* 
	,CpuUsageAverage
	,MemUsageAverage
	,DiskUsageAverage
	,NetUsageAverage
	,LastCollectedTime
	,PerfTimeStamp
FROM
	[uv_VirtualMachineView] AS v
	LEFT OUTER JOIN [VMPerformance] p ON p.VirtualMachineID = v.VirtualMachineID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ProvisioningGroupView]'))
DROP VIEW [dbo].[ProvisioningGroupView]
GO
CREATE VIEW [dbo].[ProvisioningGroupView]
AS
	SELECT g.*,
		p.MachinePrefix, p.NextMachineNo, p.MachineNumberLength,
		(SELECT COUNT(VirtualMachineID) FROM VirtualMachine v INNER JOIN 
			HostReservation r on r.HostReservationID = v.HostReservationID WHERE r.GroupID = g.GroupID) NumberOfVMs,
		(SELECT COUNT(VirtualMachineTemplateID) FROM GroupToTemplate t where t.GroupID = g.GroupID) NumberOfTemplates
	FROM ProvisioningGroup g LEFT OUTER JOIN
		HostNamePrefix p ON p.HostnamePrefixID = g.HostnamePrefixID
	where GroupType = 0 
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ProvisioningGroupCapacityViewInt]'))
DROP VIEW [dbo].[ProvisioningGroupCapacityViewInt]
GO
CREATE VIEW [dbo].[ProvisioningGroupCapacityViewInt]
AS
	SELECT g.*
		,(SELECT SUM(v.VMTotalMemoryMB) From uv_VirtualMachineView v WHERE v.GroupID = g.GroupID and v.IsRunning=1) GroupUsedMemoryMB  
		,(SELECT SUM(v.VMTotalStorageGB) From uv_VirtualMachineView v WHERE v.GroupID = g.GroupID) GroupUsedStorageGB  
		,(SELECT SUM(v.VMUsedStorageGB) From uv_VirtualMachineView v WHERE v.GroupID = g.GroupID) GroupUsedFlCloneStorageGB  
		,(SELECT SUM(r.ReservationMemorySizeMB) From HostReservation r WHERE r.GroupID = g.GroupID) GroupReservedMemoryMB  
		,(SELECT SUM(r.ReservationStorageSizeGB) From HostReservation r WHERE r.GroupID = g.GroupID) GroupReservedStorageGB  
		,(SELECT SUM(r.MaxVMsPowerOn) From HostReservation r WHERE r.GroupID = g.GroupID) VirtualMachineQuota  
		,(SELECT COUNT(v.VirtualMachineID) From uv_VirtualMachineView v WHERE v.GroupID = g.GroupID and v.IsRunning=1) NumOfVMsPoweredOn  
		,(SELECT COUNT(v.VirtualMachineID) From uv_VirtualMachineView v WHERE v.GroupID = g.GroupID) NumOfVMsCreated  
		,(SELECT COUNT(r.HostReservationID) From HostReservation r WHERE r.GroupID = g.GroupID) NumOfHostReservations  
	FROM [ProvisioningGroupView] g
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ProvisioningGroupCapacityViewInt1]'))
DROP VIEW [dbo].[ProvisioningGroupCapacityViewInt1]
GO
CREATE VIEW [dbo].[ProvisioningGroupCapacityViewInt1]
AS
	SELECT 
		g.*
		,(VirtualMachineQuota - NumOfVMsPoweredOn) FreeVirtualMachineQuota  
		-- assume that if reservation is not there then use the total number to avoid negatives
		,case when GroupReservedMemoryMB <= GroupUsedMemoryMB then 0 else (GroupReservedMemoryMB - GroupUsedMemoryMB) end GroupFreeMemoryMB  
		,case when GroupReservedStorageGB <= GroupUsedStorageGB then 0 else (GroupReservedStorageGB - GroupUsedStorageGB) end GroupFreeStorageGB  
		,(GroupUsedStorageGB - GroupUsedFlCloneStorageGB) GroupFlCloneStorageSavingsGB  
	FROM [ProvisioningGroupCapacityViewInt] g
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ProvisioningGroupCapacityView]'))
DROP VIEW [dbo].[ProvisioningGroupCapacityView]
GO
CREATE VIEW [dbo].[ProvisioningGroupCapacityView]
AS
	SELECT 
		g.*
		,dbo.Percentage(FreeVirtualMachineQuota, VirtualMachineQuota) PercentFreeVirtualMachineQuota   
		,dbo.Percentage(GroupUsedMemoryMB, GroupReservedMemoryMB) PercentMemoryAllocated
		,dbo.Percentage(GroupFreeMemoryMB, GroupReservedMemoryMB) PercentMemoryFree
		,dbo.DivideAsDecimal(GroupReservedMemoryMB, 1024) GroupReservedMemoryGB
		,dbo.DivideAsDecimal(GroupUsedMemoryMB, 1024) GroupUsedMemoryGB
		,dbo.DivideAsDecimal(GroupFreeMemoryMB, 1024) GroupFreeMemoryGB  
		,dbo.Percentage(GroupUsedStorageGB, GroupReservedStorageGB) PercentStorageAllocated
		,dbo.Percentage(GroupFreeStorageGB, GroupReservedStorageGB) PercentStorageFree
		,dbo.Percentage(GroupUsedFlCloneStorageGB, GroupReservedStorageGB) GroupPercentUsedFlConeStorage
		,dbo.Percentage(GroupFlCloneStorageSavingsGB, GroupUsedStorageGB) GroupPercentSpaceEfficiency
		,dbo.DivideAsDecimal(GroupReservedStorageGB, 1024) GroupReservedStorageTB
		,dbo.DivideAsDecimal(GroupUsedStorageGB, 1024) GroupUsedStorageTB
		,dbo.DivideAsDecimal(GroupFreeStorageGB, 1024) GroupFreeStorageTB  
		,dbo.DivideAsDecimal(GroupUsedFlCloneStorageGB, 1024) GroupUsedFlCloneStorageTB  
		,dbo.DivideAsDecimal(GroupFlCloneStorageSavingsGB, 1024) GroupFlCloneStorageSavingsTB  
	FROM [ProvisioningGroupCapacityViewInt1] g
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCategoriesForAuditMessage]') AND type in (N'P', N'FN'))
DROP FUNCTION [dbo].[GetCategoriesForAuditMessage]
GO
CREATE FUNCTION [dbo].[GetCategoriesForAuditMessage] (@LogID int)
RETURNS nvarchar(4000) AS
BEGIN
	DECLARE @Concat nvarchar(4000), @Delimiter nvarchar(1);
	SET @Concat = '';
	SET @Delimiter = ','
	SELECT @Concat = @Concat + @Delimiter + LTRIM(CategoryName)
		 FROM (SELECT  cn.CategoryName from CategoryLog cl LEFT OUTER JOIN 
		 Categories cn on cn.CategoryID = cl.CategoryID 
		 WHERE LogID=@LogID
		 ) derived
	RETURN SUBSTRING(@Concat, 2, LEN(@Concat));
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ReclaimedVirtualMachineView]'))
DROP VIEW [dbo].[ReclaimedVirtualMachineView]
GO
CREATE VIEW [dbo].[ReclaimedVirtualMachineView]
AS
SELECT     
	v.VirtualMachineID, 
	v.VirtualMachineTemplateID, 
	v.HostID, 
	v.HostReservationID, 
	v.ResourcePoolID, 
	v.VirtualMachineName, 
	v.Expires, 
	v.BlueprintType, 
	v.InitiatorType, 
	v.Notes, 
	v.GuestOS, 
	v.VMUniqueID, 
	v.PlatformDetails, 
	v.VMCreationDate, 
	v.VMDeleteDate, 
	v.LastLoggedDate, 
	v.LastLoggedUser, 
	v.LastPowerOffDate, 
	v.LastPowerOnDate, 
	v.OwnerExists, 
	v.UsageIndex, 
	v.UsageIndexIgnoreBy, 
	v.IsDeleted, 
	v.IsMissing, 
	v.IsRogue, 
	v.IsRunning, 
	v.RecCreationTime, 
	v.RecDeleteTime, 
	v.RecUpdateTime, 
	v.Flags, 
	v.Text1, 
	v.Text2, 
	v.VMCPUs, 
	v.VMTotalMemoryMB, 
	v.VMTotalStorageGB, 
	v.GuestOSFamily, 
	v.VirtualMachineState,
	v.HostStorageReservationID, 
	v.IsTemplate, 
	v.ConnectToVdi, 
	v.VMDNSName, 
	v.VMUsedStorageGB, 
	v.FileLevelCloneImageName, 
	v.VMInitialUsedSpace, 
	v.VMEstimatedUsedSpace, 
	v.PhysicalMachineID,
	v.IsComponent,
	uApprover.UserName AS Approver,
	uOwner.UserName AS Owner,
	h.HostName, 
	hr.HostReservationName,
	r.ResourcePoolName,
	t.VirtualMachineTemplateName,
	g.GroupID,
	g.GroupName
FROM
	dbo.VirtualMachine AS v
	LEFT OUTER JOIN HostReservation hr ON hr.HostReservationID = v.HostReservationID
	LEFT OUTER JOIN Host h ON h.HostID = v.HostID
	LEFT OUTER JOIN VirtualMachineTemplate t ON t.VirtualMachineTemplateID = v.VirtualMachineTemplateID
	LEFT OUTER JOIN ProvisioningGroup g ON g.GroupID = hr.GroupID
	LEFT OUTER JOIN ResourcePool r ON r.ResourcePoolID = v.ResourcePoolID
	LEFT OUTER JOIN Users uOwner ON uOwner.UserID = v.Owner
	LEFT OUTER JOIN Users uApprover ON uApprover.UserID = v.Approver
WHERE v.Flags & 2 > 0
UNION 
SELECT     
	v.VirtualMachineID, 
	v.VirtualMachineTemplateID, 
	v.HostID, 
	v.HostReservationID, 
	v.ResourcePoolID, 
	v.VirtualMachineName, 
	v.Expires, 
	v.BlueprintType, 
	v.InitiatorType, 
	v.Notes, 
	v.GuestOS, 
	v.VMUniqueID, 
	v.PlatformDetails, 
	v.VMCreationDate, 
	v.VMDeleteDate, 
	v.LastLoggedDate, 
	v.LastLoggedUser, 
	v.LastPowerOffDate, 
	v.LastPowerOnDate, 
	v.OwnerExists, 
	v.UsageIndex, 
	v.UsageIndexIgnoreBy, 
	v.IsDeleted, 
	v.IsMissing, 
	v.IsRogue, 
	v.IsRunning, 
	v.RecCreationTime, 
	v.RecDeleteTime, 
	v.RecUpdateTime, 
	v.Flags, 
	v.Text1, 
	v.Text2, 
	v.VMCPUs, 
	v.VMTotalMemoryMB, 
	v.VMTotalStorageGB, 
	v.GuestOSFamily, 
	v.VirtualMachineState,
	v.HostStorageReservationID, 
	v.IsTemplate, 
	v.ConnectToVdi, 
	v.VMDNSName, 
	v.VMUsedStorageGB, 
	v.FileLevelCloneImageName, 
	v.VMInitialUsedSpace, 
	v.VMEstimatedUsedSpace, 
	v.PhysicalMachineID,
	v.IsComponent,
	uApprover.UserName AS Approver,
	uOwner.UserName AS Owner, 
	h.HostName, 
	hr.HostReservationName,
	r.ResourcePoolName,
	t.VirtualMachineTemplateName,
	g.GroupID,
	g.GroupName
FROM
	dbo.VirtualMachineHistory AS v
	LEFT OUTER JOIN HostReservation hr ON hr.HostReservationID = v.HostReservationID
	LEFT OUTER JOIN Host h ON h.HostID = v.HostID
	LEFT OUTER JOIN VirtualMachineTemplate t ON t.VirtualMachineTemplateID = v.VirtualMachineTemplateID
	LEFT OUTER JOIN ProvisioningGroup g ON g.GroupID = hr.GroupID
	LEFT OUTER JOIN ResourcePool r ON r.ResourcePoolID = v.ResourcePoolID
	LEFT OUTER JOIN Users uOwner ON uOwner.UserID = v.Owner
	LEFT OUTER JOIN Users uApprover ON uApprover.UserID = v.Approver
WHERE v.Flags & 2 > 0 OR v.Flags & 4 > 0
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ReclaimedVirtualMachineCostView]'))
DROP VIEW [dbo].[ReclaimedVirtualMachineCostView]
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [dbo].[ReclaimedVirtualMachineCostView]
AS
SELECT     
	VM.*,
	ISNULL(CP.MemoryCost,0) * VM.VMTotalMemoryMB / 1024 MemoryCost,
	ISNULL(CP.DiskCost,0) * VM.VMTotalStorageGB DiskCost,
	ISNULL(CP.DiskCost,0) * VM.VMUsedStorageGB DiskFlCloneCost,
	ISNULL(VMT.Cost, 0) TemplateCost,
	(ISNULL(CP.MemoryCost,0) * VM.VMTotalMemoryMB / 1024) + (ISNULL(CP.DiskCost,0) * VM.VMTotalStorageGB) + ISNULL(VMT.Cost, 0) VMCost
FROM
	ReclaimedVirtualMachineView VM
	LEFT OUTER JOIN dbo.VirtualMachineTemplate AS VMT ON (VMT.VirtualMachineTemplateID = VM.VirtualMachineTemplateID)
	LEFT OUTER JOIN dbo.Host AS H ON (H.HostID = VM.HostID)
	LEFT OUTER JOIN dbo.CostProfile CP ON (H.CostProfileID = CP.CostProfileID)
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ProvisioningGroupCostSavingsView]'))
DROP VIEW [dbo].[ProvisioningGroupCostSavingsView]
GO
CREATE VIEW [dbo].[ProvisioningGroupCostSavingsView]
AS
	select v.GroupID, v.GroupName,
		COUNT(v.VirtualMachineID) NumberOfVMs,
		SUM(ISNULL(v.VMTotalStorageGB,0)) GroupAllocatedStorageGB, 
		SUM(ISNULL(v.VMUsedStorageGB,0)) GroupUsedStorageGB, 
		SUM(c.DiskCost) GroupAllocatedStorageCost,
		SUM(c.DiskFlCloneCost) GroupUsedStorageCost,
		SUM(c.DiskCost - c.DiskFlCloneCost) Savings
	from uv_VirtualMachineCostView c inner join uv_VirtualMachineView v on c.VirtualMachineID = v.VirtualMachineID
	where v.GroupName is not null
	group by v.GroupID, v.GroupName
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[VMStorageFromReservation]'))
DROP VIEW [dbo].[VMStorageFromReservation]
GO
CREATE VIEW [dbo].[VMStorageFromReservation]
AS
	-- TODO: DEPRECATE this view is not referenced by parent objects or application directly
	select VirtualMachineID, VirtualMachineName, hs.StorageID, hs.StoragePath FROM VirtualMachine v INNER JOIN 
		HostReservationToStorage sr on v.HostStorageReservationID = sr.HostReservationToStorageID INNER JOIN 
		HostToStorage hs on sr.HostToStorageID = hs.HostToStorageID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[VMStorageFromDisk]'))
DROP VIEW [dbo].[VMStorageFromDisk]
GO
CREATE VIEW [dbo].[VMStorageFromDisk]
AS
	select v.VirtualMachineID, VirtualMachineName, hs.StorageID, hs.StoragePath FROM VirtualMachine v INNER JOIN 
		(select VirtualMachineID, (select top 1 HostToStorageID from VMDiskHardware d where d.VirtualMachineID = v.VirtualMachineID) HostToStorageID from VirtualMachine v) t on t.VirtualMachineID = v.VirtualMachineID INNER JOIN
		HostToStorage hs on t.HostToStorageID = hs.HostToStorageID

GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[VMStorageMismatch]'))
DROP VIEW [dbo].[VMStorageMismatch]
GO
CREATE VIEW [dbo].[VMStorageMismatch]
AS
	select r.VirtualMachineID, r.VirtualMachineName, r.StorageID ResStorageID, r.StoragePath ResStoragePath, d.StorageID ActualStorageID, d.StoragePath ActualStoragePath, 
		(case when r.StorageID = d.StorageID then 0 else 1 end) MisMatch  FROM VMStorageFromReservation r INNER JOIN 
		VMStorageFromDisk d on d.VirtualMachineID = r.VirtualMachineID
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[EntityProperties]'))
DROP VIEW [dbo].[EntityProperties]
GO
CREATE VIEW [dbo].[EntityProperties]
AS
	SELECT     EntityID, PropertyName, PropertyValue, IsHidden, IsRuntime, IsEncrypted
	FROM       (SELECT     Id, EntityID, PropertyName, PropertyValue, IsHidden, IsRuntime, IsEncrypted
                FROM          dbo.VirtualMachineProperties
                UNION ALL
                SELECT     Id, EntityID, PropertyName, PropertyValue, IsHidden, IsRuntime, IsEncrypted
                FROM         dbo.RequestProperties
                UNION ALL
                SELECT     Id, EntityID, PropertyName, PropertyValue, IsHidden, IsRuntime, IsEncrypted
                FROM         dbo.HostProperties
                UNION ALL
                SELECT     Id, EntityID, PropertyName, PropertyValue, IsHidden, IsRuntime, IsEncrypted
                FROM         dbo.GlobalProfileProperties
                UNION ALL
                SELECT     Id, EntityID, PropertyName, PropertyValue, IsHidden, IsRuntime, IsEncrypted
                FROM         dbo.HostReservationProperties
                UNION ALL
                SELECT     Id, EntityID, PropertyName, PropertyValue, IsHidden, IsRuntime, IsEncrypted
                FROM         dbo.ProvisioningGroupProperties
                UNION ALL
                SELECT     Id, EntityID, PropertyName, PropertyValue, IsHidden, IsRuntime, IsEncrypted
                FROM         dbo.VirtualMachineTemplateProperties
                UNION ALL
                SELECT     Id, EntityID, PropertyName, PropertyValue, IsHidden, IsRuntime, IsEncrypted
                FROM         dbo.VirtualMachineHistoryProperties
                UNION ALL
                SELECT     Id, ManagementEndpointID AS EntityID, Name AS PropertyName, Value AS PropertyValue, IsHidden, IsRuntime, IsEncrypted
                FROM         dbo.ManagementEndpointProperties
               ) AS entityProperties
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetVirtualMachineUsedStoragePathsSummary]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
	DROP FUNCTION [dbo].[GetVirtualMachineUsedStoragePathsSummary]
GO
CREATE FUNCTION [dbo].[GetVirtualMachineUsedStoragePathsSummary] (@VirtualMachineID UNIQUEIDENTIFIER)
RETURNS NVARCHAR(MAX) AS
BEGIN
	DECLARE @T TABLE(
		[StoragePath] [nvarchar](256) NOT NULL,
		[TotalCapacity] [bigint] NULL
	)
	INSERT INTO @T (StoragePath, TotalCapacity)
		SELECT hs.StoragePath, Sum(d.Capacity) TotalCapacity
		FROM VirtualMachine vm
			JOIN VMDiskHardware d on d.VirtualMachineID = vm.VirtualMachineID
			JOIN HostToStorage hs on d.HostToStorageID = hs.HostToStorageID
		WHERE vm.VirtualMachineID = @VirtualMachineID
		GROUP BY hs.StoragePath
		ORDER BY TotalCapacity DESC

	DECLARE @Info NVARCHAR(MAX)
	SELECT @Info = COALESCE(@Info + ', ', '') + StoragePath + '[' + Cast(TotalCapacity as NVarChar(max))+' GB]' FROM @T
	RETURN @Info
END
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[VirtualMachineExt]'))
DROP VIEW [dbo].[VirtualMachineExt]
GO
CREATE VIEW [dbo].[VirtualMachineExt] --WITH SCHEMABINDING

AS
	SELECT
		v.VirtualMachineID
		,dbo.GetVirtualMachineUsedStoragePathsSummary(v.VirtualMachineID) StoragePathsSummary
		,MachineName = NULLIF(v.VirtualMachineName, '')
		,[Status]  = 
		CASE
			WHEN v.IsMissing = 1 THEN 'Missing'
			WHEN v.IsManaged = 0 and v.HostReservationID IS NULL THEN 'Unmanaged'
			WHEN v.IsManaged = 0 and v.HostReservationID IS NOT NULL THEN 'Reserved'
			WHEN v.VirtualMachineState = 'InstallTools' OR v.VirtualMachineState = 'Install Tools' THEN 'Installing Tools'
			WHEN v.VirtualMachineState = 'VdiRegister' OR v.VirtualMachineState = 'VdiRegisterUser' THEN 'Registering virtual desktop'
			WHEN v.VirtualMachineState = 'VdiUnregister' OR v.VirtualMachineState = 'VdiUnregisterUser' THEN 'Unregistering virtual desktop and user'
			WHEN v.CurrentTask IS NOT NULL THEN v.VirtualMachineState + ' (' + v.CurrentTask + ')'
			ELSE v.VirtualMachineState
		END
		,MachineType = 
		CASE
			WHEN v.MachineType = 1 THEN 'Physical' 
			WHEN v.MachineType = 2 THEN 'Cloud' 
			WHEN v.MachineType = 3 THEN 'Multi-Machine'
			ELSE 'Virtual'
		END
		,BlueprintName = t.VirtualMachineTemplateName
		,UserName = u.UserName
		,HostName = 
		CASE
			WHEN v.MachineType != 1 THEN h.HostName
			ELSE NULL
		END
		,GroupName = pg.GroupName
		,ReservationName = hr.HostReservationName
		,EndpointName = 
		CASE
			WHEN v.MachineType = 1 THEN epc.ManagementEndpointName
			ELSE eh.ManagementEndpointName
		END
		,EndpointInterfaceType = 
		CASE
			WHEN v.MachineType = 1 THEN epc.InterfaceType
			ELSE eh.InterfaceType
		END
		,CostProfileName = cp.CostProfileName
		,DestructionDate = DATEADD(day, ISNULL(v.ExpireDays, 0), v.Expires)
		,VMCPUs=
		CASE
			WHEN v.MachineType = 1 THEN pm.ProcessorCount
			ELSE v.VMCPUs
		END
		,VMTotalMemoryGB = 
		CASE
			WHEN v.MachineType = 1 THEN CAST(ROUND(CAST(pm.MemoryInMB AS FLOAT)/ 1024, 1) AS REAL)
			ELSE CAST(ROUND(CAST(ISNULL(v.VMTotalMemoryMB, 0) AS FLOAT)/ 1024, 1) AS REAL)
		END
		,VMTotalStorageGB = 
		CASE
			WHEN v.MachineType != 1 THEN v.VMTotalStorageGB
			ELSE NULL
		END
		,OwnerExistsString = 
		CASE
			WHEN v.OwnerExists = 1 THEN 'Yes' ELSE 'No'
		END
		,IsMissingString = 
		CASE
			WHEN v.IsMissing = 1 THEN 'Yes' ELSE 'No'
		END

	FROM [dbo].VirtualMachine v LEFT OUTER JOIN
		 [dbo].VirtualMachineTemplate t ON v.VirtualMachineTemplateID = t.VirtualMachineTemplateID LEFT OUTER JOIN
		 [dbo].Users u ON v.[Owner] = u.UserID LEFT OUTER JOIN
		 [dbo].Host h ON v.HostID = h.HostID LEFT OUTER JOIN
		 [dbo].HostReservation hr ON v.HostReservationID = hr.HostReservationID LEFT OUTER JOIN
		 [dbo].ProvisioningGroup pg ON hr.GroupID = pg.GroupID LEFT OUTER JOIN
		 [dbo].PhysicalMachines pm ON v.PhysicalMachineID = pm.PhysicalMachineID LEFT OUTER JOIN
		 [dbo].PhysicalControllers pc ON pm.PhysicalController_PhysicalControllerID = pc.PhysicalControllerID LEFT OUTER JOIN
		 [dbo].ManagementEndpoints epc ON pc.ManagementEndpoint_ManagementEndpointID = epc.ManagementEndpointID LEFT OUTER JOIN
		 [dbo].ManagementEndpoints eh ON h.ManagementEndpointID = eh.ManagementEndpointID LEFT OUTER JOIN
		 [dbo].CostProfile cp ON pm.CostProfileID = cp.CostProfileID 	 
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MachineUsageByState]'))
DROP VIEW [dbo].[MachineUsageByState]
GO
CREATE VIEW [dbo].[MachineUsageByState]

AS
	SELECT 
	COUNT(vm.VirtualMachineId) as MachineCount, 
	vm.VirtualMachineState as MachineState,
	vm.MachineType as MachineType,
	vm.BlueprintType as BlueprintType
	FROM VirtualMachine vm
	WHERE vm.IsManaged = 1 AND vm.VirtualMachineState IS NOT NULL
	GROUP BY vm.VirtualMachineState, vm.MachineType, vm.BlueprintType
	UNION
	SELECT 
	COUNT(vmh.VirtualMachineId) as MachineCount, 
	'Disposed' as MachineState,
	vmh.MachineType as MachineType,
	vmh.BlueprintType as BlueprintType
	FROM VirtualMachineHistory vmh
	WHERE vmh.VMDeleteDate > DATEADD(DAY, -1, GETDATE()) AND vmh.VMDeleteDate < DATEADD(DAY, 1, GETDATE())
	GROUP BY vmh.MachineType, vmh.BlueprintType
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostDiscovery]'))
DROP VIEW [dbo].[HostDiscovery]
GO
CREATE VIEW [dbo].[HostDiscovery]

AS
	select h.HostID
	,(select COUNT(*) from AdminGroupToHost eg where eg.HostID = h.HostID) [EGs]
	,(select COUNT(*) from HostReservation hr where hr.HostID = h.HostID) [Reservations]
	,(select COUNT(*) from VirtualMachine vm where vm.HostID = h.HostID and vm.IsTemplate = 0 and (vm.IsManaged = 1 or vm.IsMissing = 0)) [Machines]
	,(select COUNT(*) from VirtualMachine vm where vm.HostID = h.HostID and vm.IsTemplate = 0 and vm.IsManaged = 0 and vm.IsMissing = 0) [Unmanaged]
	from Host h
	where h.MachineType = 0 and h.ClusterHostID is null
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostReservationToStorageStats]'))
DROP VIEW [dbo].[HostReservationToStorageStats]
GO
CREATE VIEW [dbo].[HostReservationToStorageStats]
AS

SELECT	hrs.HostReservationToStorageID
	,	hrs.HostReservationID
	,	hrs.HostToStorageID
	,	ISNULL(cap.MachinesTotal, 0)		AS MachinesTotal
	,	ISNULL(SUM(cap.TotalStorage), 0)	AS StorageAllocated
FROM	HostReservationToStorage hrs
LEFT OUTER JOIN
(
	SELECT	vmdh.HostToStorageID
		,	vm.HostReservationID
		,	SUM(vmdh.Capacity) AS TotalStorage
		,	COUNT(DISTINCT vm.VirtualMachineID) AS MachinesTotal
	FROM	VMDiskHardware	vmdh
	JOIN	VirtualMachine	vm on vmdh.VirtualMachineID = vm.VirtualMachineID
	GROUP BY vmdh.HostToStorageID
		,	vm.HostReservationID
) cap								ON hrs.HostReservationID = cap.HostReservationID
									AND hrs.HostToStorageID = cap.HostToStorageID
GROUP BY hrs.HostReservationToStorageID
	,	hrs.HostReservationID
	,	hrs.HostToStorageID
	,	ISNULL(cap.MachinesTotal, 0)
GO

----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[HostReservationStats]'))
DROP VIEW [dbo].[HostReservationStats]
GO
CREATE VIEW [dbo].[HostReservationStats]
AS
	select hr.HostReservationID
	,COUNT(vm.VirtualMachineID) [MachinesTotal]
	,ISNULL(SUM(CASE WHEN vm.IsManaged = 1 and (hr.MachineType = 1 or vm.IsRunning = 1) THEN 1 ELSE 0 END), 0) [MachinesAllocated]
	,ISNULL(SUM(CASE WHEN hr.MachineType != 1 and vm.IsManaged = 1 and vm.IsRunning = 1 THEN vm.VMTotalMemoryMB WHEN hr.MachineType = 1 and vm.IsManaged = 1 THEN pm.MemoryInMB ELSE 0 END), 0) [MemoryAllocated]
	,ISNULL(SUM(CASE WHEN hr.MachineType != 1 and vm.IsManaged = 1  THEN vm.VMTotalStorageGB ELSE 0 END), 0) [StorageAllocated]
	,ISNULL(SUM(CASE WHEN hr.MachineType = 0 and vm.IsManaged = 1  THEN vm.VMUsedStorageGB ELSE 0 END), 0) [StorageUsed]
	,ISNULL(SUM(CASE WHEN hr.MachineType = 0  and vm.IsManaged = 1 THEN vm.VMTotalStorageGB - vm.VMEstimatedUsedSpace ELSE 0 END), 0) [StorageSaved]
	from HostReservation hr
	left outer join VirtualMachine vm on vm.HostReservationID = hr.HostReservationID and vm.MachineType = hr.MachineType
	left outer join PhysicalMachines pm on pm.PhysicalMachineID = vm.PhysicalMachineID
	group by hr.HostReservationID
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[StorageCostByMachineView]'))
DROP VIEW [dbo].[StorageCostByMachineView]

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE VIEW [dbo].[StorageCostByMachineView]
AS
	-- calculate storage cost by machine id
	SELECT	vmStorageAll.VirtualMachineID,
			SUM(COALESCE(scp.DiskCost, cp.DiskCost, 0) * COALESCE(vdhAll.Capacity, vmStorageAll.VMTotalStorageGB, 0))	AS StorageCost
	FROM
	(
		SELECT * FROM VirtualMachine
		UNION ALL
		SELECT * FROM VirtualMachineHistory
	) vmStorageAll
	LEFT OUTER JOIN Host h				ON h.HostID = vmStorageAll.HostID 
	LEFT OUTER JOIN CostProfile cp		ON cp.CostProfileID = h.CostProfileID 
	LEFT OUTER JOIN 
	(
		SELECT * FROM VMDiskHardware
		UNION ALL
		SELECT * FROM VMDiskHardwareHistory
	)	vdhAll								on vdhAll.VirtualMachineID = vmStorageAll.VirtualMachineID
	LEFT OUTER JOIN HostToStorage hs		ON hs.HostToStorageID = vdhAll.HostToStorageID 
	LEFT OUTER JOIN StorageCostProfiles scp	ON scp.Id = hs.StorageCostProfileId
	GROUP BY vmStorageAll.VirtualMachineID, vmStorageAll.MachineType
	HAVING vmStorageAll.MachineType = 0
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[BaseMachineCostView]'))
DROP VIEW [dbo].[BaseMachineCostView]
GO
CREATE VIEW [dbo].[BaseMachineCostView]
AS
SELECT	vmAll.VirtualMachineID, 
		vmAll.MachineType, 
		vmAll.VirtualMachineName,
		pg.GroupName, 
		hr.HostReservationName, 
		u.UserName, 
		vmt.VirtualMachineTemplateName, 
		vmAll.VMCreationDate, 
		vmAll.VMDeleteDate, 
		vmAll.[Owner], 
		pg.GroupID, 
		cpus.CPUs,
		memory.Memory,
		storage.Storage,
		blueprintcost.BlueprintCost,
		cputotalcost.CPUCost,
		memorytotalcost.MemoryCost,
		storagetotalcost.StorageCost,
		blueprintcost.BlueprintCost 
			+ ISNULL(cputotalcost.CPUCost, 0)
			+ ISNULL(memorytotalcost.MemoryCost, 0)
			+ ISNULL(storagetotalcost.StorageCost, 0) AS TotalCost
FROM
(
	SELECT * FROM VirtualMachine
	UNION ALL
	SELECT * FROM VirtualMachineHistory
) vmAll
LEFT OUTER JOIN Users u					ON u.UserID = vmAll.[Owner] 
LEFT OUTER JOIN Host h					ON h.HostID = vmAll.HostID 
LEFT OUTER JOIN CostProfile cp			ON cp.CostProfileID = h.CostProfileID 
INNER JOIN HostReservation hr			ON hr.HostReservationID = vmAll.HostReservationID 
INNER JOIN ProvisioningGroup pg			ON pg.GroupID = hr.GroupID 
INNER JOIN VirtualMachineTemplate vmt   ON vmt.VirtualMachineTemplateID = vmAll.VirtualMachineTemplateID 
LEFT OUTER JOIN PhysicalMachines pm     ON pm.PhysicalMachineID = vmAll.PhysicalMachineID 
LEFT OUTER JOIN CostProfile cpp			ON cpp.CostProfileID = pm.CostProfileID 
LEFT OUTER JOIN StorageCostByMachineView storagetotalcost ON vmAll.VirtualMachineID = storagetotalcost.VirtualMachineID
-- calculated fields
CROSS APPLY (SELECT CASE WHEN vmall.MachineType != 1 THEN ISNULL(vmall.VMCPUs, 0) ELSE pm.ProcessorCount END) AS cpus(CPUs)
CROSS APPLY (SELECT CASE WHEN vmall.MachineType != 1 THEN ISNULL(vmAll.VMTotalMemoryMB, 0) ELSE pm.MemoryInMB END) AS memory(Memory)
CROSS APPLY (SELECT CASE WHEN vmall.MachineType != 1 THEN ISNULL(vmAll.VMTotalStorageGB, 0) ELSE NULL END) AS storage(Storage)
CROSS APPLY (SELECT ISNULL(vmt.Cost, 0)) AS blueprintcost(BlueprintCost)
CROSS APPLY (
	SELECT 
		CASE 
			WHEN vmall.MachineType = 0 THEN ISNULL(cp.CpuCost, 0) 
			WHEN vmall.MachineType = 1 THEN ISNULL(cpp.CpuCost, 0) 
		ELSE NULL 
	END) AS cpucost(CPUCost)
CROSS APPLY (
	SELECT 
		CASE 
			WHEN vmall.MachineType = 0 THEN ISNULL(cp.MemoryCost, 0) 
			WHEN vmall.MachineType = 1 THEN ISNULL(cpp.MemoryCost, 0) 
		ELSE NULL 
	END) AS memorycost(MemoryCost)
CROSS APPLY (SELECT cpus.CPUs * cpucost.CPUCost) AS cputotalcost(CPUCost)
CROSS APPLY (SELECT dbo.Divideasdecimal(memory.Memory, 1024) * memorycost.MemoryCost) AS memorytotalcost(MemoryCost)
WHERE vmAll.IsManaged = 1
GO
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MachineCostView]'))
DROP VIEW [dbo].[MachineCostView]
GO
CREATE VIEW [dbo].[MachineCostView]
AS
SELECT
	bmcv.VirtualMachineID as VirtualMachineID,
	bmcv.TotalCost as DailyCost
FROM	BaseMachineCostView bmcv
WHERE	bmcv.MachineType != 3
UNION ALL
SELECT  vm.VirtualMachineID,
		s.DailyCost
FROM (SELECT
		ISNULL(mm.AppServiceId, bmcv.VirtualMachineId) As VirtualMachineID,
		SUM(bmcv.TotalCost) as DailyCost
		FROM BaseMachineCostView bmcv
			LEFT OUTER JOIN AppServiceComponents mm ON mm.VirtualMachineId = bmcv.VirtualMachineID
		WHERE AppServiceID IS NOT NULL OR bmcv.MachineType = 3
		GROUP BY ISNULL(mm.AppServiceId, bmcv.VirtualMachineId)) s
INNER JOIN VirtualMachine vm ON vm.VirtualMachineID = s.VirtualMachineID
WHERE vm.MachineType = 3
GO