/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.messaging.jms;

import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.util.SystemCommand;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.security.SecurityContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PassthroughAuthenticationPlugin
implements BrokerPlugin {
    private static final Log log = LogFactory.getLog(PassthroughAuthenticationPlugin.class);

    @Override
    public Broker installPlugin(Broker parent) {
        PassthroughAuthenticationBroker broker = new PassthroughAuthenticationBroker(parent);
        return broker;
    }

    private class PassthroughAuthenticationBroker
    extends BrokerFilter {
        private final Set<String> groups;
        private final CopyOnWriteArrayList<SecurityContext> securityContexts;

        public PassthroughAuthenticationBroker(Broker next) {
            super(next);
            this.groups = new HashSet<String>();
            this.securityContexts = new CopyOnWriteArrayList();
            this.groups.add("users");
        }

        @Override
        public void addConnection(ConnectionContext context, ConnectionInfo info) throws Exception {
            if (context.getConnector().getBrokerInfo().getBrokerURL().startsWith("vm://")) {
                return;
            }
            SecurityContext s = context.getSecurityContext();
            String username = info.getUserName();
            String password = info.getPassword();
            if (s == null) {
                if (username == null || password == null) {
                    throw new SecurityException("User name or password is invalid.");
                }
                this.authenticate(username, password);
                s = new SecurityContext(info.getUserName()){

                    @Override
                    public Set<?> getPrincipals() {
                        return PassthroughAuthenticationBroker.this.groups;
                    }
                };
                context.setSecurityContext(s);
                this.securityContexts.add(s);
            }
            try {
                super.addConnection(context, info);
                if (log.isInfoEnabled()) {
                    log.info("Add JMS connection with username : " + username);
                }
            }
            catch (Exception e) {
                this.securityContexts.remove(s);
                context.setSecurityContext(null);
                throw e;
            }
        }

        @Override
        public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Exception {
            super.removeConnection(context, info, error);
            if (this.securityContexts.remove(context.getSecurityContext())) {
                context.setSecurityContext(null);
            }
        }

        private void authenticate(String user, String password) throws SecurityException {
            String passwordHash = this.hashPassword(user, password);
            StringReader stdin = new StringReader(passwordHash + "\n");
            StringWriter stdout = new StringWriter();
            StringWriter stderr = new StringWriter();
            String command = "/usr/sbin/checkhash " + user;
            try {
                if (SystemCommand.execute((Reader)stdin, (Writer)stdout, (Writer)stderr, SvaConstants.PLATFORM_COMMAND_TIMEOUT, command) != 0) {
                    log.warn("Authentication failed: " + stderr);
                    throw new SecurityException("User name or password is invalid.");
                }
            }
            catch (Exception e) {
                String msg = "Could not authenticate user: " + e.getMessage();
                log.error(msg);
                throw new SecurityException(msg);
            }
        }

        private String hashPassword(String user, String password) {
            StringReader stdin = new StringReader(password + "\n");
            StringWriter stdout = new StringWriter();
            StringWriter stderr = new StringWriter();
            String command = "/usr/sbin/hashpass " + user;
            try {
                if (SystemCommand.execute((Reader)stdin, (Writer)stdout, (Writer)stderr, SvaConstants.PLATFORM_COMMAND_TIMEOUT, command) != 0) {
                    log.warn("Could not hash user password: " + stderr);
                    return null;
                }
            }
            catch (Exception e) {
                log.error("Could not hash user password", e);
                return null;
            }
            return stdout.toString().trim();
        }
    }
}

