/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.VMPendingMessageCursor;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.thread.TaskRunnerFactory;

public class TempQueue
extends Queue {
    private final ActiveMQTempDestination tempDest;

    public TempQueue(BrokerService brokerService, ActiveMQDestination destination, MessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Exception {
        super(brokerService, destination, store, parentStats, taskFactory);
        this.tempDest = (ActiveMQTempDestination)destination;
    }

    public void initialize() throws Exception {
        this.messages = new VMPendingMessageCursor();
        this.systemUsage = this.brokerService.getSystemUsage();
        this.memoryUsage.setParent(this.systemUsage.getMemoryUsage());
        this.taskRunner = this.taskFactory.createTaskRunner(this, "TempQueue:  " + this.destination.getPhysicalName());
    }

    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        if (!(context.isFaultTolerant() || context.isNetworkConnection() || this.tempDest.getConnectionId().equals(sub.getConsumerInfo().getConsumerId().getConnectionId()))) {
            this.tempDest.setConnectionId(sub.getConsumerInfo().getConsumerId().getConnectionId());
            LOG.debug(" changed ownership of " + this + " to " + this.tempDest.getConnectionId());
        }
        super.addSubscription(context, sub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xwakeup() {
        boolean result = false;
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            result = !this.messages.isEmpty();
        }
        if (result) {
            try {
                this.pageInMessages(false);
            }
            catch (Throwable e) {
                LOG.error("Failed to page in more queue messages ", e);
            }
        }
        if (!this.messagesWaitingForSpace.isEmpty() || !this.isRecoveryDispatchEmpty()) {
            try {
                this.taskRunner.wakeup();
            }
            catch (InterruptedException e) {
                LOG.warn("Task Runner failed to wakeup ", e);
            }
        }
    }
}

