/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jpa;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.ReferenceStore;
import org.apache.activemq.store.jpa.JPAPersistenceAdapter;
import org.apache.activemq.store.jpa.model.StoredMessageReference;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class JPAReferenceStore
implements ReferenceStore {
    protected final JPAPersistenceAdapter adapter;
    protected final WireFormat wireFormat;
    protected final ActiveMQDestination destination;
    protected final String destinationName;
    protected AtomicLong lastMessageId = new AtomicLong(-1L);
    protected final Lock lock = new ReentrantLock();

    public JPAReferenceStore(JPAPersistenceAdapter adapter, ActiveMQDestination destination) {
        this.adapter = adapter;
        this.destination = destination;
        this.destinationName = destination.getQualifiedName();
        this.wireFormat = this.adapter.getWireFormat();
    }

    public Lock getStoreLock() {
        return this.lock;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void addMessage(ConnectionContext context, Message message) throws IOException {
        throw new RuntimeException("Use addMessageReference instead");
    }

    public Message getMessage(MessageId identity) throws IOException {
        throw new RuntimeException("Use addMessageReference instead");
    }

    public void addMessageReference(ConnectionContext context, MessageId messageId, ReferenceStore.ReferenceData data) throws IOException {
        EntityManager manager = this.adapter.beginEntityManager(context);
        try {
            StoredMessageReference sm = new StoredMessageReference();
            sm.setDestination(this.destinationName);
            sm.setId(messageId.getBrokerSequenceId());
            sm.setMessageId(messageId.toString());
            sm.setExiration(data.getExpiration());
            sm.setFileId(data.getFileId());
            sm.setOffset(data.getOffset());
            manager.persist((Object)sm);
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(context, manager);
            throw IOExceptionSupport.create(e);
        }
        this.adapter.commitEntityManager(context, manager);
    }

    public ReferenceStore.ReferenceData getMessageReference(MessageId identity) throws IOException {
        ReferenceStore.ReferenceData rc = null;
        EntityManager manager = this.adapter.beginEntityManager(null);
        try {
            StoredMessageReference message = null;
            if (identity.getBrokerSequenceId() != 0L) {
                message = (StoredMessageReference)manager.find(StoredMessageReference.class, (Object)identity.getBrokerSequenceId());
            } else {
                Query query = manager.createQuery("select m from StoredMessageReference m where m.messageId=?1");
                query.setParameter(1, (Object)identity.toString());
                message = (StoredMessageReference)query.getSingleResult();
            }
            if (message != null) {
                rc = new ReferenceStore.ReferenceData();
                rc.setExpiration(message.getExiration());
                rc.setFileId(message.getFileId());
                rc.setOffset(message.getOffset());
            }
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create(e);
        }
        this.adapter.commitEntityManager(null, manager);
        return rc;
    }

    public int getMessageCount() throws IOException {
        Long rc;
        EntityManager manager = this.adapter.beginEntityManager(null);
        try {
            Query query = manager.createQuery("select count(m) from StoredMessageReference m");
            rc = (Long)query.getSingleResult();
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create(e);
        }
        this.adapter.commitEntityManager(null, manager);
        return rc.intValue();
    }

    public void recover(MessageRecoveryListener container) throws Exception {
        EntityManager manager = this.adapter.beginEntityManager(null);
        try {
            Query query = manager.createQuery("select m from StoredMessageReference m where m.destination=?1 order by m.id asc");
            query.setParameter(1, (Object)this.destinationName);
            for (StoredMessageReference m : query.getResultList()) {
                MessageId id = new MessageId(m.getMessageId());
                id.setBrokerSequenceId(m.getId());
                container.recoverMessageReference(id);
            }
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create(e);
        }
        this.adapter.commitEntityManager(null, manager);
    }

    public void recoverNextMessages(int maxReturned, MessageRecoveryListener listener) throws Exception {
        EntityManager manager = this.adapter.beginEntityManager(null);
        try {
            Query query = manager.createQuery("select m from StoredMessageReference m where m.destination=?1 and m.id>?2 order by m.id asc");
            query.setParameter(1, (Object)this.destinationName);
            query.setParameter(2, (Object)this.lastMessageId.get());
            query.setMaxResults(maxReturned);
            int count = 0;
            for (StoredMessageReference m : query.getResultList()) {
                MessageId id = new MessageId(m.getMessageId());
                id.setBrokerSequenceId(m.getId());
                listener.recoverMessageReference(id);
                this.lastMessageId.set(m.getId());
                if (++count < maxReturned) continue;
                return;
            }
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(null, manager);
            throw IOExceptionSupport.create(e);
        }
        this.adapter.commitEntityManager(null, manager);
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        EntityManager manager = this.adapter.beginEntityManager(context);
        try {
            Query query = manager.createQuery("delete from StoredMessageReference m where m.destination=?1");
            query.setParameter(1, (Object)this.destinationName);
            query.executeUpdate();
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(context, manager);
            throw IOExceptionSupport.create(e);
        }
        this.adapter.commitEntityManager(context, manager);
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        EntityManager manager = this.adapter.beginEntityManager(context);
        try {
            Query query = manager.createQuery("delete from StoredMessageReference m where m.id=?1");
            query.setParameter(1, (Object)ack.getLastMessageId().getBrokerSequenceId());
            query.executeUpdate();
        }
        catch (Throwable e) {
            this.adapter.rollbackEntityManager(context, manager);
            throw IOExceptionSupport.create(e);
        }
        this.adapter.commitEntityManager(context, manager);
    }

    public void resetBatching() {
        this.lastMessageId.set(-1L);
    }

    public void setMemoryUsage(MemoryUsage memoeyUSage) {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void setBatch(MessageId startAfter) {
    }

    public boolean supportsExternalBatchControl() {
        return false;
    }
}

