/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.context;

import java.io.Serializable;
import java.util.Map;
import org.apache.axis2.context.AbstractContext;
import org.apache.axis2.context.PropertyDifference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyUpdater
implements Serializable {
    private static final Log log = LogFactory.getLog(PropertyUpdater.class);
    private Map properties;

    public void updateProperties(AbstractContext abstractContext) {
        if (log.isDebugEnabled()) {
            log.debug("Updating props in " + abstractContext);
        }
        if (abstractContext != null) {
            for (String key : this.properties.keySet()) {
                PropertyDifference propDiff = (PropertyDifference)this.properties.get(key);
                if (propDiff.isRemoved()) {
                    abstractContext.removePropertyNonReplicable(key);
                    continue;
                }
                abstractContext.setNonReplicableProperty(key, propDiff.getValue());
                if (!log.isDebugEnabled()) continue;
                log.debug("Added prop=" + key + ", value=" + propDiff.getValue() + " to context " + abstractContext);
            }
        }
    }

    public void addContextProperty(PropertyDifference diff) {
        this.properties.put(diff.getKey(), diff);
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public Map getProperties() {
        return this.properties;
    }
}

