/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.clustering.ClusterManager;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.context.ContextClusteringCommand;
import org.apache.axis2.clustering.context.ContextClusteringCommandFactory;
import org.apache.axis2.clustering.context.ContextManager;
import org.apache.axis2.clustering.control.ControlCommand;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;

public class GetStateCommand
extends ControlCommand {
    private ContextClusteringCommand[] commands;

    public void execute(ConfigurationContext configCtx) throws ClusteringFault {
        ClusterManager clusterManager = configCtx.getAxisConfiguration().getClusterManager();
        if (clusterManager == null) {
            return;
        }
        ContextManager contextManager = clusterManager.getContextManager();
        if (contextManager != null) {
            String[] sgCtxIDs;
            Map excludedPropPatterns = contextManager.getReplicationExcludePatterns();
            ArrayList<ContextClusteringCommand> cmdList = new ArrayList<ContextClusteringCommand>();
            for (String sgCtxID : sgCtxIDs = configCtx.getServiceGroupContextIDs()) {
                ServiceGroupContext sgCtx = configCtx.getServiceGroupContext(sgCtxID);
                ContextClusteringCommand updateServiceGroupCtxCmd = ContextClusteringCommandFactory.getUpdateCommand(sgCtx, excludedPropPatterns, true);
                if (updateServiceGroupCtxCmd != null) {
                    cmdList.add(updateServiceGroupCtxCmd);
                }
                if (sgCtx.getServiceContexts() == null) continue;
                Iterator<ServiceContext> iter2 = sgCtx.getServiceContexts();
                while (iter2.hasNext()) {
                    ServiceContext serviceCtx = iter2.next();
                    ContextClusteringCommand updateServiceCtxCmd = ContextClusteringCommandFactory.getUpdateCommand(serviceCtx, excludedPropPatterns, true);
                    if (updateServiceCtxCmd == null) continue;
                    cmdList.add(updateServiceCtxCmd);
                }
            }
            ContextClusteringCommand updateCmd = ContextClusteringCommandFactory.getUpdateCommand(configCtx, excludedPropPatterns, true);
            if (updateCmd != null) {
                cmdList.add(updateCmd);
            }
            if (!cmdList.isEmpty()) {
                this.commands = cmdList.toArray(new ContextClusteringCommand[cmdList.size()]);
            }
        }
    }

    public ContextClusteringCommand[] getCommands() {
        return this.commands;
    }

    public String toString() {
        return "GetStateCommand";
    }
}

