/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.factory.XMLStringBlockFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.utility.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPHeadersAdapter
implements Map<QName, List<String>> {
    private static final Log log = LogFactory.getLog(SOAPHeadersAdapter.class);
    private MessageContext mc;
    private boolean isOutbound;
    private String property;

    public static void install(MessageContext mc) {
        String property;
        Object map;
        Message m = mc.getMessage();
        if (m == null) {
            return;
        }
        boolean isOutbound = mc.isOutbound();
        if (log.isTraceEnabled()) {
            log.trace("Installing SOAPHeadersAdapter: " + JavaUtils.callStackToString());
        }
        if ((map = mc.getProperty(property = isOutbound ? "jaxws.binding.soap.headers.outbound" : "jaxws.binding.soap.headers.inbound")) instanceof SOAPHeadersAdapter) {
            if (log.isDebugEnabled()) {
                log.debug("A SOAPHeadersAdapter is already installed.  Reusing the existing one.");
            }
            return;
        }
        SOAPHeadersAdapter sha = new SOAPHeadersAdapter(mc, isOutbound);
        if (map != null) {
            sha.putAll((Map)map);
        }
        mc.setProperty(property, sha);
    }

    private SOAPHeadersAdapter(MessageContext mc, boolean isOutbound) {
        this.mc = mc;
        this.isOutbound = isOutbound;
        String string = this.property = isOutbound ? "jaxws.binding.soap.headers.outbound" : "jaxws.binding.soap.headers.inbound";
        if (log.isDebugEnabled()) {
            log.debug("Init SOAPHeadersAdapter for " + this.property);
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        Set<QName> keys = this.keySet();
        return keys.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Set<QName> keys = this.keySet();
        for (QName key : keys) {
            Object tryValue = this.get(key);
            if (tryValue != value && !value.equals(tryValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<QName, List<String>>> entrySet() {
        HashMap<QName, List<String>> tempMap = new HashMap<QName, List<String>>();
        tempMap.putAll(this);
        return tempMap.entrySet();
    }

    @Override
    public List<String> get(Object _key) {
        try {
            if (!this.keySet().contains(_key)) {
                return null;
            }
            QName key = (QName)_key;
            Message m = this.mc.getMessage();
            List<Block> blocks = m.getHeaderBlocks(key.getNamespaceURI(), key.getLocalPart(), null, this.getXMLStringBlockFactory(), null);
            if (blocks == null || blocks.size() == 0) {
                return null;
            }
            ArrayList<String> xmlStrings = new ArrayList<String>();
            for (int i = 0; i < blocks.size(); ++i) {
                Block block = blocks.get(i);
                String value = block == null ? null : (String)block.getBusinessObject(false);
                xmlStrings.add(value);
            }
            return xmlStrings;
        }
        catch (Throwable t) {
            throw ExceptionFactory.makeWebServiceException(t);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.keySet().isEmpty();
    }

    @Override
    public Set<QName> keySet() {
        Message m = this.mc.getMessage();
        return m.getHeaderQNames();
    }

    @Override
    public List<String> put(QName key, List<String> values) {
        Message m = this.mc.getMessage();
        if (log.isDebugEnabled()) {
            log.debug("put(" + key + " , " + values + ")");
        }
        Object old = this.get(key);
        if (values != null) {
            if (old != null) {
                m.removeHeaderBlock(key.getNamespaceURI(), key.getLocalPart());
            }
            for (int i = 0; i < values.size(); ++i) {
                String value = values.get(i);
                Block block = this.getXMLStringBlockFactory().createFrom(value, null, key);
                m.appendHeaderBlock(key.getNamespaceURI(), key.getLocalPart(), block);
            }
        }
        return old;
    }

    @Override
    public void putAll(Map<? extends QName, ? extends List<String>> t) {
        for (Map.Entry<? extends QName, ? extends List<String>> entry : t.entrySet()) {
            QName key = entry.getKey();
            List<String> value = entry.getValue();
            this.put(key, value);
        }
    }

    @Override
    public List<String> remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Collection<List<String>> values() {
        HashMap<QName, List<String>> tempMap = new HashMap<QName, List<String>>();
        tempMap.putAll(this);
        return tempMap.values();
    }

    private XMLStringBlockFactory getXMLStringBlockFactory() {
        return (XMLStringBlockFactory)FactoryRegistry.getFactory(XMLStringBlockFactory.class);
    }
}

