/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.impl.alt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.jws.WebParam;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.marshaller.MethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.Element;
import org.apache.axis2.jaxws.marshaller.impl.alt.MethodMarshallerUtils;
import org.apache.axis2.jaxws.marshaller.impl.alt.PDElement;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Message;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.databinding.JAXBBlockContext;
import org.apache.axis2.jaxws.message.factory.JAXBBlockFactory;
import org.apache.axis2.jaxws.message.factory.MessageFactory;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.utility.ConvertUtils;
import org.apache.axis2.jaxws.wrapper.impl.JAXBWrapperToolImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DocLitWrappedMethodMarshaller
implements MethodMarshaller {
    private static Log log = LogFactory.getLog(DocLitWrappedMethodMarshaller.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object demarshalResponse(Message message, Object[] signatureArgs, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            String packagesKey = marshalDesc.getPackagesKey();
            MethodMarshallerUtils.registerUnmarshalInfo(message.getMessageContext(), packages, packagesKey);
            Object returnValue = null;
            Class returnType = operationDesc.getResultActualType();
            boolean isChildReturn = !operationDesc.isJAXWSAsyncClientMethod() && operationDesc.getResultPartName() != null;
            boolean isNoReturn = returnType == Void.TYPE;
            JAXBBlockContext blockContext = new JAXBBlockContext(packages, packagesKey);
            blockContext.setWebServiceNamespace(ed.getTargetNamespace());
            JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
            Block block = message.getBodyBlock(blockContext, factory);
            Object wrapperObject = block.getBusinessObject(true);
            if (wrapperObject instanceof JAXBElement) {
                wrapperObject = ((JAXBElement)wrapperObject).getValue();
            }
            JAXBWrapperToolImpl wrapperTool = new JAXBWrapperToolImpl();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<ParameterDescription> pdList = new ArrayList<ParameterDescription>();
            for (int i = 0; i < pds.length; ++i) {
                ParameterDescription pd = pds[i];
                if (pd.getMode() != WebParam.Mode.OUT && pd.getMode() != WebParam.Mode.INOUT) continue;
                names.add(pd.getParameterName());
                pdList.add(pd);
            }
            if (isChildReturn && !isNoReturn) {
                names.add(operationDesc.getResultPartName());
            }
            Object[] objects = wrapperTool.unWrap(wrapperObject, names, marshalDesc.getPropertyDescriptorMap(wrapperObject.getClass()));
            ArrayList<PDElement> pvList = new ArrayList<PDElement>();
            for (int i = 0; i < pdList.size(); ++i) {
                ParameterDescription pd = (ParameterDescription)pdList.get(i);
                Object value = objects[i];
                Element element = null;
                QName qName = new QName(pd.getTargetNamespace(), pd.getPartName());
                element = !marshalDesc.getAnnotationDesc(pd.getParameterActualType()).hasXmlRootElement() ? new Element(value, qName, pd.getParameterActualType()) : new Element(value, qName);
                pvList.add(new PDElement(pd, element, null));
            }
            MethodMarshallerUtils.updateResponseSignatureArgs(pds, pvList, signatureArgs);
            if (isNoReturn) {
                return null;
            }
            if (!isChildReturn) return wrapperObject;
            returnValue = objects[objects.length - 1];
            if (ConvertUtils.isConvertable(returnValue, returnType)) {
                return ConvertUtils.convert(returnValue, returnType);
            }
            String objectClass = returnValue == null ? "null" : returnValue.getClass().getName();
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("convertProblem", objectClass, returnType.getName()));
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public Object[] demarshalRequest(Message message, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        try {
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
            TreeSet<String> packages = marshalDesc.getPackages();
            String packagesKey = marshalDesc.getPackagesKey();
            MethodMarshallerUtils.registerUnmarshalInfo(message.getMessageContext(), packages, packagesKey);
            JAXBBlockContext blockContext = new JAXBBlockContext(packages, packagesKey);
            blockContext.setWebServiceNamespace(ed.getTargetNamespace());
            JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
            Block block = message.getBodyBlock(blockContext, factory);
            Object wrapperObject = block.getBusinessObject(true);
            if (wrapperObject instanceof JAXBElement) {
                wrapperObject = ((JAXBElement)wrapperObject).getValue();
            }
            JAXBWrapperToolImpl wrapperTool = new JAXBWrapperToolImpl();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<ParameterDescription> pdList = new ArrayList<ParameterDescription>();
            for (int i = 0; i < pds.length; ++i) {
                ParameterDescription pd = pds[i];
                if (pd.getMode() != WebParam.Mode.IN && pd.getMode() != WebParam.Mode.INOUT) continue;
                names.add(pd.getParameterName());
                pdList.add(pd);
            }
            Object[] objects = wrapperTool.unWrap(wrapperObject, names, marshalDesc.getPropertyDescriptorMap(wrapperObject.getClass()));
            ArrayList<PDElement> pvList = new ArrayList<PDElement>();
            for (int i = 0; i < pdList.size(); ++i) {
                ParameterDescription pd = (ParameterDescription)pdList.get(i);
                Object value = objects[i];
                Element element = null;
                QName qName = new QName(pd.getTargetNamespace(), pd.getPartName());
                element = !marshalDesc.getAnnotationDesc(pd.getParameterActualType()).hasXmlRootElement() ? new Element(value, qName, pd.getParameterActualType()) : new Element(value, qName);
                pvList.add(new PDElement(pd, element, null));
            }
            Object[] sigArguments = MethodMarshallerUtils.createRequestSignatureArgs(pds, pvList);
            return sigArguments;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public Message marshalResponse(Object returnObject, Object[] signatureArgs, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        TreeSet<String> packages = marshalDesc.getPackages();
        String packagesKey = marshalDesc.getPackagesKey();
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            Class cls;
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MessageFactory mf = marshalDesc.getMessageFactory();
            Message m = mf.create(protocol);
            List<PDElement> pdeList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArgs, false, true, false);
            ArrayList<String> nameList = new ArrayList<String>();
            HashMap<String, Object> objectList = new HashMap<String, Object>();
            HashMap<String, Class> declaredClassMap = new HashMap<String, Class>();
            for (PDElement pde : pdeList) {
                String name = pde.getParam().getParameterName();
                Object value = pde.getElement().getTypeValue();
                Class dclClass = pde.getParam().getParameterActualType();
                nameList.add(name);
                objectList.put(name, value);
                declaredClassMap.put(name, dclClass);
            }
            Class returnType = operationDesc.getResultActualType();
            if (returnType != Void.TYPE) {
                String name = operationDesc.getResultName();
                nameList.add(name);
                objectList.put(name, returnObject);
                declaredClassMap.put(name, returnType);
            }
            String wrapperName = marshalDesc.getResponseWrapperClassName(operationDesc);
            try {
                cls = MethodMarshallerUtils.loadClass(wrapperName);
            }
            catch (ClassNotFoundException e) {
                cls = MethodMarshallerUtils.loadClass(wrapperName, endpointDesc.getAxisService().getClassLoader());
            }
            JAXBWrapperToolImpl wrapperTool = new JAXBWrapperToolImpl();
            JAXBElement<Object> object = wrapperTool.wrap(cls, nameList, objectList, declaredClassMap, marshalDesc.getPropertyDescriptorMap(cls));
            QName wrapperQName = new QName(operationDesc.getResponseWrapperTargetNamespace(), operationDesc.getResponseWrapperLocalName());
            if (!marshalDesc.getAnnotationDesc(cls).hasXmlRootElement()) {
                object = new JAXBElement<Object>(wrapperQName, cls, object);
            }
            if (operationDesc.hasResponseSwaRefAttachments()) {
                m.setDoingSWA(true);
            }
            JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
            JAXBBlockContext blockContext = new JAXBBlockContext(packages, packagesKey);
            blockContext.setWebServiceNamespace(ed.getTargetNamespace());
            Block block = factory.createFrom(object, (Object)blockContext, wrapperQName);
            m.setBodyBlock(block);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public Message marshalRequest(Object[] signatureArguments, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        Protocol protocol = Protocol.getProtocolForBinding(endpointDesc.getClientBindingID());
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        TreeSet<String> packages = marshalDesc.getPackages();
        String packagesKey = marshalDesc.getPackagesKey();
        try {
            Class cls;
            ParameterDescription[] pds = operationDesc.getParameterDescriptions();
            MessageFactory mf = marshalDesc.getMessageFactory();
            Message m = mf.create(protocol);
            List<PDElement> pvList = MethodMarshallerUtils.getPDElements(marshalDesc, pds, signatureArguments, true, true, false);
            ArrayList<String> nameList = new ArrayList<String>();
            HashMap<String, Object> objectList = new HashMap<String, Object>();
            HashMap<String, Class> declaredClassMap = new HashMap<String, Class>();
            for (PDElement pv : pvList) {
                String name = pv.getParam().getParameterName();
                Object value = pv.getElement().getTypeValue();
                Class dclClass = pv.getParam().getParameterActualType();
                nameList.add(name);
                objectList.put(name, value);
                declaredClassMap.put(name, dclClass);
            }
            String wrapperName = marshalDesc.getRequestWrapperClassName(operationDesc);
            try {
                cls = MethodMarshallerUtils.loadClass(wrapperName);
            }
            catch (ClassNotFoundException e) {
                cls = MethodMarshallerUtils.loadClass(wrapperName, endpointDesc.getAxisService().getClassLoader());
            }
            JAXBWrapperToolImpl wrapperTool = new JAXBWrapperToolImpl();
            JAXBElement<Object> object = wrapperTool.wrap(cls, nameList, objectList, declaredClassMap, marshalDesc.getPropertyDescriptorMap(cls));
            QName wrapperQName = new QName(operationDesc.getRequestWrapperTargetNamespace(), operationDesc.getRequestWrapperLocalName());
            if (!marshalDesc.getAnnotationDesc(cls).hasXmlRootElement()) {
                object = new JAXBElement<Object>(wrapperQName, cls, object);
            }
            if (operationDesc.hasRequestSwaRefAttachments()) {
                m.setDoingSWA(true);
            }
            JAXBBlockFactory factory = (JAXBBlockFactory)FactoryRegistry.getFactory(JAXBBlockFactory.class);
            JAXBBlockContext blockContext = new JAXBBlockContext(packages, packagesKey);
            blockContext.setWebServiceNamespace(ed.getTargetNamespace());
            Block block = factory.createFrom(object, (Object)blockContext, wrapperQName);
            m.setBodyBlock(block);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public Message marshalFaultResponse(Throwable throwable, OperationDescription operationDesc, Protocol protocol) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        TreeSet<String> packages = marshalDesc.getPackages();
        if (protocol == null) {
            protocol = Protocol.getProtocolForBinding(endpointDesc.getBindingType());
        }
        try {
            MessageFactory mf = (MessageFactory)FactoryRegistry.getFactory(MessageFactory.class);
            Message m = mf.create(protocol);
            MethodMarshallerUtils.marshalFaultResponse(throwable, marshalDesc, operationDesc, m);
            return m;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    public Throwable demarshalFaultResponse(Message message, OperationDescription operationDesc) throws WebServiceException {
        EndpointInterfaceDescription ed = operationDesc.getEndpointInterfaceDescription();
        EndpointDescription endpointDesc = ed.getEndpointDescription();
        MarshalServiceRuntimeDescription marshalDesc = MethodMarshallerUtils.getMarshalDesc(endpointDesc);
        try {
            Throwable t = MethodMarshallerUtils.demarshalFaultResponse(operationDesc, marshalDesc, message);
            return t;
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }
}

