/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server;

import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.handler.HandlerChainProcessor;
import org.apache.axis2.jaxws.handler.HandlerInvocationContext;
import org.apache.axis2.jaxws.handler.HandlerInvoker;
import org.apache.axis2.jaxws.handler.factory.HandlerInvokerFactory;
import org.apache.axis2.jaxws.message.util.MessageUtils;
import org.apache.axis2.jaxws.registry.FactoryRegistry;
import org.apache.axis2.jaxws.server.EndpointController;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.InvocationHelper;
import org.apache.axis2.jaxws.server.InvocationListener;
import org.apache.axis2.jaxws.server.InvocationListenerBean;
import org.apache.axis2.util.ThreadContextMigratorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointCallback {
    private static final Log log = LogFactory.getLog(EndpointCallback.class);

    public void handleResponse(EndpointInvocationContext eic) {
        org.apache.axis2.jaxws.core.MessageContext responseMsgCtx = eic.getResponseMessageContext();
        MessageContext axisResponseMsgCtx = responseMsgCtx.getAxisMessageContext();
        try {
            this.invokeOutboundHandlerFlow(eic);
            this.responseReady(eic);
            MessageUtils.putMessageOnMessageContext(responseMsgCtx.getMessage(), axisResponseMsgCtx);
            OperationContext opCtx = axisResponseMsgCtx.getOperationContext();
            opCtx.addMessageContext(axisResponseMsgCtx);
            ThreadContextMigratorUtil.performMigrationToContext("JAXWS-ThreadContextMigrator-List", axisResponseMsgCtx);
            if (log.isDebugEnabled()) {
                log.debug("Sending async response.");
            }
            AxisEngine.send(axisResponseMsgCtx);
            ThreadContextMigratorUtil.performContextCleanup("JAXWS-ThreadContextMigrator-List", axisResponseMsgCtx);
        }
        catch (Throwable t) {
            Throwable faultMessage;
            if (log.isDebugEnabled()) {
                log.debug("An error occurred while attempting to send the async response.");
                t.printStackTrace();
            }
            if ((faultMessage = InvocationHelper.determineMappedException(t, eic)) != null) {
                t = faultMessage;
            }
            eic.getResponseMessageContext().setCausedByException(AxisFault.makeFault(t));
            ThreadContextMigratorUtil.performThreadCleanup("JAXWS-ThreadContextMigrator-List", eic.getRequestMessageContext().getAxisMessageContext());
            this.handleFaultResponse(eic);
        }
    }

    public void handleFaultResponse(EndpointInvocationContext eic) {
        org.apache.axis2.jaxws.core.MessageContext responseMsgCtx = eic.getResponseMessageContext();
        MessageContext axisResponseMsgCtx = responseMsgCtx.getAxisMessageContext();
        try {
            this.responseReady(eic);
            MessageUtils.putMessageOnMessageContext(responseMsgCtx.getMessage(), axisResponseMsgCtx);
            OperationContext opCtx = axisResponseMsgCtx.getOperationContext();
            opCtx.addMessageContext(axisResponseMsgCtx);
            ThreadContextMigratorUtil.performThreadCleanup("JAXWS-ThreadContextMigrator-List", eic.getRequestMessageContext().getAxisMessageContext());
            AxisEngine.sendFault(axisResponseMsgCtx);
        }
        catch (Throwable t) {
            Throwable faultMessage = InvocationHelper.determineMappedException(t, eic);
            if (faultMessage != null) {
                t = faultMessage;
            }
            throw ExceptionFactory.makeWebServiceException(AxisFault.makeFault(t));
        }
    }

    protected void responseReady(EndpointInvocationContext eic) {
        List<InvocationListener> listenerList = eic.getInvocationListeners();
        if (listenerList != null) {
            InvocationListenerBean bean = new InvocationListenerBean(eic, InvocationListenerBean.State.RESPONSE);
            for (InvocationListener listener : listenerList) {
                try {
                    listener.notify(bean);
                }
                catch (Exception e) {
                    throw ExceptionFactory.makeWebServiceException(e);
                }
            }
        }
    }

    protected void invokeOutboundHandlerFlow(EndpointInvocationContext eic) {
        org.apache.axis2.jaxws.core.MessageContext request = eic.getRequestMessageContext();
        org.apache.axis2.jaxws.core.MessageContext response = eic.getResponseMessageContext();
        if (response != null) {
            response.setMEPContext(request.getMEPContext());
            HandlerInvocationContext hiContext = EndpointController.buildHandlerInvocationContext(request, eic.getHandlers(), HandlerChainProcessor.MEP.RESPONSE, false);
            HandlerInvokerFactory hiFactory = (HandlerInvokerFactory)FactoryRegistry.getFactory(HandlerInvokerFactory.class);
            HandlerInvoker handlerInvoker = hiFactory.createHandlerInvoker(response);
            handlerInvoker.invokeOutboundHandlers(hiContext);
        }
    }
}

