/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.utility;

import java.lang.reflect.Method;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.ws.WebServiceException;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.i18n.Messages;

public class SAAJFactory {
    private static final String SOAP11_ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String SOAP12_ENV_NS = "http://www.w3.org/2003/05/soap-envelope";
    public static final String SOAP_1_1_PROTOCOL = "SOAP 1.1 Protocol";
    public static final String SOAP_1_2_PROTOCOL = "SOAP 1.2 Protocol";
    public static final String DYNAMIC_PROTOCOL = "Dynamic Protocol";
    private static Method messageFactoryNewInstanceProtocolMethod = null;
    private static Method soapFactoryNewInstanceProtocolMethod = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SOAPFactory createSOAPFactory(String namespace) throws WebServiceException, SOAPException {
        Method m = SAAJFactory.getSOAPFactoryNewInstanceProtocolMethod();
        SOAPFactory sf = null;
        if (m == null) {
            if (!namespace.equals(SOAP11_ENV_NS)) throw ExceptionFactory.makeWebServiceException(Messages.getMessage("SOAP12WithSAAJ12Err"));
            return SOAPFactory.newInstance();
        }
        String protocol = DYNAMIC_PROTOCOL;
        if (namespace.equals(SOAP11_ENV_NS)) {
            protocol = SOAP_1_1_PROTOCOL;
        } else if (namespace.equals(SOAP12_ENV_NS)) {
            protocol = SOAP_1_2_PROTOCOL;
        }
        try {
            return (SOAPFactory)m.invoke(null, protocol);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageFactory createMessageFactory(String namespace) throws WebServiceException, SOAPException {
        Method m = SAAJFactory.getMessageFactoryNewInstanceProtocolMethod();
        MessageFactory mf = null;
        if (m == null) {
            if (!namespace.equals(SOAP11_ENV_NS)) throw ExceptionFactory.makeWebServiceException(Messages.getMessage("SOAP12WithSAAJ12Err"));
            return MessageFactory.newInstance();
        }
        String protocol = DYNAMIC_PROTOCOL;
        if (namespace.equals(SOAP11_ENV_NS)) {
            protocol = SOAP_1_1_PROTOCOL;
        } else if (namespace.equals(SOAP12_ENV_NS)) {
            protocol = SOAP_1_2_PROTOCOL;
        }
        try {
            return (MessageFactory)m.invoke(null, protocol);
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(e);
        }
    }

    private static Method getMessageFactoryNewInstanceProtocolMethod() {
        if (messageFactoryNewInstanceProtocolMethod == null) {
            try {
                messageFactoryNewInstanceProtocolMethod = MessageFactory.class.getMethod("newInstance", String.class);
            }
            catch (Exception e) {
                messageFactoryNewInstanceProtocolMethod = null;
            }
        }
        return messageFactoryNewInstanceProtocolMethod;
    }

    private static Method getSOAPFactoryNewInstanceProtocolMethod() {
        if (soapFactoryNewInstanceProtocolMethod == null) {
            try {
                soapFactoryNewInstanceProtocolMethod = SOAPFactory.class.getMethod("newInstance", String.class);
            }
            catch (Exception e) {
                soapFactoryNewInstanceProtocolMethod = null;
            }
        }
        return soapFactoryNewInstanceProtocolMethod;
    }
}

