/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.attachments.utils.IOUtils;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLPrettyPrinter {
    private static final Log log = LogFactory.getLog(XMLPrettyPrinter.class);
    private static final String prettyPrintStylesheet = "<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'  xmlns:xalan='http://xml.apache.org/xslt'  exclude-result-prefixes='xalan'>  <xsl:output method='xml' indent='yes' xalan:indent-amount='4'/>  <xsl:strip-space elements='*'/>  <xsl:template match='/'>    <xsl:apply-templates/>  </xsl:template>  <xsl:template match='node() | @*'>        <xsl:copy>          <xsl:apply-templates select='node() | @*'/>        </xsl:copy>  </xsl:template></xsl:stylesheet>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void prettify(final File file) {
        block22: {
            IOException e222;
            byte[] byteArray;
            FileOutputStream outputStream;
            InputStream inputStream;
            block20: {
                inputStream = null;
                outputStream = null;
                byteArray = null;
                byteArray = IOUtils.getStreamAsByteArray(new FileInputStream(file));
                inputStream = new ByteArrayInputStream(byteArray);
                outputStream = new FileOutputStream(file);
                StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(prettyPrintStylesheet.getBytes()));
                StreamSource xmlSource = new StreamSource(inputStream);
                TransformerFactory tf = TransformerFactory.newInstance();
                Templates templates = tf.newTemplates(stylesheetSource);
                Transformer transformer = templates.newTransformer();
                transformer.setErrorListener(new ErrorListener(){

                    public void warning(TransformerException exception) throws TransformerException {
                        log.warn("Exception occurred while trying to pretty print file " + file, exception);
                    }

                    public void error(TransformerException exception) throws TransformerException {
                        log.error("Exception occurred while trying to pretty print file " + file, exception);
                    }

                    public void fatalError(TransformerException exception) throws TransformerException {
                        log.error("Exception occurred while trying to pretty print file " + file, exception);
                    }
                });
                transformer.transform(xmlSource, new StreamResult(outputStream));
                inputStream.close();
                outputStream.close();
                log.debug("Pretty printed file : " + file);
                Object var10_11 = null;
                if (inputStream == null) break block20;
                try {
                    inputStream.close();
                }
                catch (IOException e222) {
                    log.debug(e222.getMessage(), e222);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e222) {
                    log.debug(e222.getMessage(), e222);
                }
            }
            break block22;
            {
                catch (Throwable t) {
                    IOException e222;
                    log.debug("Exception occurred while trying to pretty print file " + file, t);
                    try {
                        if (byteArray != null) {
                            outputStream = new FileOutputStream(file);
                            outputStream.write(byteArray);
                        }
                    }
                    catch (IOException e3) {
                        log.debug(e3.getMessage(), e3);
                    }
                    Object var10_12 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e222) {
                            log.debug(e222.getMessage(), e222);
                        }
                    }
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e222) {
                            log.debug(e222.getMessage(), e222);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var10_13 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e222) {
                        log.debug(e222.getMessage(), e222);
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException e222) {
                        log.debug(e222.getMessage(), e222);
                    }
                }
                throw throwable;
            }
        }
    }

    public static void prettify(OMElement wsdlElement, OutputStream out) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        wsdlElement.serialize(baos);
        StreamSource stylesheetSource = new StreamSource(new ByteArrayInputStream(prettyPrintStylesheet.getBytes()));
        StreamSource xmlSource = new StreamSource(new ByteArrayInputStream(baos.toByteArray()));
        TransformerFactory tf = TransformerFactory.newInstance();
        Templates templates = tf.newTemplates(stylesheetSource);
        Transformer transformer = templates.newTransformer();
        transformer.transform(xmlSource, new StreamResult(out));
    }
}

