/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.pseudosvadomain;

import com.vmware.sva.blc.AbstractBlcEvent;
import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.bld.persistent.AbstractPersistentBusinessLogicComponent;
import com.vmware.sva.common.NetworkInterface;
import com.vmware.sva.common.PingResult;
import com.vmware.sva.common.PseudoSvaClusterMetadata;
import com.vmware.sva.common.PseudoSvaServerInfo;
import com.vmware.sva.common.RmiUtilities;
import com.vmware.sva.common.SerialFields;
import com.vmware.sva.common.SerialMinorVersion;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.util.PseudoSvaUtility;
import com.vmware.sva.domainservice.AbstractManagementRequest;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.domainservice.ManagementPingRequest;
import com.vmware.sva.domainservice.ManagementPingResponse;
import com.vmware.sva.domainservice.requests.GenericAuthenticateRequest;
import com.vmware.sva.domainservice.requests.GenericGetDiagnosticInfoRequest;
import com.vmware.sva.domainservice.requests.GenericGetSvaVersionRequest;
import com.vmware.sva.domainservice.responses.GenericAuthenticateResponse;
import com.vmware.sva.domainservice.responses.GenericGetDiagnosticInfoResponse;
import com.vmware.sva.domainservice.responses.GenericGetSvaVersionResponse;
import com.vmware.sva.pseudosvadomain.PseudoSvaServerInfoRequest;
import com.vmware.sva.pseudosvadomain.PseudoSvaServerInfoResponse;
import com.vmware.sva.pseudosvadomain.events.RebootEvent;
import com.vmware.sva.pseudosvadomain.exceptions.PsvaNotInMaintenanceModeException;
import com.vmware.sva.pseudosvadomain.exceptions.RollbackException;
import com.vmware.sva.pseudosvadomain.requests.DestroyPseudoSvaRequest;
import com.vmware.sva.pseudosvadomain.requests.EnterMaintenanceModeRequest;
import com.vmware.sva.pseudosvadomain.requests.ExitMaintenanceModeRequest;
import com.vmware.sva.pseudosvadomain.responses.DestroyPseudoSvaResponse;
import com.vmware.sva.pseudosvadomain.responses.EnterMaintenanceModeResponse;
import com.vmware.sva.pseudosvadomain.responses.ExitMaintenanceModeResponse;
import com.vmware.sva.services.blcevents.controlevent.BlcRestartEvent;
import com.vmware.sva.services.blcevents.controlevent.BlcStartEvent;
import com.vmware.sva.zkmgmtserver.ZkMgmtServer;
import com.vmware.sva.zkmgmtserver.ZkServerAlreadyRunningException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.UUID;
import java.util.logging.Level;

@SerialMinorVersion(value=2)
public class PseudoSvaDefaultBlc
extends AbstractPersistentBusinessLogicComponent {
    private boolean inMaintenanceMode;
    private boolean shutdownRmi = false;
    private transient boolean isRmiRunning = false;
    private static final String PSEUDOSVA_PING_RESPONSE_MESSAGE = "Ping from PseudoSvaDomain";
    private static final long serialVersionUID = 1L;
    private static final String PATTERN = null;
    private static final int RETRIES = 10;
    private static final int RETRIES_INTERVAL = 5000;
    private static final int REBOOT_DELAY = 1000;

    public PseudoSvaDefaultBlc() {
        super(SvaConstants.DefaultUUID, "PseudoSvaDefaultBlc", null);
    }

    protected void handleEvent(AbstractBlcEvent event) {
        this.log(Level.INFO, "Received event Name " + event.getClass().getName());
        if (event instanceof BlcStartEvent) {
            this.handleBlcStartEvent((BlcStartEvent)event);
        } else if (event instanceof BlcRestartEvent) {
            this.handleBlcRestartEvent((BlcRestartEvent)event);
        } else if (event instanceof ManagementPingRequest) {
            this.handleManagementPingRequest((ManagementPingRequest)event);
        } else if (event instanceof PseudoSvaServerInfoRequest) {
            this.handlePseudoSvaServerInfoRequest((PseudoSvaServerInfoRequest)event);
        } else if (event instanceof GenericGetSvaVersionRequest) {
            this.handleGetSvaVersionRequest((GenericGetSvaVersionRequest)event);
        } else if (event instanceof DestroyPseudoSvaRequest) {
            this.handleDestroyPseudoSvaRequest((DestroyPseudoSvaRequest)event);
        } else if (event instanceof GenericGetDiagnosticInfoRequest) {
            this.handleGetDiagnostic((GenericGetDiagnosticInfoRequest)event);
        } else if (event instanceof GenericAuthenticateRequest) {
            this.handleAuthenticate((GenericAuthenticateRequest)event);
        } else if (event instanceof EnterMaintenanceModeRequest) {
            this.handleEnterMaintenanceModeRequest((EnterMaintenanceModeRequest)event);
        } else if (event instanceof ExitMaintenanceModeRequest) {
            this.handleExitMaintenanceModeRequest((ExitMaintenanceModeRequest)event);
        } else if (event instanceof RebootEvent) {
            this.handleRebootEvent((RebootEvent)event);
        } else {
            String msg = "Received unexpected event " + event.getClass().getName();
            this.log(Level.SEVERE, msg);
            assert (false) : msg;
        }
    }

    private void handleBlcStartEvent(BlcStartEvent event) {
    }

    private void handleAuthenticate(GenericAuthenticateRequest request) {
        Exception exp = null;
        try {
            if (!PseudoSvaUtility.verifyPassword(request.getUser(), request.getPasswordHash())) {
                throw new Exception("Login failed");
            }
        }
        catch (Exception e) {
            exp = e;
        }
        this.asyncServiceRequest(request.getServiceId(), (AbstractServiceRequest)new GenericAuthenticateResponse(this.getId(), (AbstractManagementRequest)request, exp));
    }

    private void handleGetDiagnostic(GenericGetDiagnosticInfoRequest request) {
        IOException exp = null;
        try {
            PseudoSvaUtility.ZipFiles(SvaConstants.PSVALOGBUNDLE_NAME, SvaConstants.LogPath, PATTERN, new String[]{SvaConstants.PSEUDOSVA_VERSIONFILE});
        }
        catch (IOException e) {
            exp = e;
        }
        if (exp == null) {
            this.asyncServiceRequest(request.getServiceId(), (AbstractServiceRequest)new GenericGetDiagnosticInfoResponse(this.getId(), (AbstractManagementRequest)request, SvaConstants.PSVALOGBUNDLE_NAME));
        } else {
            this.asyncServiceRequest(request.getServiceId(), (AbstractServiceRequest)new GenericGetDiagnosticInfoResponse(this.getId(), (AbstractManagementRequest)request, (Exception)exp));
        }
    }

    private void handleEnterMaintenanceModeRequest(EnterMaintenanceModeRequest request) {
        Exception rootException;
        boolean shutdownRmi = request.getShutdownRMI();
        try {
            rootException = this.enterMaintenanceMode(shutdownRmi);
        }
        catch (RollbackException e) {
            this.log(Level.SEVERE, "Rollback error", e);
            this.forceEnterMaintenanceMode(shutdownRmi);
            return;
        }
        EnterMaintenanceModeResponse response = rootException == null ? new EnterMaintenanceModeResponse(this.getId(), request) : new EnterMaintenanceModeResponse(this.getId(), request, rootException);
        this.asyncServiceRequest(request.getServiceId(), (AbstractServiceRequest)response);
    }

    private void handleExitMaintenanceModeRequest(ExitMaintenanceModeRequest request) {
        Exception rootException;
        try {
            rootException = this.exitMaintenanceMode();
        }
        catch (RollbackException e) {
            this.log(Level.SEVERE, "Rollback error", e);
            this.forceExitMaintenanceMode();
            return;
        }
        ExitMaintenanceModeResponse response = rootException == null ? new ExitMaintenanceModeResponse(this.getId(), request) : new ExitMaintenanceModeResponse(this.getId(), request, rootException);
        this.asyncServiceRequest(request.getServiceId(), (AbstractServiceRequest)response);
    }

    private Exception enterMaintenanceMode(boolean shutdownRmi) throws RollbackException {
        if (!this.inMaintenanceMode) {
            this.log(Level.INFO, "Enter maintenance mode with shutdown RMI equal " + shutdownRmi);
            Exception rootException = null;
            try {
                this.stopZooKeeper();
            }
            catch (Exception e) {
                this.log(Level.SEVERE, this.getName() + ": Failed to stop ZooKeeper for maintenance mode.", e);
                rootException = e;
                try {
                    this.startZooKeeper();
                }
                catch (Exception e1) {
                    throw new RollbackException("Unable to start ZooKeeper during the rollback.", e1);
                }
            }
            if (rootException == null && shutdownRmi) {
                try {
                    this.stopRmi();
                }
                catch (Exception e) {
                    this.log(Level.SEVERE, this.getName() + ": Failed to stop RMI for maintenance mode.", e);
                    rootException = e;
                    try {
                        ZkMgmtServer zkMgmtServer = ZkMgmtServer.getLocalZkMgmtServerInstance();
                        this.startRmi(zkMgmtServer);
                    }
                    catch (Exception e1) {
                        throw new RollbackException("Unable to start RMI during the rollback.", e1);
                    }
                    try {
                        this.startZooKeeper();
                    }
                    catch (Exception e1) {
                        throw new RollbackException("Unable to start ZooKeeper during the rollback.", e1);
                    }
                }
            }
            if (rootException == null) {
                this.inMaintenanceMode = true;
                this.shutdownRmi = shutdownRmi;
                return null;
            }
            return rootException;
        }
        this.log(Level.INFO, "Already in maintenance mode.");
        return null;
    }

    private Exception exitMaintenanceMode() throws RollbackException {
        this.log(Level.INFO, "Exit maintenance mode");
        Exception rootException = null;
        if (!this.inMaintenanceMode) {
            this.log(Level.WARNING, this.getName() + ".exitMaintenanceMode(): ExitMaintenanceModeRequest received " + "but VCS is currently not in maintenance mode.");
            rootException = new PsvaNotInMaintenanceModeException(this.getBld().getId());
        }
        if (rootException == null) {
            try {
                this.startZooKeeper();
            }
            catch (Exception e) {
                this.log(Level.SEVERE, this.getName() + ": Failed to start ZooKeeper while exiting maintenance mode.", e);
                rootException = e;
                try {
                    this.stopZooKeeper();
                }
                catch (Exception e1) {
                    throw new RollbackException("Unable to stop ZooKeeper during the rollback.", e1);
                }
            }
        }
        if (rootException == null) {
            try {
                ZkMgmtServer zkMgmtServer = ZkMgmtServer.getLocalZkMgmtServerInstance();
                this.startRmi(zkMgmtServer);
            }
            catch (Exception e) {
                this.log(Level.SEVERE, this.getName() + ": Failed to start RMI while exiting maintenance mode.", e);
                rootException = e;
                try {
                    this.stopRmi();
                }
                catch (Exception e1) {
                    throw new RollbackException("Unable to stop RMI during the rollback.", e1);
                }
                try {
                    this.log(Level.INFO, "Sleeping for 5 seconds to allow ZooKeeper to start the server sockets.");
                    Thread.sleep(5000L);
                    this.stopZooKeeper();
                }
                catch (Exception e1) {
                    throw new RollbackException("Unable to stop ZooKeeper during the rollback.", e1);
                }
            }
        }
        if (rootException == null) {
            this.inMaintenanceMode = false;
            this.shutdownRmi = false;
            return null;
        }
        return rootException;
    }

    private void handleDestroyPseudoSvaRequest(DestroyPseudoSvaRequest request) {
        this.log(Level.INFO, "*** Received dequest to destroy ****");
        try {
            SvaConstants.setProp("pseudosva.destroy", "true");
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Failed to set pseudosva.destroy property", e);
            this.asyncServiceRequest(request.getServiceId(), (AbstractServiceRequest)new DestroyPseudoSvaResponse(this.getId(), request, e));
        }
        this.log(Level.INFO, "Exiting...");
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            this.log(Level.WARNING, "Ingoring exception received while sleeping...", e);
        }
        this.die();
    }

    private void handleBlcRestartEvent(BlcRestartEvent event) {
        if (!PseudoSvaUtility.isMetaDataInitialized()) {
            try {
                PseudoSvaUtility.initializeMetadata();
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Failed to intialize metadata. VSA Manager may not be able to login until metadata is successfully created.");
            }
        }
        assert (!this.shutdownRmi || this.inMaintenanceMode);
        int retriesLeft = 10;
        while (retriesLeft-- > 0) {
            try {
                ZkMgmtServer zkMgmtServer = ZkMgmtServer.createLocalZkMgmtServer();
                zkMgmtServer.startZooKeeperWithCondition();
                if (this.shutdownRmi) break;
                this.startRmi(zkMgmtServer);
                break;
            }
            catch (Exception e) {
                this.log(Level.WARNING, "Unable to start RMI. " + (retriesLeft > 0 ? "Retrying.. " : "Giving up..") + e);
                if (retriesLeft > 0) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException ie) {
                        this.log(Level.WARNING, "Ingoring exception while trying to sleep " + ie);
                    }
                    continue;
                }
                this.forceEnterMaintenanceMode(true);
            }
        }
    }

    private void handleManagementPingRequest(ManagementPingRequest request) {
        this.log(Level.INFO, this.getName() + " received ping event");
        PingResult svaPingResponse = new PingResult(PSEUDOSVA_PING_RESPONSE_MESSAGE, new PingResult("Mock Response from PlatformServices"));
        ManagementPingResponse response = new ManagementPingResponse((AbstractBusinessLogicComponent)this, request, svaPingResponse);
        this.asyncServiceRequest(request.getServiceId(), (AbstractServiceRequest)response);
    }

    private void handlePseudoSvaServerInfoRequest(PseudoSvaServerInfoRequest request) {
        Exception exp = null;
        PseudoSvaServerInfo info = null;
        try {
            info = this.getPseudoSvaServerInfo(request.getPseudoSvaIP());
        }
        catch (Exception e) {
            exp = e;
        }
        if (exp == null) {
            this.asyncServiceRequest(request.getServiceId(), (AbstractServiceRequest)new PseudoSvaServerInfoResponse(this.getId(), (AbstractManagementRequest)request, info));
        } else {
            this.asyncServiceRequest(request.getServiceId(), (AbstractServiceRequest)new PseudoSvaServerInfoResponse(this.getId(), (AbstractManagementRequest)request, exp));
        }
    }

    private void handleRebootEvent(RebootEvent event) {
        this.log(Level.INFO, "Rebooting VCS...");
        this.die();
    }

    private PseudoSvaServerInfo getPseudoSvaServerInfo(String ipAddr) throws Exception {
        String domain = "";
        String hostname = "";
        String[] dnsServers = new String[]{};
        NetworkInterface net = null;
        StringBuilder sb = new StringBuilder();
        try {
            domain = PseudoSvaUtility.getDomainName();
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Failed get domain name", e);
            sb.append(e.getMessage() + "/");
        }
        try {
            dnsServers = PseudoSvaUtility.getDnsServers();
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Failed get DNS servers", e);
            sb.append(e.getMessage() + "/");
        }
        try {
            hostname = PseudoSvaUtility.getHostname(ipAddr);
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Failed get host name", e);
            sb.append(e.getMessage() + "/");
        }
        try {
            net = PseudoSvaUtility.getNetworkInterface(ipAddr);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to get NetworkInterface", e);
            throw e;
        }
        this.log(Level.INFO, "net = " + net.toString());
        return new PseudoSvaServerInfo(this.getBld().getId(), hostname, this.getClusterID(), this.inMaintenanceMode, net, dnsServers, domain, this.isRmiRunning);
    }

    private UUID getClusterID() {
        UUID id = null;
        try {
            PseudoSvaClusterMetadata out = PseudoSvaUtility.getMetaData();
            id = out.getClusterID();
        }
        catch (IOException e) {
            this.log(Level.WARNING, "Failed to read metadata ", e);
        }
        return id;
    }

    private void handleGetSvaVersionRequest(GenericGetSvaVersionRequest request) {
        Exception exp = null;
        String version = null;
        try {
            version = PseudoSvaUtility.getPseudoSvaVersion();
        }
        catch (Exception e) {
            exp = e;
        }
        if (exp == null) {
            this.asyncServiceRequest(request.getServiceId(), (AbstractServiceRequest)new GenericGetSvaVersionResponse(this.getId(), (AbstractManagementRequest)request, version));
        } else {
            this.asyncServiceRequest(request.getServiceId(), (AbstractServiceRequest)new PseudoSvaServerInfoResponse(this.getId(), (AbstractManagementRequest)request, exp));
        }
    }

    private void startZooKeeper() throws Exception {
        try {
            ZkMgmtServer zkmgr = ZkMgmtServer.getLocalZkMgmtServerInstance();
            if (zkmgr.getZkConfiguration() != null) {
                zkmgr.startZooKeeper();
            } else {
                this.log(Level.INFO, "Didn't start ZooKeeper because ZkConfiguration is null.");
            }
        }
        catch (ZkServerAlreadyRunningException zkServerAlreadyRunningException) {
            // empty catch block
        }
    }

    private void stopZooKeeper() throws Exception {
        ZkMgmtServer zkmgr = ZkMgmtServer.getLocalZkMgmtServerInstance();
        if (zkmgr.getZkConfiguration() != null) {
            zkmgr.stopZooKeeper(false);
        } else {
            this.log(Level.INFO, "Didn't stop ZooKeeper because ZkConfiguration is null.");
        }
    }

    private void startRmi(ZkMgmtServer zkMgmtServer) throws Exception {
        if (!this.isRmiRunning) {
            RmiUtilities.createRegistry();
            zkMgmtServer.startRmiService();
            this.isRmiRunning = true;
        } else {
            this.log(Level.INFO, "Tried to start RMI while RMI was already running. That is okey.");
        }
    }

    private void stopRmi() throws Exception {
        if (this.isRmiRunning) {
            RmiUtilities.shutdownRMI();
            this.isRmiRunning = false;
        } else {
            this.log(Level.INFO, "Tried to stop RMI while RMI was not running. That is okey.");
        }
    }

    private void rebootAfterDelay(int delay) {
        this.log(Level.INFO, "Requesting reboot after " + delay + " milliseconds.");
        this.startTimer(delay, (AbstractBlcEvent)new RebootEvent());
    }

    private void forceEnterMaintenanceMode(boolean shutdownRmi) {
        this.log(Level.INFO, this.getName() + ": enterMaintenanceModeWithReboot()");
        this.shutdownRmi = shutdownRmi;
        this.inMaintenanceMode = true;
        this.rebootAfterDelay(1000);
    }

    private void forceExitMaintenanceMode() {
        this.log(Level.INFO, this.getName() + ": exitMaintenanceModeWithReboot()");
        this.shutdownRmi = false;
        this.inMaintenanceMode = false;
        this.rebootAfterDelay(1000);
    }

    private void die() {
        System.exit(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, InvalidClassException {
        SerialFields fields = this.getSerialGeneration().setDefaultFields((Object)this, PseudoSvaDefaultBlc.class, in);
        if (fields != null) {
            switch (fields.getSerialMinorVersion()) {
                case 1: {
                    this.shutdownRmi = false;
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new InvalidClassException("Unknown serial minor version " + fields.getSerialMinorVersion() + " for class " + PseudoSvaDefaultBlc.class.getName());
                }
            }
        }
    }
}

