/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.AbstractSerializable;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Arrays;
import java.util.Date;

public class PingResult
extends AbstractSerializable {
    private static final long serialVersionUID = 1L;
    private final String message;
    private final long timestamp;
    private PingResult[] layers;

    public PingResult(String theMessage, PingResult layerResponse) {
        this(theMessage);
        this.addLayerResponse(layerResponse);
    }

    public PingResult(String theMessage) {
        this.message = theMessage;
        this.timestamp = System.currentTimeMillis();
    }

    public void addLayerResponse(PingResult layerResponse) {
        this.layers = this.layers != null ? Arrays.copyOf(this.layers, this.layers.length + 1) : new PingResult[1];
        this.layers[this.layers.length - 1] = layerResponse;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getTimestamp() {
        return new Date(this.timestamp);
    }

    @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Null return value means no layer responses were received")
    public PingResult[] getLayerResponses() {
        return this.layers != null ? Arrays.copyOf(this.layers, this.layers.length) : null;
    }

    public void setLayerResponses(PingResult[] layers) {
        this.layers = layers != null ? Arrays.copyOf(layers, layers.length) : null;
    }

    public String toString() {
        return "PingResponse:" + this.message + "@" + this.getTimestamp() + ":" + Arrays.toString(this.layers);
    }
}

