/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.common;

import com.vmware.sva.common.SvaConstants;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;

public final class SvaLogConstants {
    private static final HashMap<String, String> DEFAULT_LOG4J_PROP = new HashMap();
    private static Properties log4jProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeLog4jProperties() throws IOException {
        FileReader propFile = null;
        log4jProperties = new Properties();
        try {
            propFile = new FileReader(SvaConstants.LOG4J_FILE_PATH);
            log4jProperties.load(propFile);
            PropertyConfigurator.configureAndWatch((String)SvaConstants.LOG4J_FILE_PATH, (long)15000L);
        }
        catch (IOException e) {
        }
        finally {
            if (propFile != null) {
                try {
                    propFile.close();
                }
                catch (IOException e) {}
            }
        }
        if (log4jProperties.isEmpty()) {
            FileWriter propOut = null;
            try {
                propOut = new FileWriter(SvaConstants.LOG4J_FILE_PATH);
                for (Map.Entry<String, String> entry : DEFAULT_LOG4J_PROP.entrySet()) {
                    log4jProperties.setProperty(entry.getKey(), entry.getValue());
                }
                log4jProperties.store(propOut, null);
                PropertyConfigurator.configureAndWatch((String)SvaConstants.LOG4J_FILE_PATH, (long)15000L);
                propOut.close();
                propOut = null;
            }
            catch (IOException e) {
                PropertyConfigurator.configure((Properties)log4jProperties);
            }
            finally {
                if (propOut != null) {
                    try {
                        propOut.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static String getLog4jRootLogger() {
        if (SvaConstants.getOsName().equals("windows")) {
            return "INFO, ROLLINGFILE";
        }
        return "INFO, CONSOLE";
    }

    public static String getLog4jZKLogger() {
        if (SvaConstants.getOsName().equals("windows")) {
            return "INFO, ZKLOG";
        }
        return "INFO, ZKLOG, CONSOLE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLog4jProperty(String name, String value, Boolean save) throws IOException {
        log4jProperties.setProperty(name, value);
        if (save.booleanValue()) {
            FileWriter propOut = new FileWriter(SvaConstants.LOG4J_FILE_PATH);
            try {
                log4jProperties.store(propOut, null);
            }
            finally {
                propOut.close();
            }
        }
    }

    public static String getLog4jProperty(String name) {
        return log4jProperties.getProperty(name);
    }

    static {
        DEFAULT_LOG4J_PROP.put("log4j.rootLogger", SvaLogConstants.getLog4jRootLogger());
        DEFAULT_LOG4J_PROP.put("log4j.appender.CONSOLE", "org.apache.log4j.ConsoleAppender");
        DEFAULT_LOG4J_PROP.put("log4j.appender.CONSOLE.Threshold", "INFO");
        DEFAULT_LOG4J_PROP.put("log4j.appender.CONSOLE.layout", "org.apache.log4j.PatternLayout");
        DEFAULT_LOG4J_PROP.put("log4j.appender.CONSOLE.layout.ConversionPattern", "%d{yyyy-MM-dd HH:mm:ss.SSS} %p - [%t:%C{1}@%L] - %m%n");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ROLLINGFILE", "org.apache.log4j.RollingFileAppender");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ROLLINGFILE.Threshold", "INFO");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ROLLINGFILE.File", SvaConstants.LogPath + "/sva.log");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ROLLINGFILE.MaxFileSize", "5MB");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ROLLINGFILE.MaxBackupIndex", "1");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ROLLINGFILE.layout", "org.apache.log4j.PatternLayout");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ROLLINGFILE.layout.ConversionPattern", "%d{yyyy-MM-dd HH:mm:ss.SSS} %p - [%t:%C{1}@%L] - %m%n");
        DEFAULT_LOG4J_PROP.put("log4j.logger.org.apache.zookeeper", SvaLogConstants.getLog4jZKLogger());
        DEFAULT_LOG4J_PROP.put("log4j.additivity.org.apache.zookeeper", "false");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ZKLOG", "org.apache.log4j.RollingFileAppender");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ZKLOG.Threshold", "INFO");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ZKLOG.File", SvaConstants.LogPath + "/zookeeper.log");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ZKLOG.layout", "org.apache.log4j.PatternLayout");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ZKLOG.layout.ConversionPattern", "%d{yyyy-MM-dd HH:mm:ss.SSS} %p - [%t:%C{1}@%L] - %m%n");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ZKLOG.MaxFileSize", "10MB");
        DEFAULT_LOG4J_PROP.put("log4j.appender.ZKLOG.MaxBackupIndex", "4");
        log4jProperties = null;
    }
}

