/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.messaging.ws.model;

import com.vmware.sva.messaging.ws.model.AbstractExport;
import com.vmware.sva.messaging.ws.model.NfsAccessControl;
import com.vmware.sva.messaging.ws.model.Volume;
import com.vmware.sva.messaging.ws.sva.ExtensionMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;
import org.apache.axis2.databinding.ADBBean;
import org.apache.axis2.databinding.ADBDataSource;
import org.apache.axis2.databinding.ADBException;
import org.apache.axis2.databinding.utils.BeanUtil;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.databinding.utils.reader.ADBXMLStreamReaderImpl;
import org.apache.axis2.databinding.utils.writer.MTOMAwareXMLStreamWriter;

public class NFSv3Export
extends AbstractExport
implements ADBBean {
    protected String localExportPath;
    protected boolean localExportPathTracker = false;
    protected NfsAccessControl[] localAcl;
    protected boolean localAclTracker = false;

    private static String generatePrefix(String namespace) {
        if (namespace.equals("urn:commonTypes")) {
            return "";
        }
        return BeanUtil.getUniquePrefix();
    }

    public String getExportPath() {
        return this.localExportPath;
    }

    public void setExportPath(String param) {
        this.localExportPathTracker = param != null;
        this.localExportPath = param;
    }

    public NfsAccessControl[] getAcl() {
        return this.localAcl;
    }

    protected void validateAcl(NfsAccessControl[] param) {
    }

    public void setAcl(NfsAccessControl[] param) {
        this.validateAcl(param);
        this.localAclTracker = param != null;
        this.localAcl = param;
    }

    public void addAcl(NfsAccessControl param) {
        if (this.localAcl == null) {
            this.localAcl = new NfsAccessControl[0];
        }
        this.localAclTracker = true;
        List list = ConverterUtil.toList((Object[])this.localAcl);
        list.add(param);
        this.localAcl = list.toArray(new NfsAccessControl[list.size()]);
    }

    public static boolean isReaderMTOMAware(XMLStreamReader reader) {
        boolean isReaderMTOMAware = false;
        try {
            isReaderMTOMAware = Boolean.TRUE.equals(reader.getProperty("IsDatahandlersAwareParsing"));
        }
        catch (IllegalArgumentException e) {
            isReaderMTOMAware = false;
        }
        return isReaderMTOMAware;
    }

    @Override
    public OMElement getOMElement(QName parentQName, final OMFactory factory) throws ADBException {
        ADBDataSource dataSource = new ADBDataSource(this, parentQName){

            public void serialize(MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException {
                NFSv3Export.this.serialize(this.parentQName, factory, xmlWriter);
            }
        };
        return new OMSourcedElementImpl(parentQName, factory, (OMDataSource)dataSource);
    }

    @Override
    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter) throws XMLStreamException, ADBException {
        this.serialize(parentQName, factory, xmlWriter, false);
    }

    @Override
    public void serialize(QName parentQName, OMFactory factory, MTOMAwareXMLStreamWriter xmlWriter, boolean serializeType) throws XMLStreamException, ADBException {
        String prefix = null;
        String namespace = null;
        prefix = parentQName.getPrefix();
        namespace = parentQName.getNamespaceURI();
        if (namespace != null && namespace.trim().length() > 0) {
            String writerPrefix = xmlWriter.getPrefix(namespace);
            if (writerPrefix != null) {
                xmlWriter.writeStartElement(namespace, parentQName.getLocalPart());
            } else {
                if (prefix == null) {
                    prefix = NFSv3Export.generatePrefix(namespace);
                }
                xmlWriter.writeStartElement(prefix, parentQName.getLocalPart(), namespace);
                xmlWriter.writeNamespace(prefix, namespace);
                xmlWriter.setPrefix(prefix, namespace);
            }
        } else {
            xmlWriter.writeStartElement(parentQName.getLocalPart());
        }
        String namespacePrefix = this.registerPrefix((XMLStreamWriter)xmlWriter, "urn:commonTypes");
        if (namespacePrefix != null && namespacePrefix.trim().length() > 0) {
            this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", namespacePrefix + ":NFSv3Export", (XMLStreamWriter)xmlWriter);
        } else {
            this.writeAttribute("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type", "NFSv3Export", (XMLStreamWriter)xmlWriter);
        }
        if (this.localIdTracker) {
            namespace = "urn:commonTypes";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = NFSv3Export.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "id", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "id");
                }
            } else {
                xmlWriter.writeStartElement("id");
            }
            if (this.localId == null) {
                throw new ADBException("id cannot be null!!");
            }
            xmlWriter.writeCharacters(this.localId);
            xmlWriter.writeEndElement();
        }
        if (this.localNameTracker) {
            namespace = "urn:commonTypes";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = NFSv3Export.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "name", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "name");
                }
            } else {
                xmlWriter.writeStartElement("name");
            }
            if (this.localName == null) {
                throw new ADBException("name cannot be null!!");
            }
            xmlWriter.writeCharacters(this.localName);
            xmlWriter.writeEndElement();
        }
        if (this.localStorageEntityIdTracker) {
            namespace = "urn:commonTypes";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = NFSv3Export.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "storageEntityId", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "storageEntityId");
                }
            } else {
                xmlWriter.writeStartElement("storageEntityId");
            }
            if (this.localStorageEntityId == null) {
                throw new ADBException("storageEntityId cannot be null!!");
            }
            xmlWriter.writeCharacters(this.localStorageEntityId);
            xmlWriter.writeEndElement();
        }
        if (this.localVolumeTracker) {
            if (this.localVolume == null) {
                throw new ADBException("volume cannot be null!!");
            }
            this.localVolume.serialize(new QName("urn:commonTypes", "volume"), factory, xmlWriter);
        }
        if (this.localExportPathTracker) {
            namespace = "urn:commonTypes";
            if (!namespace.equals("")) {
                prefix = xmlWriter.getPrefix(namespace);
                if (prefix == null) {
                    prefix = NFSv3Export.generatePrefix(namespace);
                    xmlWriter.writeStartElement(prefix, "exportPath", namespace);
                    xmlWriter.writeNamespace(prefix, namespace);
                    xmlWriter.setPrefix(prefix, namespace);
                } else {
                    xmlWriter.writeStartElement(namespace, "exportPath");
                }
            } else {
                xmlWriter.writeStartElement("exportPath");
            }
            if (this.localExportPath == null) {
                throw new ADBException("exportPath cannot be null!!");
            }
            xmlWriter.writeCharacters(this.localExportPath);
            xmlWriter.writeEndElement();
        }
        if (this.localAclTracker) {
            if (this.localAcl != null) {
                for (int i = 0; i < this.localAcl.length; ++i) {
                    if (this.localAcl[i] == null) continue;
                    this.localAcl[i].serialize(new QName("urn:commonTypes", "acl"), factory, xmlWriter);
                }
            } else {
                throw new ADBException("acl cannot be null!!");
            }
        }
        xmlWriter.writeEndElement();
    }

    private void writeAttribute(String prefix, String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (xmlWriter.getPrefix(namespace) == null) {
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        xmlWriter.writeAttribute(namespace, attName, attValue);
    }

    private void writeAttribute(String namespace, String attName, String attValue, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attValue);
        }
    }

    private void writeQNameAttribute(String namespace, String attName, QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String attributeNamespace = qname.getNamespaceURI();
        String attributePrefix = xmlWriter.getPrefix(attributeNamespace);
        if (attributePrefix == null) {
            attributePrefix = this.registerPrefix(xmlWriter, attributeNamespace);
        }
        String attributeValue = attributePrefix.trim().length() > 0 ? attributePrefix + ":" + qname.getLocalPart() : qname.getLocalPart();
        if (namespace.equals("")) {
            xmlWriter.writeAttribute(attName, attributeValue);
        } else {
            this.registerPrefix(xmlWriter, namespace);
            xmlWriter.writeAttribute(namespace, attName, attributeValue);
        }
    }

    private void writeQName(QName qname, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null) {
            String prefix = xmlWriter.getPrefix(namespaceURI);
            if (prefix == null) {
                prefix = NFSv3Export.generatePrefix(namespaceURI);
                xmlWriter.writeNamespace(prefix, namespaceURI);
                xmlWriter.setPrefix(prefix, namespaceURI);
            }
            if (prefix.trim().length() > 0) {
                xmlWriter.writeCharacters(prefix + ":" + ConverterUtil.convertToString((QName)qname));
            } else {
                xmlWriter.writeCharacters(ConverterUtil.convertToString((QName)qname));
            }
        } else {
            xmlWriter.writeCharacters(ConverterUtil.convertToString((QName)qname));
        }
    }

    private void writeQNames(QName[] qnames, XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (qnames != null) {
            StringBuffer stringToWrite = new StringBuffer();
            String namespaceURI = null;
            String prefix = null;
            for (int i = 0; i < qnames.length; ++i) {
                if (i > 0) {
                    stringToWrite.append(" ");
                }
                if ((namespaceURI = qnames[i].getNamespaceURI()) != null) {
                    prefix = xmlWriter.getPrefix(namespaceURI);
                    if (prefix == null || prefix.length() == 0) {
                        prefix = NFSv3Export.generatePrefix(namespaceURI);
                        xmlWriter.writeNamespace(prefix, namespaceURI);
                        xmlWriter.setPrefix(prefix, namespaceURI);
                    }
                    if (prefix.trim().length() > 0) {
                        stringToWrite.append(prefix).append(":").append(ConverterUtil.convertToString((QName)qnames[i]));
                        continue;
                    }
                    stringToWrite.append(ConverterUtil.convertToString((QName)qnames[i]));
                    continue;
                }
                stringToWrite.append(ConverterUtil.convertToString((QName)qnames[i]));
            }
            xmlWriter.writeCharacters(stringToWrite.toString());
        }
    }

    private String registerPrefix(XMLStreamWriter xmlWriter, String namespace) throws XMLStreamException {
        String prefix = xmlWriter.getPrefix(namespace);
        if (prefix == null) {
            prefix = NFSv3Export.generatePrefix(namespace);
            while (xmlWriter.getNamespaceContext().getNamespaceURI(prefix) != null) {
                prefix = BeanUtil.getUniquePrefix();
            }
            xmlWriter.writeNamespace(prefix, namespace);
            xmlWriter.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    @Override
    public XMLStreamReader getPullParser(QName qName) throws ADBException {
        ArrayList<Object> elementList = new ArrayList<Object>();
        ArrayList<QName> attribList = new ArrayList<QName>();
        attribList.add(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"));
        attribList.add(new QName("urn:commonTypes", "NFSv3Export"));
        if (this.localIdTracker) {
            elementList.add(new QName("urn:commonTypes", "id"));
            if (this.localId != null) {
                elementList.add(ConverterUtil.convertToString((String)this.localId));
            } else {
                throw new ADBException("id cannot be null!!");
            }
        }
        if (this.localNameTracker) {
            elementList.add(new QName("urn:commonTypes", "name"));
            if (this.localName != null) {
                elementList.add(ConverterUtil.convertToString((String)this.localName));
            } else {
                throw new ADBException("name cannot be null!!");
            }
        }
        if (this.localStorageEntityIdTracker) {
            elementList.add(new QName("urn:commonTypes", "storageEntityId"));
            if (this.localStorageEntityId != null) {
                elementList.add(ConverterUtil.convertToString((String)this.localStorageEntityId));
            } else {
                throw new ADBException("storageEntityId cannot be null!!");
            }
        }
        if (this.localVolumeTracker) {
            elementList.add(new QName("urn:commonTypes", "volume"));
            if (this.localVolume == null) {
                throw new ADBException("volume cannot be null!!");
            }
            elementList.add(this.localVolume);
        }
        if (this.localExportPathTracker) {
            elementList.add(new QName("urn:commonTypes", "exportPath"));
            if (this.localExportPath != null) {
                elementList.add(ConverterUtil.convertToString((String)this.localExportPath));
            } else {
                throw new ADBException("exportPath cannot be null!!");
            }
        }
        if (this.localAclTracker) {
            if (this.localAcl != null) {
                for (int i = 0; i < this.localAcl.length; ++i) {
                    if (this.localAcl[i] == null) continue;
                    elementList.add(new QName("urn:commonTypes", "acl"));
                    elementList.add(this.localAcl[i]);
                }
            } else {
                throw new ADBException("acl cannot be null!!");
            }
        }
        return new ADBXMLStreamReaderImpl(qName, elementList.toArray(), attribList.toArray());
    }

    public static class Factory {
        public static NFSv3Export parse(XMLStreamReader reader) throws Exception {
            NFSv3Export object = new NFSv3Export();
            Object nillableValue = null;
            String prefix = "";
            String namespaceuri = "";
            try {
                String content;
                String fullTypeName;
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type") != null && (fullTypeName = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")) != null) {
                    String nsPrefix = null;
                    if (fullTypeName.indexOf(":") > -1) {
                        nsPrefix = fullTypeName.substring(0, fullTypeName.indexOf(":"));
                    }
                    nsPrefix = nsPrefix == null ? "" : nsPrefix;
                    String type = fullTypeName.substring(fullTypeName.indexOf(":") + 1);
                    if (!"NFSv3Export".equals(type)) {
                        String nsUri = reader.getNamespaceContext().getNamespaceURI(nsPrefix);
                        return (NFSv3Export)ExtensionMapper.getTypeObject(nsUri, type, reader);
                    }
                }
                Vector handledAttributes = new Vector();
                reader.next();
                ArrayList<NfsAccessControl> list6 = new ArrayList<NfsAccessControl>();
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "id").equals(reader.getName())) {
                    content = reader.getElementText();
                    object.setId(ConverterUtil.convertToString((String)content));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "name").equals(reader.getName())) {
                    content = reader.getElementText();
                    object.setName(ConverterUtil.convertToString((String)content));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "storageEntityId").equals(reader.getName())) {
                    content = reader.getElementText();
                    object.setStorageEntityId(ConverterUtil.convertToString((String)content));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "volume").equals(reader.getName())) {
                    object.setVolume(Volume.Factory.parse(reader));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "exportPath").equals(reader.getName())) {
                    content = reader.getElementText();
                    object.setExportPath(ConverterUtil.convertToString((String)content));
                    reader.next();
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement() && new QName("urn:commonTypes", "acl").equals(reader.getName())) {
                    list6.add(NfsAccessControl.Factory.parse(reader));
                    boolean loopDone6 = false;
                    while (!loopDone6) {
                        while (!reader.isEndElement()) {
                            reader.next();
                        }
                        reader.next();
                        while (!reader.isStartElement() && !reader.isEndElement()) {
                            reader.next();
                        }
                        if (reader.isEndElement()) {
                            loopDone6 = true;
                            continue;
                        }
                        if (new QName("urn:commonTypes", "acl").equals(reader.getName())) {
                            list6.add(NfsAccessControl.Factory.parse(reader));
                            continue;
                        }
                        loopDone6 = true;
                    }
                    object.setAcl((NfsAccessControl[])ConverterUtil.convertToArray(NfsAccessControl.class, list6));
                }
                while (!reader.isStartElement() && !reader.isEndElement()) {
                    reader.next();
                }
                if (reader.isStartElement()) {
                    throw new ADBException("Unexpected subelement " + reader.getLocalName());
                }
            }
            catch (XMLStreamException e) {
                throw new Exception(e);
            }
            return object;
        }
    }
}

