/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.blc;

import com.vmware.sva.blc.AbstractBlcEvent;
import com.vmware.sva.blc.BlcFailureHandler;
import com.vmware.sva.bld.AbstractBldInformation;
import com.vmware.sva.bld.AbstractBldTransactionOperation;
import com.vmware.sva.bld.BldTransaction;
import com.vmware.sva.bld.BldType;
import com.vmware.sva.bld.BusinessLogicDomainBlcAPI;
import com.vmware.sva.bld.DeleteBlcOperation;
import com.vmware.sva.bld.DequeueBlcEventOperation;
import com.vmware.sva.bld.QueueBlcEventOperation;
import com.vmware.sva.bld.SaveBlcOperation;
import com.vmware.sva.bld.ServiceRequestOperation;
import com.vmware.sva.bld.StartBlcOperation;
import com.vmware.sva.common.AbstractUniqueObject;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaDebug;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.domainservice.AbstractServiceResponse;
import com.vmware.sva.faultinsertion.FaultInsertion;
import com.vmware.sva.services.blcevents.AbstractBlcMessage;
import com.vmware.sva.services.blcevents.BlcEventAddressInfo;
import com.vmware.sva.services.blcevents.controlevent.BlcChangeParentBlcIdEvent;
import com.vmware.sva.services.blcevents.controlevent.BlcParentBlcIdChangedEvent;
import com.vmware.sva.services.blcevents.controlevent.BlcRestartEvent;
import com.vmware.sva.services.blcevents.controlevent.BlcStopEvent;
import com.vmware.sva.services.blcevents.controlevent.BlcTerminateEvent;
import com.vmware.sva.services.health.CheckPseudoSvaOnlineRequest;
import com.vmware.sva.services.health.CheckPseudoSvaOnlineResponse;
import com.vmware.sva.services.health.HealthService;
import com.vmware.sva.services.health.RemoteDomainOnlineChangeRequest;
import com.vmware.sva.services.health.RemoteDomainOnlineChangeResponse;
import com.vmware.sva.services.health.UnregisterRemoteDomainOnlineNotification;
import com.vmware.sva.services.logger.LoggerRequest;
import com.vmware.sva.services.logger.SvaLoggerInterface;
import com.vmware.sva.services.messaging.BlcMessageRequest;
import com.vmware.sva.services.shareddatabase.DeleteSharedObjectRequest;
import com.vmware.sva.services.shareddatabase.GetSharedObjectRequest;
import com.vmware.sva.services.shareddatabase.GetSharedObjectResponse;
import com.vmware.sva.services.shareddatabase.SharedObjectService;
import com.vmware.sva.services.shareddatabase.WriteSharedObjectRequest;
import com.vmware.sva.services.watchdog.CreateWatchdogTimerRequest;
import com.vmware.sva.services.watchdog.CreateWatchdogTimerResponse;
import com.vmware.sva.services.watchdog.WatchdogService;
import com.vmware.sva.services.watchdog.WatchdogTimer;
import com.vmware.sva.util.SvaHelper;
import com.vmware.sva.util.SystemUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class AbstractBusinessLogicComponent
extends AbstractUniqueObject
implements BlcFailureHandler,
Runnable,
Serializable,
SvaLoggerInterface {
    private static final long serialVersionUID = 1L;
    private volatile transient BlockingDeque<AbstractBlcEvent> eventQueue = new LinkedBlockingDeque<AbstractBlcEvent>();
    private transient BldTransaction transaction = null;
    private transient BusinessLogicDomainBlcAPI domain;
    private transient Thread blcThread = null;
    private transient List<BlcTimer> timers = null;
    private static final Timer timer = new Timer("BLC Timer");
    private volatile int state;
    private volatile transient boolean stopped;
    private UUID parentBlcId;
    private transient WatchdogTimer edgeWatchdog = null;
    private transient long maxEdgeDuration = -1L;
    protected int edgeWatchdogInterval = SvaConstants.BLC_EDGE_WATCHDOG_INTERVAL;
    private transient boolean blcStateSaved = false;
    private static volatile transient boolean stoppingSvaServer = false;
    private static final String BLC_EDGE_WATCHDOG_NAME = "EdgeDog";
    private transient long edgeCount = 0L;
    private transient BlcFailureHandler failureHandler = this;

    public AbstractBusinessLogicComponent(UUID id, String name, UUID parentBlcId) {
        super(id, name);
        this.parentBlcId = parentBlcId;
        this.state = 0;
    }

    public AbstractBusinessLogicComponent(UUID id, String name, UUID parentBlcId, BusinessLogicDomainBlcAPI domain) {
        this(id, name, parentBlcId);
        this.start(domain);
    }

    public AbstractBusinessLogicComponent(String name, UUID parentBlcId, BusinessLogicDomainBlcAPI domain) {
        this(UUID.randomUUID(), name, parentBlcId, domain);
    }

    public BldType getBldType() {
        return this.domain.getType();
    }

    public UUID getParentBlcId() {
        return this.parentBlcId;
    }

    protected void setParentBlcId(UUID parentBlcId) {
        this.parentBlcId = parentBlcId;
    }

    protected BusinessLogicDomainBlcAPI getBld() {
        return this.domain;
    }

    public void setEventQueue(List<AbstractBlcEvent> events) {
        this.eventQueue = new LinkedBlockingDeque<AbstractBlcEvent>(events);
    }

    public void restart(BusinessLogicDomainBlcAPI domain, UUID prevMasterId) {
        this.eventQueue.addFirst(new BlcRestartEvent(prevMasterId));
        this.start(domain);
    }

    private void start(BusinessLogicDomainBlcAPI domain) {
        this.stopped = false;
        this.domain = domain;
        this.timers = new ArrayList<BlcTimer>();
        assert (this.blcThread == null) : "BLC THREAD " + this.getName() + " IS ACTIVE!!!";
        this.blcThread = new Thread((Runnable)this, this.getName());
        this.blcThread.start();
    }

    public void queueEvent(AbstractBlcEvent event) {
        this.eventQueue.add(event);
    }

    public void stop() {
        this.eventQueue.addFirst(new BlcStopEvent());
    }

    protected final WatchdogTimer createWatchdogTimer(String name, int interval) throws Exception {
        if (!SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            return null;
        }
        CreateWatchdogTimerRequest request = new CreateWatchdogTimerRequest(this.getId(), name, interval);
        CreateWatchdogTimerResponse response = (CreateWatchdogTimerResponse)this.syncServiceRequest(WatchdogService.SERVICE_ID, request);
        if (!response.isSuccess()) {
            throw response.getException();
        }
        return response.getTimer();
    }

    protected final void keepEdgeWatchdogAlive() throws Exception {
        if (!SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            return;
        }
        this.edgeWatchdog.keepAlive();
    }

    protected final void resetEdgeWatchdog(int newInterval) throws Exception {
        if (!SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            return;
        }
        assert (this.edgeWatchdog != null) : "edgeWatchdog does not exist";
        this.edgeWatchdog.reset(newInterval);
    }

    protected WatchdogTimer getEdgeWatchdog() {
        if (!SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            return null;
        }
        return this.edgeWatchdog;
    }

    private void setEdgeWatchdog(AbstractBlcEvent event) throws Exception {
        if (!SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            return;
        }
        String name = String.format("%s-%s-%s-%s-%d", BLC_EDGE_WATCHDOG_NAME, this.getId(), this.getClass().getSimpleName(), ((Object)((Object)event)).getClass().getSimpleName(), ++this.edgeCount);
        assert (this.edgeWatchdog == null) : "Edge watchdog already exists: " + name;
        this.edgeWatchdog = this.createWatchdogTimer(name, this.edgeWatchdogInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearEdgeWatchdog() {
        if (!SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            return;
        }
        if (this.edgeWatchdog != null) {
            try {
                long duration = this.edgeWatchdog.delete();
                if (SvaDebug.LOG_EDGE_DURATION) {
                    if (duration > this.maxEdgeDuration) {
                        this.maxEdgeDuration = duration;
                    }
                    this.domain.log(Level.INFO, this.getName() + " " + this.edgeWatchdog.getName() + " took " + duration + " ms (max:" + this.maxEdgeDuration + ")");
                }
            }
            catch (Exception e) {
                this.domain.log(Level.SEVERE, "Failed to clear edge watchdog", e);
            }
            finally {
                this.edgeWatchdog = null;
            }
        }
    }

    @Override
    public void handleEventFailure(UUID blcId, AbstractBlcEvent event, Throwable exception) {
        try {
            assert (AbstractBusinessLogicComponent.throwIfNotAssertionError((Throwable)exception));
        }
        catch (AssertionError e) {
            exception = e;
        }
        if (exception instanceof AssertionError) {
            if (this.transaction != null) {
                this.log(Level.SEVERE, this.getName() + ": Triggered assertion for event " + (Object)((Object)event), (Throwable)exception);
            }
            SvaHelper.handleAssertionError(this.getName(), (AssertionError)exception, this.domain);
        } else if (this.transaction != null) {
            this.log(Level.SEVERE, "Could not handle event " + (Object)((Object)event), (Throwable)exception);
        } else {
            this.domain.log(Level.SEVERE, "Could not handle event " + (Object)((Object)event), (Throwable)exception);
            ((Throwable)exception).printStackTrace();
        }
    }

    private static boolean throwIfNotAssertionError(Throwable exception) {
        if (exception != null && !(exception instanceof AssertionError)) {
            throw new AssertionError((Object)exception);
        }
        return true;
    }

    protected final void reboot(boolean force) {
        if (!SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            return;
        }
        SystemUtils.reboot(force, this.edgeWatchdog, this.domain);
    }

    protected final void shutdown(boolean force) {
        if (!SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            return;
        }
        SystemUtils.shutdown(force, this.edgeWatchdog, this.domain);
    }

    protected final void sync() {
        if (!SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            return;
        }
        SystemUtils.sync(this.edgeWatchdog, this.domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        CleanShutdownHook shutdownHook = new CleanShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        while (!this.stopped) {
            AbstractBlcEvent event = null;
            try {
                event = this.eventQueue.take();
                AbstractBusinessLogicComponent abstractBusinessLogicComponent = this;
                synchronized (abstractBusinessLogicComponent) {
                    FaultInsertion.BLC_EDGE.checkFault(this.getClass(), this.getState(), ((Object)((Object)event)).getClass());
                    this.setEdgeWatchdog(event);
                    if (event instanceof BlcStopEvent) {
                        this.domain.stopBlc(this.getId());
                        this.stopped = true;
                    } else {
                        this.transaction = new BldTransaction();
                        try {
                            if (event.getPersistent()) {
                                this.transaction.add(new DequeueBlcEventOperation(this.getId(), event.getEventId()));
                            }
                            if (event instanceof BlcTerminateEvent) {
                                this.domain.log(Level.FINE, "BLC " + this.getName() + " terminated");
                                this.transaction.add(new DeleteBlcOperation(this.getId()));
                                this.stopped = true;
                            } else if (event instanceof BlcChangeParentBlcIdEvent) {
                                this.handleBlcChangeParentBlcIdEvent((BlcChangeParentBlcIdEvent)event);
                            } else if (this.validEvent(event)) {
                                try {
                                    this.handleEvent(event);
                                }
                                catch (Throwable e) {
                                    if (this.failureHandler == null) {
                                        this.failureHandler = this;
                                    }
                                    this.failureHandler.handleEventFailure(this.getId(), event, e);
                                }
                            }
                            if (!this.stopped) {
                                this.transaction.add(new SaveBlcOperation(this));
                            }
                            this.blcStateSaved = false;
                            this.domain.commitTransaction(this.transaction);
                        }
                        finally {
                            this.transaction = null;
                        }
                        while (!this.stopped && !this.blcStateSaved) {
                            this.wait();
                        }
                    }
                    this.clearEdgeWatchdog();
                }
            }
            catch (Throwable e) {
                this.clearEdgeWatchdog();
                if (this.failureHandler == null) {
                    this.failureHandler = this;
                }
                this.failureHandler.handleEventFailure(this.getId(), event, e);
            }
        }
        this.domain.log(Level.FINE, "BLC " + this.getName() + " thread stopping");
        try {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
        catch (IllegalStateException e) {
            this.domain.log(Level.WARNING, "Exception removing shutdown hook", e);
        }
        List<BlcTimer> list = this.timers;
        synchronized (list) {
            while (!this.timers.isEmpty()) {
                this.timers.get(0).cancel();
            }
        }
        this.blcThread = null;
    }

    protected void cleanShutdown() {
        try {
            this.clearEdgeWatchdog();
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to clear watchdog on application exit: " + e.getMessage(), e);
        }
    }

    protected boolean validEvent(AbstractBlcEvent event) {
        return true;
    }

    protected int getState() {
        return this.state;
    }

    protected void setState(int state) {
        this.state = state;
    }

    protected abstract void handleEvent(AbstractBlcEvent var1);

    protected void asyncServiceRequest(UUID serviceId, AbstractServiceRequest request) {
        this.addOperation(new ServiceRequestOperation(serviceId, request));
    }

    private synchronized void addOperation(AbstractBldTransactionOperation operation) {
        if (this.transaction == null) {
            String message = "No transaction active for operation " + SvaHelper.getSimpleClassName((Object)operation);
            IllegalStateException exception = new IllegalStateException(message);
            this.log(Level.SEVERE, message, exception);
            throw exception;
        }
        this.transaction.add(operation);
    }

    protected AbstractServiceResponse syncServiceRequest(UUID serviceId, AbstractServiceRequest request) {
        return this.domain.syncServiceRequest(serviceId, request);
    }

    @Override
    public void log(LogRecord logRecord) {
        String methodName = "unknownMethod";
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stackTrace.length; ++i) {
            String m = stackTrace[i].getMethodName();
            if (m.equalsIgnoreCase("log") || m.equalsIgnoreCase("log_trace")) continue;
            methodName = m;
            break;
        }
        logRecord.setSourceClassName(this.getClass().getCanonicalName());
        logRecord.setSourceMethodName(methodName);
        Object[] params = new Object[]{this.getId()};
        logRecord.setParameters(params);
        this.sendLoggerRequest(new LoggerRequest(this.getId(), logRecord));
    }

    protected abstract void sendLoggerRequest(LoggerRequest var1);

    @Override
    public void log(Level level, String msg) {
        this.log(new LogRecord(level, msg));
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        LogRecord lr = new LogRecord(level, msg);
        lr.setThrown(thrown);
        this.log(lr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blcSaved() {
        AbstractBusinessLogicComponent abstractBusinessLogicComponent = this;
        synchronized (abstractBusinessLogicComponent) {
            this.blcStateSaved = true;
            this.notifyAll();
        }
    }

    protected AbstractBldInformation getRemoteDomainInformation(UUID remoteBldId, boolean watch) {
        RemoteDomainOnlineChangeResponse rdocr = (RemoteDomainOnlineChangeResponse)this.syncServiceRequest(HealthService.SERVICE_ID, new RemoteDomainOnlineChangeRequest(this.getId(), remoteBldId, watch));
        if (rdocr == null) {
            this.log(Level.SEVERE, "Failed to contact Health Service");
            return null;
        }
        return rdocr.getBldInformation();
    }

    protected void unregisterRemoteDomainOnlineNotification(UUID bldId) {
        this.syncServiceRequest(HealthService.SERVICE_ID, new UnregisterRemoteDomainOnlineNotification(this.getId(), bldId));
    }

    protected boolean isPseudoSvaOnline(boolean watch) {
        CheckPseudoSvaOnlineRequest request = new CheckPseudoSvaOnlineRequest(this.getId(), watch);
        CheckPseudoSvaOnlineResponse response = (CheckPseudoSvaOnlineResponse)this.syncServiceRequest(HealthService.SERVICE_ID, request);
        return response.isOnline();
    }

    protected UUID startBlc(AbstractBusinessLogicComponent blc) {
        this.addOperation(new StartBlcOperation(blc));
        return blc.getId();
    }

    protected void sendMessage(BlcEventAddressInfo header, AbstractBlcMessage msg) {
        if (msg.getHeader() != null) {
            BlcEventAddressInfo origHeader = msg.getHeader();
            String errMsg = "BLC Message: " + ((Object)((Object)msg)).getClass().getName() + " cannot be sent to multiple destinations. " + "[Original Destination: {BLD: " + origHeader.getDestinationBld() + "; BLC: " + origHeader.getDestinationBlc() + ";}]" + "[New Destination: {BLD: " + header.getDestinationBld() + "; BLC: " + header.getDestinationBlc() + ";}]";
            assert (false) : errMsg;
        }
        msg.setHeader(header);
        this.addOperation(new ServiceRequestOperation(SvaConstants.MESSAGE_SERVICE_ID, new BlcMessageRequest(msg)));
    }

    protected void sendMessage(UUID dstBld, UUID dstBlc, AbstractBlcMessage msg) {
        BlcEventAddressInfo header = new BlcEventAddressInfo(this.domain.getId(), this.getId(), dstBld, dstBlc);
        this.sendMessage(header, msg);
    }

    protected void sendMessage(UUID dstBlc, AbstractBlcMessage msg) {
        BlcEventAddressInfo header = new BlcEventAddressInfo(SvaConstants.DefaultUUID, this.getId(), SvaConstants.DefaultUUID, dstBlc);
        this.sendMessage(header, msg);
    }

    protected void sendResponse(AbstractBlcMessage request, AbstractBlcMessage response) {
        BlcEventAddressInfo responseAddress = request.getHeader().constructResponseAddress();
        this.sendMessage(responseAddress, response);
    }

    protected void terminateSelf() {
        this.terminateBlc(this.getId());
    }

    protected BlcTimer startTimer(long delay, AbstractBlcEvent event) {
        return new BlcTimer(delay, event);
    }

    protected void changeParentBlcId(UUID childBlcId, UUID newParentBlcId) {
        this.addOperation(new QueueBlcEventOperation(childBlcId, new BlcChangeParentBlcIdEvent(newParentBlcId)));
    }

    protected void writeSharedObject(String key, Serializable obj) {
        WriteSharedObjectRequest request = new WriteSharedObjectRequest(this.getId(), key, obj);
        this.asyncServiceRequest(SharedObjectService.SERVICE_ID, request);
    }

    protected void deleteSharedObject(String key) {
        DeleteSharedObjectRequest request = new DeleteSharedObjectRequest(this.getId(), key);
        this.asyncServiceRequest(SharedObjectService.SERVICE_ID, request);
    }

    protected Serializable getSharedObject(String key) {
        GetSharedObjectRequest request = new GetSharedObjectRequest(this.getId(), key);
        GetSharedObjectResponse response = (GetSharedObjectResponse)this.syncServiceRequest(SharedObjectService.SERVICE_ID, request);
        if (!response.isSuccess()) {
            this.log(Level.SEVERE, "Database exception while retrieving shared object (key: " + key + ")", response.getException());
            this.reboot(true);
            return null;
        }
        return response.getObj();
    }

    private void terminateBlc(UUID blcId) {
        this.addOperation(new QueueBlcEventOperation(blcId, new BlcTerminateEvent()));
    }

    private void handleBlcChangeParentBlcIdEvent(BlcChangeParentBlcIdEvent event) {
        UUID oldParentBlcId = this.getParentBlcId();
        UUID newParentBlcId = event.getParentBlcId();
        this.setParentBlcId(newParentBlcId);
        BlcParentBlcIdChangedEvent blcParentBlcIdChangedEvent = new BlcParentBlcIdChangedEvent(this.getId(), oldParentBlcId, newParentBlcId);
        if (oldParentBlcId != null) {
            this.addOperation(new QueueBlcEventOperation(oldParentBlcId, blcParentBlcIdChangedEvent));
        }
        if (newParentBlcId != null) {
            this.addOperation(new QueueBlcEventOperation(newParentBlcId, blcParentBlcIdChangedEvent));
        }
        this.addOperation(new QueueBlcEventOperation(this.getId(), blcParentBlcIdChangedEvent));
    }

    protected void setStoppingSvaServer() {
        stoppingSvaServer = true;
    }

    void setFailureHandler(BlcFailureHandler failureHandler) {
        this.failureHandler = failureHandler;
    }

    protected boolean isTransactionActive() {
        return this.transaction != null;
    }

    protected class BlcTimer {
        private final BlcTimerTask task;

        public BlcTimer(long delay, AbstractBlcEvent event) {
            this.task = new BlcTimerTask(event);
            this.addBlcTimer(this);
            timer.schedule((TimerTask)this.task, delay);
        }

        public void cancel() {
            this.task.cancel();
            this.removeBlcTimer(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addBlcTimer(BlcTimer blcTimer) {
            List list = AbstractBusinessLogicComponent.this.timers;
            synchronized (list) {
                AbstractBusinessLogicComponent.this.timers.add(blcTimer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeBlcTimer(BlcTimer blcTimer) {
            List list = AbstractBusinessLogicComponent.this.timers;
            synchronized (list) {
                AbstractBusinessLogicComponent.this.timers.remove(blcTimer);
            }
        }

        private class BlcTimerTask
        extends TimerTask {
            private final AbstractBlcEvent event;

            BlcTimerTask(AbstractBlcEvent event) {
                this.event = event;
            }

            @Override
            public void run() {
                try {
                    if (!AbstractBusinessLogicComponent.this.stopped) {
                        AbstractBusinessLogicComponent.this.eventQueue.add(this.event);
                    }
                    BlcTimer.this.removeBlcTimer(BlcTimer.this);
                }
                catch (AssertionError e) {
                    SvaHelper.handleAssertionError(AbstractBusinessLogicComponent.this.getName() + " BlcTimerTask", e, AbstractBusinessLogicComponent.this.domain);
                }
                catch (Throwable e) {
                    AbstractBusinessLogicComponent.this.domain.log(Level.SEVERE, "Exception delivering timer queue event: " + e.getMessage(), e);
                }
            }
        }
    }

    private class CleanShutdownHook
    extends Thread {
        CleanShutdownHook() {
            super("Clean Shutdown Hook");
        }

        @Override
        public void run() {
            if (stoppingSvaServer) {
                AbstractBusinessLogicComponent.this.cleanShutdown();
            }
        }
    }
}

