/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld;

import com.vmware.sva.blc.AbstractBlcEvent;
import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.bld.AbstractBldTransactionOperation;
import com.vmware.sva.bld.BldSerialization;
import com.vmware.sva.bld.BldStopTransaction;
import com.vmware.sva.bld.BldTransaction;
import com.vmware.sva.bld.BusinessLogicDomain;
import com.vmware.sva.bld.BusinessLogicDomainBlcAPI;
import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.bld.DeleteBlcOperation;
import com.vmware.sva.bld.DequeueBlcEventOperation;
import com.vmware.sva.bld.QueueBlcEventOperation;
import com.vmware.sva.bld.SaveBlcOperation;
import com.vmware.sva.bld.ServiceRequestOperation;
import com.vmware.sva.bld.StartBlcOperation;
import com.vmware.sva.common.AbstractUniqueObject;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaDebug;
import com.vmware.sva.common.VersionedSerializable;
import com.vmware.sva.domainservice.AbstractServiceEvent;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.domainservice.AbstractServiceResponse;
import com.vmware.sva.domainservice.DomainService;
import com.vmware.sva.domainservice.UndeliveredServiceEvent;
import com.vmware.sva.services.blcevents.AbstractBlcMessage;
import com.vmware.sva.services.blcevents.BlcUndeliveredEvent;
import com.vmware.sva.services.blcevents.controlevent.BlcChildTerminatedEvent;
import com.vmware.sva.services.blcevents.controlevent.BlcStartEvent;
import com.vmware.sva.services.blcevents.controlevent.BlcStopEvent;
import com.vmware.sva.services.logger.SvaLogger;
import com.vmware.sva.services.logger.SvaLoggerInterface;
import com.vmware.sva.services.messaging.BlcMessageRequest;
import com.vmware.sva.services.watchdog.WatchdogService;
import com.vmware.sva.util.SvaHelper;
import com.vmware.sva.util.SystemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@VersionedSerializable(value=false)
public abstract class AbstractBusinessLogicDomain
extends AbstractUniqueObject
implements BusinessLogicDomain,
BusinessLogicDomainBlcAPI,
BusinessLogicDomainServiceAPI,
Runnable,
SvaLoggerInterface {
    protected final ConcurrentMap<UUID, DomainService> serviceMap = new ConcurrentHashMap<UUID, DomainService>();
    private final List<DomainService> activeServices = new ArrayList<DomainService>();
    protected final ConcurrentMap<UUID, AbstractBusinessLogicComponent> blcMap = new ConcurrentHashMap<UUID, AbstractBusinessLogicComponent>();
    protected BlockingDeque<BldTransaction> transactionQueue = new LinkedBlockingDeque<BldTransaction>();
    protected static final Logger logger = Logger.getLogger(AbstractBusinessLogicDomain.class.getName());
    private Thread bldThread = null;
    private WatchdogService watchdogService;
    protected volatile boolean terminated = false;
    private volatile boolean stopped = false;
    private static final long serialVersionUID = 1L;

    public AbstractBusinessLogicDomain(UUID bldId, String name) throws Exception {
        super(bldId, name);
        SvaConstants.createPath((String)SvaConstants.LogPath);
        SvaLogger.loggerSetup(this.getName());
        if (SvaConstants.ENABLE_SYSTEM_WATCHDOG) {
            this.setWatchdogService(new WatchdogService(this));
        }
    }

    @Override
    public abstract void setDefaultBlc(AbstractBusinessLogicComponent var1) throws Exception;

    @Override
    public final Thread start() throws Exception {
        this.bldThread = new Thread((Runnable)this, this.getName());
        this.bldThread.start();
        return this.bldThread;
    }

    @Override
    public void stop(boolean deleteDatabase) throws InterruptedException {
        this.stopped = true;
        if (this.blcMap.isEmpty()) {
            this.blcsStopped();
            this.transactionQueue.addFirst(new BldStopTransaction());
        } else {
            for (AbstractBusinessLogicComponent blc : this.blcMap.values()) {
                blc.queueEvent(new BlcStopEvent());
            }
        }
        this.bldThread.join();
        if (deleteDatabase) {
            try {
                this.deleteDatabase();
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Error while deleting database: " + e.getMessage());
            }
        }
    }

    @Override
    public final void log(LogRecord logRecord) {
        String methodName = "unknownMethod";
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stackTrace.length; ++i) {
            String m = stackTrace[i].getMethodName();
            if (m.equalsIgnoreCase("log")) continue;
            methodName = m;
            break;
        }
        logRecord.setSourceClassName(this.getClass().getCanonicalName());
        logRecord.setSourceMethodName(methodName);
        logger.log(logRecord);
    }

    @Override
    public final void log(Level level, String msg) {
        this.log(new LogRecord(level, msg));
    }

    @Override
    public final void log(Level level, String msg, Throwable thrown) {
        LogRecord logRecord = new LogRecord(level, msg);
        logRecord.setThrown(thrown);
        this.log(logRecord);
    }

    @Override
    public void registerService(DomainService service) throws Exception {
        UUID serviceId = service.getServiceId();
        if (this.serviceMap.putIfAbsent(serviceId, service) != null) {
            throw new Exception("Service is already registered");
        }
    }

    @Override
    public void unregisterService(UUID serviceId) throws Exception {
        if (this.serviceMap.remove(serviceId) == null) {
            throw new Exception("Service is not registered");
        }
    }

    @Override
    public void queueLiveBlcEvent(UUID blcId, AbstractBlcEvent event) {
        AbstractBusinessLogicComponent blc = (AbstractBusinessLogicComponent)this.blcMap.get(blcId);
        if (blc == null) {
            this.handleUndeliveredBlcEvent(blcId, event, false);
        } else {
            blc.queueEvent(event);
        }
    }

    @Override
    public void queuePersistentBlcEvent(UUID blcId, AbstractBlcEvent event) {
        this.log(Level.SEVERE, "BLC event persistence not implemented");
    }

    @Override
    public AbstractServiceResponse syncServiceRequest(UUID serviceId, AbstractServiceRequest request) {
        try {
            DomainService service = this.getService(serviceId);
            return service.syncRequest(request);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Caught exception while calling service syncRequest: ", e);
            return null;
        }
    }

    @Override
    public Logger getLogger() {
        return logger;
    }

    @Override
    public void run() {
        try {
            boolean fatalException = false;
            while (!fatalException && !this.stopped) {
                this.blcMap.clear();
                this.transactionQueue = new LinkedBlockingDeque<BldTransaction>();
                if (!this.startServices()) {
                    fatalException = true;
                } else if (!this.startDomain()) {
                    fatalException = true;
                } else {
                    this.terminated = false;
                    while (!this.terminated) {
                        try {
                            BldTransaction transaction = this.transactionQueue.take();
                            if (!(transaction instanceof BldStopTransaction)) {
                                this.processPersistTransaction(transaction);
                                this.processLiveTransaction(transaction);
                                continue;
                            }
                            this.terminated = true;
                        }
                        catch (AssertionError e) {
                            SvaHelper.handleAssertionError(this.getName(), e, this);
                        }
                        catch (Throwable e) {
                            this.log(Level.SEVERE, "BLD received unexpected exception: ", e);
                            fatalException = true;
                            this.terminated = true;
                        }
                    }
                    this.log(Level.INFO, "BLD Stopped: " + this.getName());
                    if (!this.stopDomain()) {
                        fatalException = true;
                    }
                }
                if (this.stopServices()) continue;
                fatalException = true;
            }
            this.closeDomain();
            if (fatalException && !SvaDebug.DEBUG_NFS_STARTUP) {
                SystemUtils.reboot(true, null, this);
            }
        }
        catch (AssertionError e) {
            SvaHelper.handleAssertionError(this.getName(), e, this);
        }
        catch (Throwable e) {
            this.log(Level.SEVERE, "Exception while running " + this.getName() + ": " + e.getMessage(), e);
        }
    }

    protected abstract boolean startDomain();

    protected abstract boolean stopDomain();

    protected abstract void closeDomain();

    protected void startReplica(UUID prevMasterId) throws Exception {
        this.startBlcs(prevMasterId);
    }

    protected abstract void deleteDatabase() throws Exception;

    private boolean startServices() {
        this.activeServices.clear();
        for (DomainService service : this.serviceMap.values()) {
            try {
                service.start();
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Unable to start service " + service.getName(), e);
                return false;
            }
            this.activeServices.add(service);
        }
        return true;
    }

    protected boolean stopServices() {
        boolean success = true;
        for (DomainService service : this.activeServices) {
            try {
                service.stop();
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Unable to stop service " + service.getName(), e);
                success = false;
            }
        }
        this.activeServices.clear();
        return success;
    }

    protected void handlePersistentServiceRequest(ServiceRequestOperation serviceRequestOperation, boolean reprocessing) throws Exception {
        UUID serviceId = serviceRequestOperation.getServiceId();
        AbstractServiceRequest serviceRequest = serviceRequestOperation.getServiceRequest();
        DomainService service = this.getService(serviceId);
        if (reprocessing) {
            this.log(Level.INFO, "Reprocessing " + (Object)((Object)serviceRequestOperation));
            service.reprocessPersistRequest(serviceRequest);
        } else {
            service.persistRequest(serviceRequest);
        }
    }

    protected void processPersistTransaction(BldTransaction transaction) {
    }

    protected void blcsStopped() {
        this.terminated = true;
    }

    protected void handleUndeliveredBlcEvent(UUID blcId, AbstractBlcEvent event, boolean persistentHandling) {
        block11: {
            if (event instanceof AbstractBlcMessage) {
                if (!(event instanceof BlcUndeliveredEvent)) {
                    this.log(Level.WARNING, "Message for non-existent BLC");
                    BlcUndeliveredEvent undeliveredBlcMessage = new BlcUndeliveredEvent(this.getId(), (AbstractBlcMessage)event);
                    BlcMessageRequest blcMessageRequest = new BlcMessageRequest(undeliveredBlcMessage);
                    try {
                        if (persistentHandling) {
                            this.getService(SvaConstants.MESSAGE_SERVICE_ID).persistRequest(blcMessageRequest);
                            break block11;
                        }
                        this.getService(SvaConstants.MESSAGE_SERVICE_ID).postpersistRequest(blcMessageRequest);
                    }
                    catch (Exception e) {
                        this.log(Level.SEVERE, "Could not return undelivered message", e);
                    }
                }
            } else if (event instanceof AbstractServiceEvent) {
                this.log(Level.WARNING, "Service event for non-existent BLC");
                AbstractServiceEvent origServiceEvent = (AbstractServiceEvent)event;
                UUID serviceId = origServiceEvent.getServiceId();
                UndeliveredServiceEvent undeliveredServiceEvent = new UndeliveredServiceEvent(blcId, origServiceEvent);
                try {
                    if (persistentHandling) {
                        this.getService(serviceId).persistRequest(undeliveredServiceEvent);
                        break block11;
                    }
                    this.getService(serviceId).postpersistRequest(undeliveredServiceEvent);
                }
                catch (Exception e) {
                    this.log(Level.SEVERE, "Could not return undelivered event", e);
                }
            } else {
                this.log(Level.SEVERE, "Event for non-existent BLC");
            }
        }
    }

    private void handlePostpersistentServiceRequest(ServiceRequestOperation serviceRequestOperation) throws Exception {
        UUID serviceId = serviceRequestOperation.getServiceId();
        AbstractServiceRequest serviceRequest = serviceRequestOperation.getServiceRequest();
        this.getService(serviceId).postpersistRequest(serviceRequest);
    }

    private void startBlcs(UUID prevMasterId) {
        for (AbstractBusinessLogicComponent blc : this.blcMap.values()) {
            blc.restart(this, prevMasterId);
        }
    }

    protected DomainService getService(UUID serviceId) throws Exception {
        DomainService service = (DomainService)this.serviceMap.get(serviceId);
        if (service == null) {
            throw new Exception("Service is not registered: " + serviceId);
        }
        return service;
    }

    private void processLiveTransaction(BldTransaction transaction) throws Exception {
        try {
            for (AbstractBldTransactionOperation op : transaction) {
                if (op instanceof ServiceRequestOperation) {
                    this.handleServiceRequestOperation((ServiceRequestOperation)op);
                    continue;
                }
                if (op instanceof StartBlcOperation) {
                    this.handleStartBlcOperation((StartBlcOperation)op);
                    continue;
                }
                if (op instanceof DeleteBlcOperation) {
                    this.handleDeleteBlcOperation((DeleteBlcOperation)op);
                    continue;
                }
                if (op instanceof SaveBlcOperation) {
                    this.handleSaveBlcOperation((SaveBlcOperation)op);
                    continue;
                }
                if (op instanceof DequeueBlcEventOperation) continue;
                if (op instanceof QueueBlcEventOperation) {
                    this.handleQueueBlcEventOperation((QueueBlcEventOperation)op);
                    continue;
                }
                this.log(Level.SEVERE, "Unrecognized transaction operation: " + ((Object)((Object)op)).getClass());
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Exception while processing live transaction", e);
            try {
                this.log(Level.SEVERE, BldSerialization.objectToXml(transaction));
            }
            catch (Exception e2) {
                this.log(Level.SEVERE, "Unable to translate transaction to XML", e2);
            }
            throw e;
        }
    }

    @Override
    public void stopBlc(UUID blcId) {
        try {
            this.blcMap.remove(blcId);
            for (DomainService service : this.serviceMap.values()) {
                service.removeBlc(blcId);
            }
            if (this.blcMap.isEmpty()) {
                this.blcsStopped();
                this.transactionQueue.addFirst(new BldStopTransaction());
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not stop BLC: ", e);
        }
    }

    public static UUID readIdFile(String domainName) throws Exception {
        return SvaHelper.readIdFile(SvaConstants.SvaConfigPath + "/" + domainName + ".uuid");
    }

    private void handleServiceRequestOperation(ServiceRequestOperation op) {
        try {
            this.handlePostpersistentServiceRequest(op);
        }
        catch (Exception e) {
            String msg = "Could not queue service request: " + (Object)((Object)op);
            this.log(Level.SEVERE, msg, e);
            assert (false) : msg;
            SystemUtils.reboot(true, null, this);
        }
    }

    private void handleStartBlcOperation(StartBlcOperation op) {
        try {
            if (this.stopped) {
                String errMsg = "Cannot create new BLC when domain is stopped";
                assert (false) : errMsg;
                throw new Exception(errMsg);
            }
            AbstractBusinessLogicComponent blc = op.getBlc();
            this.blcMap.put(blc.getId(), blc);
            blc.queueEvent(new BlcStartEvent(blc.getId()));
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not start BLC", e);
        }
    }

    private void handleDeleteBlcOperation(DeleteBlcOperation op) {
        try {
            UUID blcId = op.getBlcId();
            AbstractBusinessLogicComponent blc = (AbstractBusinessLogicComponent)this.blcMap.get(blcId);
            if (blc == null) {
                String errorMsg = "Delete request for non-existent BLC";
                assert (false) : errorMsg;
                this.log(Level.SEVERE, errorMsg);
            } else {
                UUID parentBlcId = blc.getParentBlcId();
                this.blcMap.remove(blcId);
                for (DomainService service : this.serviceMap.values()) {
                    service.removeBlc(blcId);
                }
                if (parentBlcId != null) {
                    if (!this.blcMap.keySet().contains(parentBlcId)) {
                        String errorMsg = "Parent BLC does not exist";
                        assert (false) : errorMsg;
                        this.log(Level.SEVERE, errorMsg);
                    } else {
                        BlcChildTerminatedEvent event = new BlcChildTerminatedEvent(blcId);
                        this.queueLiveBlcEvent(parentBlcId, event);
                    }
                }
                if (this.blcMap.isEmpty()) {
                    this.blcsStopped();
                }
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not delete BLC: ", e);
        }
    }

    private void handleSaveBlcOperation(SaveBlcOperation op) {
        AbstractBusinessLogicComponent blc = op.getBlc();
        blc.blcSaved();
    }

    private void handleQueueBlcEventOperation(QueueBlcEventOperation op) {
        this.queueLiveBlcEvent(op.getBlcId(), op.getEvent());
    }

    public void setWatchdogService(WatchdogService watchdogService) {
        assert (SvaConstants.ENABLE_SYSTEM_WATCHDOG);
        this.watchdogService = watchdogService;
    }

    public WatchdogService getWatchdogService() {
        return this.watchdogService;
    }

    public UUID getBlcId(Class<?> cl) {
        for (AbstractBusinessLogicComponent blc : this.blcMap.values()) {
            if (!cl.isInstance(blc)) continue;
            return blc.getId();
        }
        return null;
    }
}

