/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld.ft;

import com.vmware.sva.blc.AbstractBlcEvent;
import com.vmware.sva.blc.AbstractBusinessLogicComponent;
import com.vmware.sva.bld.AbstractBldEvent;
import com.vmware.sva.bld.AbstractBldInformation;
import com.vmware.sva.bld.AbstractBldTransactionOperation;
import com.vmware.sva.bld.AbstractBusinessLogicDomain;
import com.vmware.sva.bld.BldEventWatcher;
import com.vmware.sva.bld.BldStopTransaction;
import com.vmware.sva.bld.BldTransaction;
import com.vmware.sva.bld.BldType;
import com.vmware.sva.bld.DeleteBlcOperation;
import com.vmware.sva.bld.DequeueBlcEventOperation;
import com.vmware.sva.bld.QueueBlcEventOperation;
import com.vmware.sva.bld.SaveBlcOperation;
import com.vmware.sva.bld.ServiceRequestOperation;
import com.vmware.sva.bld.StartBlcOperation;
import com.vmware.sva.bld.ft.FtBldDatabase;
import com.vmware.sva.bld.ft.FtBldRmiObject;
import com.vmware.sva.bld.ft.FtMessageService;
import com.vmware.sva.bld.ft.MasterGenerationInformation;
import com.vmware.sva.common.ReplicaInformation;
import com.vmware.sva.common.RmiUtilities;
import com.vmware.sva.common.StorageClusterConfig;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaVersion;
import com.vmware.sva.common.exceptions.WrongSvaVersionException;
import com.vmware.sva.services.blcevents.controlevent.BlcChildTerminatedEvent;
import com.vmware.sva.services.blcevents.controlevent.BlcStopEvent;
import com.vmware.sva.services.health.BldHealthWatcher;
import com.vmware.sva.services.health.HealthService;
import com.vmware.sva.services.logger.LoggerService;
import com.vmware.sva.services.shareddatabase.SharedObjectService;
import com.vmware.sva.util.SystemUtils;
import com.vmware.sva.zkservice.BldReplicaEvent;
import com.vmware.sva.zkservice.BldSvaVersionChangeEvent;
import com.vmware.sva.zkservice.BldTransactionsAvailableEvent;
import com.vmware.sva.zkservice.ZkClient;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

public abstract class AbstractFtBld
extends AbstractBusinessLogicDomain
implements Runnable,
BldEventWatcher,
BldHealthWatcher,
FtBldRmiObject {
    private final LoggerService loggerService;
    private final HealthService healthService;
    private final FtMessageService messageService;
    private final SharedObjectService sharedObjectService;
    private FtBldDatabase database = null;
    private final ZkClient zkClient;
    private final UUID svaId;
    private long generation = 0L;
    private boolean amMaster = false;
    private AbstractBusinessLogicComponent defaultBlc = null;
    private final InetAddress inetAddress;
    private static final long serialVersionUID = 1L;
    private transient boolean stopping = false;
    private static final long EXTRA_SESSION_EXPIRE_TIME = 1000L;
    private static final int CONCURRENT_FT_DOMAINS = 2;
    private static final transient CountDownLatch ftDomainsStartCountDown = new CountDownLatch(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFtBld(UUID svaId, UUID bldId, String name, InetAddress inetAddress) throws Exception {
        super(bldId, name);
        AbstractFtBld abstractFtBld = this;
        synchronized (abstractFtBld) {
            this.svaId = svaId;
            this.inetAddress = inetAddress;
            this.zkClient = new ZkClient(this.getSvaId(), this);
            this.database = new FtBldDatabase(bldId.toString());
            this.loggerService = new LoggerService(this);
            this.healthService = new HealthService(this, this.zkClient);
            this.messageService = new FtMessageService(this, this.zkClient);
            this.sharedObjectService = new SharedObjectService(this);
            this.database.commit();
            this.startRmi();
        }
    }

    @Override
    public synchronized void setDefaultBlc(AbstractBusinessLogicComponent blc) throws Exception {
        this.defaultBlc = blc;
    }

    @Override
    public BldType getType() {
        return BldType.FaultTolerant;
    }

    @Override
    public synchronized FtBldDatabase getDatabase() {
        return this.database;
    }

    protected abstract AbstractBldInformation getBldInformation();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitTransaction(BldTransaction transaction) {
        AbstractFtBld abstractFtBld = this;
        synchronized (abstractFtBld) {
            if (!this.amMaster) {
                this.log(Level.INFO, "BLD Transaction commit while not master of " + this.getName() + ": discarding transaction");
                this.setDomainOffline();
            } else {
                transaction.setGeneration(++this.generation);
                try {
                    this.zkClient.writeTransactionLog(transaction);
                }
                catch (Exception e) {
                    this.log(Level.INFO, "Could not persist BLD transaction in ZooKeeper for domain " + this.getName() + ": discarding transaction", e);
                    this.setDomainOffline();
                    return;
                }
                this.transactionQueue.add(transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleDomainOnline() {
        AbstractFtBld abstractFtBld = this;
        synchronized (abstractFtBld) {
            try {
                this.checkSvaVersion(true);
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "SVA version check failed", e);
                return false;
            }
            try {
                this.zkClient.createMessageQueue();
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Unable to create message queue in zookeeper", e);
                return false;
            }
            try {
                this.zkClient.createTransactionLog();
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Unable to create transaction log in zookeeper", e);
                return false;
            }
            if (!this.database.validate()) {
                this.log(Level.SEVERE, "Inconsistent database when domain " + this.getName() + " is coming online.  Get database from master.");
                if (!this.getDbFromMaster()) {
                    this.log(Level.SEVERE, "Domain " + this.getName() + " was unable to get database from master");
                    return false;
                }
            } else {
                try {
                    this.generation = this.database.getGeneration();
                    this.database.commit();
                }
                catch (Exception e) {
                    assert (false) : "Unable to recover BLD transactions from ZooKeeper log: " + e.getMessage();
                    this.log(Level.SEVERE, "Unable to recover BLD transactions from ZooKeeper log: " + e.getMessage());
                    return false;
                }
                try {
                    this.zkClient.updateGeneration(this.generation);
                }
                catch (Exception e) {
                    this.log(Level.SEVERE, "Unable to update generation number: " + e.getMessage());
                    return false;
                }
                if (!this.applyZkTransactions()) {
                    return false;
                }
                if (!this.database.validate()) {
                    this.log(Level.SEVERE, "Inconsistent database for domain " + this.getName() + " after applying ZK transactions.");
                    return false;
                }
                try {
                    this.zkClient.registerReplicaOnline(this);
                }
                catch (Exception e) {
                    this.log(Level.SEVERE, "Unable to register for replica online events: " + e.getMessage());
                    return false;
                }
            }
            ftDomainsStartCountDown.countDown();
            try {
                this.log(Level.INFO, "Waiting for all FT domain to come online");
                ftDomainsStartCountDown.await();
                this.log(Level.INFO, "FT domain finished coming online.");
            }
            catch (InterruptedException e) {
                String errmsg = "Domain interrupted while waiting for other domains to come online";
                assert (false) : errmsg;
                this.log(Level.SEVERE, errmsg);
                return false;
            }
            return true;
        }
    }

    @Override
    public boolean stopServices() {
        if (this.zkClient != null) {
            this.zkClient.forceOffline(false);
        }
        return super.stopServices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDomainOffline() {
        AbstractFtBld abstractFtBld = this;
        synchronized (abstractFtBld) {
            this.setDomainOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBldEvent(AbstractBldEvent bldEvent) {
        AbstractFtBld abstractFtBld = this;
        synchronized (abstractFtBld) {
            if (bldEvent instanceof BldReplicaEvent) {
                this.handleBldReplicaEvent((BldReplicaEvent)bldEvent);
            } else if (bldEvent instanceof BldTransactionsAvailableEvent) {
                this.handleBldTransactionsAvailableEvent();
            } else if (bldEvent instanceof BldSvaVersionChangeEvent) {
                this.handleBldSvaVersionChangeEvent();
            } else {
                this.log(Level.SEVERE, "Invalid BldEvent received by FtBld: " + bldEvent.getClass());
            }
        }
    }

    @Override
    public synchronized byte[] getDbContents() throws IOException, RemoteException, SQLException {
        return this.database.getDbContents();
    }

    @Override
    public synchronized boolean isMaster() {
        return this.amMaster;
    }

    protected UUID getSvaId() {
        return this.svaId;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @Override
    protected synchronized boolean startDomain() {
        try {
            this.stopping = false;
            this.healthService.registerBldHealthWatcher(this);
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Unable to register with health service: " + e.getMessage());
            return false;
        }
        return true;
    }

    protected boolean writeStorageClusterConfig(StorageClusterConfig storageClusterConfig) {
        try {
            this.zkClient.writeStorageClusterConfig(storageClusterConfig);
            return true;
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Unable to write storage cluster configuation to zookeeper", e);
            return false;
        }
    }

    protected StorageClusterConfig readStorageClusterConfig() {
        try {
            return this.zkClient.readStorageClusterConfig();
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Unable to read storage cluster configuation to zookeeper", e);
            return null;
        }
    }

    protected boolean isReconfigNetworkFlagSet() {
        try {
            return this.zkClient.isReconfigNetworkFlagSet();
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Error reading reconfig network flag from zookeeper.", e);
            return false;
        }
    }

    protected void clearReconfigNetworkFlag() {
        try {
            this.zkClient.clearReconfigNetworkFlag();
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Error reading reconfig network flag from zookeeper.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeDomain() {
        try {
            this.stopRmi();
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to stop RMI service in fault-tolerant domain: " + e.getMessage());
        }
        try {
            AbstractFtBld e = this;
            synchronized (e) {
                this.database.close();
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to close database: " + e.getMessage());
        }
        try {
            this.zkClient.close();
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to close zkClient: " + e.getMessage());
        }
    }

    @Override
    protected boolean stopDomain() {
        return true;
    }

    @Override
    protected synchronized void deleteDatabase() throws Exception {
        if (this.database != null) {
            this.database.delete();
            this.database = null;
        }
    }

    @Override
    protected synchronized void processPersistTransaction(BldTransaction transaction) {
        long transactionGeneration = transaction.getGeneration();
        this.log(Level.FINE, this.getName() + " starting processPersistTransaction generation=" + transactionGeneration);
        for (AbstractBldTransactionOperation op : transaction) {
            if (op instanceof ServiceRequestOperation) {
                this.handleServiceRequestOperation((ServiceRequestOperation)op, false);
                continue;
            }
            if (op instanceof StartBlcOperation) {
                this.handleStartBlcOperation((StartBlcOperation)op);
                continue;
            }
            if (op instanceof DeleteBlcOperation) {
                this.handleDeleteBlcOperation((DeleteBlcOperation)op);
                continue;
            }
            if (op instanceof DequeueBlcEventOperation) {
                this.handleDequeueBlcEventOperation((DequeueBlcEventOperation)op);
                continue;
            }
            if (op instanceof SaveBlcOperation) {
                this.handleSaveBlcOperation((SaveBlcOperation)op);
                continue;
            }
            if (op instanceof QueueBlcEventOperation) {
                this.handleQueueBlcEventOperation((QueueBlcEventOperation)op);
                continue;
            }
            this.log(Level.SEVERE, "Unrecognized transaction operation: " + ((Object)((Object)op)).getClass());
        }
        try {
            this.database.updateGeneration(transactionGeneration);
            try {
                this.database.commit();
                if (this.isMaster() && transactionGeneration % SvaConstants.ZK_MASTER_UPDATE_FREQUENCY == 0L) {
                    Map<UUID, Long> transmitSequenceNumberMap = this.messageService.getTransmitSequenceNumberMap();
                    this.zkClient.writeMasterGeneration(new MasterGenerationInformation(transactionGeneration, transmitSequenceNumberMap));
                }
                this.log(Level.FINE, this.getName() + " finished processPersistTransaction generation=" + transactionGeneration);
                try {
                    if (transactionGeneration % SvaConstants.ZK_GENERATION_UPDATE_FREQUENCY == 0L) {
                        this.zkClient.updateGeneration(transactionGeneration);
                        if (this.amMaster) {
                            try {
                                this.zkClient.truncateBldTransactionLog();
                            }
                            catch (Exception e) {
                                this.log(Level.SEVERE, "Exception while truncating ZooKeeper transaction log", e);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.log(Level.SEVERE, "Unable to update generation in ZooKeeper: Stopping local domain replica", e);
                    this.setDomainOffline();
                }
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Unable to update SQL database: " + e.getMessage());
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to update generation in SQL database: " + e.getMessage());
        }
    }

    private boolean reprocessPersistTransaction(BldTransaction transaction) {
        long transactionGeneration = transaction.getGeneration();
        this.log(Level.FINE, this.getName() + " starting reprocessPersistTransaction generation=" + transactionGeneration);
        for (AbstractBldTransactionOperation op : transaction) {
            this.log(Level.INFO, "Reprocessing " + (Object)((Object)op));
            if (op instanceof ServiceRequestOperation) {
                this.handleServiceRequestOperation((ServiceRequestOperation)op, true);
                continue;
            }
            if (op instanceof StartBlcOperation || op instanceof DeleteBlcOperation || op instanceof DequeueBlcEventOperation || op instanceof SaveBlcOperation || op instanceof QueueBlcEventOperation) continue;
            this.log(Level.SEVERE, "Unrecognized transaction operation: " + ((Object)((Object)op)).getClass());
        }
        try {
            if (transactionGeneration % SvaConstants.ZK_MASTER_UPDATE_FREQUENCY == 0L) {
                Map<UUID, Long> transmitSequenceNumberMap = this.messageService.getTransmitSequenceNumberMap();
                this.zkClient.writeMasterGeneration(new MasterGenerationInformation(transactionGeneration, transmitSequenceNumberMap));
            }
            this.log(Level.FINE, this.getName() + " finished reprocessPersistTransaction generation=" + transactionGeneration);
            return true;
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "failed to write master generation information", e);
            return false;
        }
    }

    private void handleServiceRequestOperation(ServiceRequestOperation op, boolean reprocessing) {
        try {
            this.handlePersistentServiceRequest(op, reprocessing);
        }
        catch (Exception e) {
            String msg = "Could not persist service request";
            this.log(Level.SEVERE, msg, e);
            assert (false) : msg;
            SystemUtils.reboot(true, null, this);
        }
    }

    private void handleStartBlcOperation(StartBlcOperation op) {
        try {
            this.database.addBlc(op.getBlc());
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not persist created BLC: " + e.getMessage());
        }
    }

    private void handleDeleteBlcOperation(DeleteBlcOperation op) {
        try {
            UUID blcId = op.getBlcId();
            AbstractBusinessLogicComponent blc = this.database.getBlc(blcId);
            if (blc == null) {
                String errorMsg = "Attempt to delete a non-existent BLC in " + this.getName();
                assert (false) : errorMsg;
                this.log(Level.SEVERE, errorMsg);
            } else {
                UUID parentBlcId = blc.getParentBlcId();
                this.database.deleteBlc(blcId);
                if (parentBlcId != null) {
                    if (this.database.getBlc(parentBlcId) == null) {
                        String errorMsg = "Parent of deleted BLC does not exist";
                        assert (false) : errorMsg;
                        this.log(Level.SEVERE, errorMsg);
                    }
                    BlcChildTerminatedEvent event = new BlcChildTerminatedEvent(blcId);
                    this.database.addBlcEvent(parentBlcId, event);
                }
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not delete BLC: " + e.getMessage());
        }
    }

    private void handleQueueBlcEventOperation(QueueBlcEventOperation op) {
        try {
            UUID blcId;
            AbstractBlcEvent event = op.getEvent();
            if (event.getPersistent() && !this.database.addBlcEvent(blcId = op.getBlcId(), event)) {
                this.handleUndeliveredBlcEvent(blcId, event, true);
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not persist BLC event: " + e.getMessage());
        }
    }

    private void handleDequeueBlcEventOperation(DequeueBlcEventOperation op) {
        UUID blcId = op.getBlcId();
        try {
            this.database.removeBlcEvent(blcId, op.getEventId());
        }
        catch (Exception e) {
            String msg = "Could not dequeue BLC event for BLC " + blcId;
            this.log(Level.SEVERE, msg, e);
            assert (false) : msg;
        }
        catch (AssertionError e) {
            this.log(Level.SEVERE, "Could not dequeue BLC event for BLC " + blcId, (Throwable)((Object)e));
            throw e;
        }
    }

    private void handleSaveBlcOperation(SaveBlcOperation op) {
        try {
            this.database.updateBlc(op.getBlc());
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Could not save BLC: " + e.getMessage());
        }
    }

    private FtBldRmiObject getFtdBldRmi(InetAddress inetAddress) throws RemoteException, NotBoundException {
        return (FtBldRmiObject)RmiUtilities.getRemoteObject((InetAddress)inetAddress, (String)this.getId().toString());
    }

    private void startRmi() throws RemoteException {
        this.log(Level.FINE, "exporting " + this.getId().toString());
        RmiUtilities.exportObject((String)this.getId().toString(), (Remote)this);
    }

    private void stopRmi() throws RemoteException, NotBoundException {
        RmiUtilities.unexportObject((String)this.getId().toString(), (Remote)this);
    }

    private boolean applyZkTransactions() {
        block9: {
            try {
                assert (this.generation == this.database.getGeneration()) : "Generation " + this.generation + " is out-of-date with database generation " + this.database.getGeneration();
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError((Object)("Unexpected exception: " + e));
            }
        }
        List<Long> transactions = null;
        try {
            transactions = this.zkClient.getTransactionList(this);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to retrieve BLD transactions from ZooKeeper log: " + e.getMessage());
            return false;
        }
        for (long g : transactions) {
            if (g == this.generation + 1L) {
                BldTransaction transaction = null;
                try {
                    transaction = this.zkClient.getTransaction(g);
                    ++this.generation;
                }
                catch (Exception e) {
                    this.log(Level.SEVERE, "Unable to retrieve BLD transaction " + g + " from ZooKeeper log: " + e.getMessage());
                    return false;
                }
                this.processPersistTransaction(transaction);
                continue;
            }
            if (g <= this.generation) continue;
            this.log(Level.WARNING, "Unable to recover BLD transaction " + this.generation + " from ZooKeeper log");
            return this.getDbFromMaster();
        }
        return true;
    }

    private boolean reapplyZkTransactions(long masterGeneration) {
        List<Long> transactions = null;
        try {
            transactions = this.zkClient.getTransactionList(this);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to retrieve BLD transactions from ZooKeeper log", e);
            return false;
        }
        for (long g : transactions) {
            this.log(Level.INFO, this.getName() + " master generation=" + masterGeneration);
            if (g <= masterGeneration) {
                this.log(Level.INFO, this.getName() + " skipping transaction=" + g);
                continue;
            }
            if (g == masterGeneration + 1L) {
                this.log(Level.INFO, this.getName() + " reapplying transaction=" + g + " from zookeeper");
                BldTransaction transaction = null;
                try {
                    transaction = this.zkClient.getTransaction(g);
                }
                catch (Exception e) {
                    this.log(Level.SEVERE, "Unable to retrieve BLD transaction " + g + " from ZooKeeper log: " + e.getMessage());
                    return false;
                }
                if (!this.reprocessPersistTransaction(transaction)) {
                    this.log(Level.SEVERE, "Failed to reprocess transaction " + g + " from zookeeper log");
                    return false;
                }
                ++masterGeneration;
                continue;
            }
            this.log(Level.SEVERE, "missing transaction " + masterGeneration + " from ZooKeeper log");
            return false;
        }
        return true;
    }

    private boolean getDbFromMaster() {
        int retries = SvaConstants.FT_MAX_GET_DB_CONTENT_RETRIES;
        while (true) {
            this.log(Level.INFO, "Requesting copy of the database from the master");
            UUID masterId = this.zkClient.getMasterId(false);
            if (masterId == null) {
                this.log(Level.INFO, "Unable to get master ID: cluster is offline");
            } else {
                try {
                    ReplicaInformation masterInformation = this.zkClient.getReplicaInformation(masterId);
                    if (masterInformation == null) {
                        this.log(Level.WARNING, "unable to get master replica information from master: " + masterId);
                    } else {
                        byte[] dbContents = this.getFtdBldRmi(masterInformation.getSvaAddress()).getDbContents();
                        if (this.database.reloadContents(dbContents)) {
                            this.generation = this.database.getGeneration();
                            this.database.commit();
                            return this.applyZkTransactions();
                        }
                    }
                }
                catch (Exception e) {
                    this.log(Level.WARNING, "Unable to get DB contents from master:" + masterId, e);
                }
            }
            if (retries-- <= 0) break;
            this.log(Level.WARNING, "Waiting to retry contacting domain master");
            try {
                Thread.sleep(SvaConstants.FT_MAX_GET_DB_CONTENT_DELAY);
            }
            catch (InterruptedException e) {
                this.log(Level.SEVERE, "Interrupted while waiting to retry database retrieval", e);
            }
        }
        this.log(Level.SEVERE, "Timed out wait to get database from domain master");
        return false;
    }

    private void setDomainOffline() {
        if (!this.stopping) {
            this.stopping = true;
            this.amMaster = false;
            this.zkClient.forceOffline(true);
            if (this.blcMap.isEmpty()) {
                this.blcsStopped();
                this.transactionQueue.addFirst(new BldStopTransaction());
            } else {
                for (AbstractBusinessLogicComponent blc : this.blcMap.values()) {
                    blc.queueEvent(new BlcStopEvent());
                }
            }
        }
    }

    @Override
    protected void startReplica(UUID prevMasterId) throws Exception {
        super.startReplica(prevMasterId);
    }

    protected void replicaNotElected(UUID masterId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"}, justification="Need to wait without giving up lock")
    private void handleBldReplicaEvent(BldReplicaEvent bldEvent) {
        AbstractFtBld abstractFtBld = this;
        synchronized (abstractFtBld) {
            if (!bldEvent.getOnline()) {
                this.handleDomainOffline();
            } else {
                try {
                    this.zkClient.writeReplicaInfo(this.svaId, new ReplicaInformation(this.svaId, this.inetAddress));
                }
                catch (Exception e) {
                    this.log(Level.WARNING, "Unable to write replica information", e);
                    return;
                }
                if (bldEvent.getMaster()) {
                    if (!this.amMaster) {
                        try {
                            if (!this.database.validate()) {
                                this.log(Level.SEVERE, "Database inconsistent when trying to become master before apply transactions from ZK.  Going offline");
                                this.setDomainOffline();
                                return;
                            }
                            this.zkClient.waitForOldSessionToExpire();
                            if (!this.applyZkTransactions()) {
                                this.log(Level.SEVERE, "Unable to bring local database up to date");
                                this.setDomainOffline();
                                return;
                            }
                            if (!this.database.validate()) {
                                this.log(Level.SEVERE, "Database inconsistent when trying to become master after apply transactions from ZK.  Going offline");
                                this.setDomainOffline();
                                return;
                            }
                            try {
                                this.messageService.restoreFromPersistent();
                            }
                            catch (Exception e) {
                                this.log(Level.SEVERE, "Unable to restore message service state", e);
                                this.setDomainOffline();
                                return;
                            }
                            if (!this.reapplyOldMasterTransactions()) {
                                this.setDomainOffline();
                                return;
                            }
                            for (AbstractBusinessLogicComponent blc : this.database.getBlcList()) {
                                UUID blcId = blc.getId();
                                this.blcMap.put(blcId, blc);
                                List<AbstractBlcEvent> events = this.database.getBlcEventQueue(blcId);
                                this.log(Level.INFO, "Recovering " + events.size() + " events for " + blc.getName());
                                blc.setEventQueue(events);
                            }
                        }
                        catch (Exception e) {
                            String errMsg = "Failed to recover BLCs from the database: " + e.getMessage();
                            assert (false) : errMsg;
                            this.log(Level.SEVERE, errMsg, e);
                            this.setDomainOffline();
                            return;
                        }
                        try {
                            UUID prevMasterId = bldEvent.getPrevMasterId();
                            if (prevMasterId == null) {
                                Thread.sleep((long)SvaConstants.ZK_CLIENT_SESSION_TIMEOUT + 1000L);
                            }
                            this.startReplica(prevMasterId);
                        }
                        catch (Exception e) {
                            this.log(Level.SEVERE, "Unable to start replica", e);
                            this.setDomainOffline();
                            return;
                        }
                        this.amMaster = true;
                        try {
                            if (this.generation == 0L && this.defaultBlc != null) {
                                BldTransaction transaction = new BldTransaction();
                                transaction.add(new StartBlcOperation(this.defaultBlc));
                                this.commitTransaction(transaction);
                                this.defaultBlc.restart(this, null);
                                this.defaultBlc = null;
                            }
                            this.messageService.startCheckingForMessages();
                            this.zkClient.updateBldInformation(this.getBldInformation());
                        }
                        catch (Exception e) {
                            this.log(Level.SEVERE, "Could not bring FT BLD online.  Rebooting", e);
                            SystemUtils.reboot(true, null, this);
                        }
                    }
                } else {
                    MasterGenerationInformation masterGeneration;
                    try {
                        masterGeneration = this.zkClient.readMasterGeneration();
                    }
                    catch (Exception e) {
                        this.log(Level.SEVERE, "Non-master unable to get master generation information", e);
                        this.setDomainOffline();
                        return;
                    }
                    if (masterGeneration.getGeneration() > 0L) {
                        this.database.deleteTransmitSequenceNumberTable();
                    }
                    this.replicaNotElected(this.zkClient.getMasterId(true));
                }
            }
        }
    }

    private boolean reapplyOldMasterTransactions() {
        try {
            Map<UUID, Long> transmitSequenceNumberMap;
            MasterGenerationInformation masterGeneration = this.zkClient.readMasterGeneration();
            this.log(Level.INFO, "Master generation is " + masterGeneration.getGeneration());
            if (masterGeneration.isUpgrade()) {
                this.log(Level.INFO, "Found UPGRADE MasterGenerationInformation. Writing new object");
                try {
                    transmitSequenceNumberMap = this.database.getTransmitSequenceNumberTable();
                }
                catch (Exception e) {
                    this.log(Level.SEVERE, "Unable to get the transmit sequence number table to write to zookeeper", e);
                    this.setDomainOffline();
                    return false;
                }
                try {
                    masterGeneration = new MasterGenerationInformation(this.generation, transmitSequenceNumberMap);
                    this.zkClient.writeMasterGeneration(masterGeneration);
                }
                catch (Exception e) {
                    this.log(Level.SEVERE, "Unable to write MasterGenerationInformation to zookeeper", e);
                    this.setDomainOffline();
                    return false;
                }
                this.database.deleteTransmitSequenceNumberTable();
            }
            transmitSequenceNumberMap = masterGeneration.getTransmitSequenceNumberMap();
            this.messageService.setTransmitSequenceNumberMap(transmitSequenceNumberMap);
            if (!this.reapplyZkTransactions(masterGeneration.getGeneration())) {
                this.setDomainOffline();
                return false;
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to read master generation number", e);
            this.setDomainOffline();
            return false;
        }
        return true;
    }

    private void handleBldTransactionsAvailableEvent() {
        if (!this.amMaster && !this.applyZkTransactions()) {
            this.handleDomainOffline();
        }
    }

    private synchronized void handleBldSvaVersionChangeEvent() {
        try {
            this.checkSvaVersion(false);
        }
        catch (WrongSvaVersionException e) {
            this.log(Level.SEVERE, "SVA version changed incompatibly: " + e.getMessage(), e);
            this.setDomainOffline();
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Problem checking SVA version: " + e.getMessage(), e);
            this.setDomainOffline();
        }
    }

    private void checkSvaVersion(boolean watch) throws Exception {
        String stored = watch ? this.zkClient.getSvaVersion(this) : this.zkClient.getSvaVersion();
        String current = SvaVersion.getVersion();
        if (!current.equals(stored)) {
            throw new WrongSvaVersionException(this.svaId, current, stored);
        }
    }

    public SharedObjectService getSharedObjectService() {
        return this.sharedObjectService;
    }

    public LoggerService getLoggerService() {
        return this.loggerService;
    }

    @Override
    public UUID getBldInstantiationId(UUID bldId) {
        return this.zkClient.getBldInstantiationId(bldId);
    }
}

