/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld.ft;

import com.vmware.sva.bld.BldException;
import com.vmware.sva.bld.BldSerialization;
import com.vmware.sva.bld.ft.ReceiveSeqNumDbTable;
import com.vmware.sva.bld.ft.TransmitSeqNumDbTable;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.database.AbstractPersistentBldDatabase;
import com.vmware.sva.database.GenerationDbTable;
import com.vmware.sva.database.VersionDbTable;
import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public class FtBldDatabase
extends AbstractPersistentBldDatabase {
    private static final String DERBY_DIRECTORY_EXISTS_SQL_STATE = "XBM0J";
    private GenerationDbTable generationTable;
    protected ReceiveSeqNumDbTable receiveSeqNumTable;

    public FtBldDatabase(String dbName) throws Exception {
        super(dbName);
    }

    @Override
    protected void initializeTables(boolean restore) throws Exception {
        boolean corrupted = false;
        try {
            super.initializeTables(restore);
        }
        catch (SQLException e) {
            if (!restore && FtBldDatabase.databaseCorruptedException(e)) {
                this.log(Level.WARNING, "Database appears to be corrupted, will delete and recreate", e);
                corrupted = true;
                this.delete();
                super.initializeTables(false);
            }
            throw e;
        }
        this.generationTable = new GenerationDbTable(this.connection);
        if (corrupted) {
            this.updateGeneration(-1L);
        }
        this.receiveSeqNumTable = new ReceiveSeqNumDbTable(this.connection);
    }

    private static boolean databaseCorruptedException(SQLException exception) {
        do {
            if (!DERBY_DIRECTORY_EXISTS_SQL_STATE.equals(exception.getSQLState())) continue;
            return true;
        } while ((exception = exception.getNextException()) != null);
        return false;
    }

    public long getGeneration() throws BldException, SQLException {
        return this.generationTable.getGeneration();
    }

    public void updateGeneration(long generation) throws SQLException, IOException {
        this.generationTable.updateGeneration(generation);
    }

    @Override
    public void setDatabaseCorrupt() throws SQLException, IOException {
        this.updateGeneration(-1L);
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getDbContents() throws IOException, SQLException {
        File backupPathFile = new File(DB_BACKUP_PATH);
        if (!backupPathFile.exists() && !backupPathFile.mkdirs()) {
            this.log(Level.SEVERE, "Could not create " + DB_BACKUP_PATH);
        }
        CallableStatement cs = this.connection.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        try {
            cs.setString(1, DB_BACKUP_PATH);
            cs.execute();
        }
        finally {
            cs.close();
        }
        return BldSerialization.ZipFiles(DB_BACKUP_PATH, this.dbName + ".db");
    }

    public long getReceiveSeqNum(UUID bldId) {
        return this.receiveSeqNumTable.getSeqNum(bldId);
    }

    public void setReceiveSeqNumTable(UUID bldId, long seqNum) throws SQLException {
        this.receiveSeqNumTable.setSeqNum(bldId, seqNum);
    }

    public Map<UUID, Long> getReceiveSeqNumMap() throws Exception {
        return this.receiveSeqNumTable.getSeqNumMap();
    }

    @Override
    protected void upgradeTables() throws Exception {
        super.upgradeTables();
        VersionDbTable versionTable = this.getVersionTable();
        this.generationTable.upgrade(versionTable);
        this.receiveSeqNumTable.upgrade(versionTable);
    }

    public Map<UUID, Long> getTransmitSequenceNumberTable() throws Exception {
        return TransmitSeqNumDbTable.getSeqNumMap(this.connection);
    }

    public void deleteTransmitSequenceNumberTable() {
        try {
            TransmitSeqNumDbTable.deleteTable(this.connection);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Failed to delete transmit sequence number table from " + this.dbName, e);
        }
    }

    @Override
    public boolean validate() {
        if (SvaConstants.DISABLE_DATABASE_VALIDATION) {
            return true;
        }
        if (!super.validate()) {
            return false;
        }
        if (!this.generationTable.validate()) {
            return false;
        }
        return this.receiveSeqNumTable.validate();
    }
}

