/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld.nonpersistent;

import com.vmware.sva.bld.BldException;
import com.vmware.sva.bld.ft.TransmitSeqNumDbTable;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.database.AbstractBldDatabase;
import com.vmware.sva.database.GenerationDbTable;
import com.vmware.sva.database.VersionDbTable;
import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;

public class NonPersistentBldDatabase
extends AbstractBldDatabase {
    protected TransmitSeqNumDbTable transmitSeqNumTable;
    private GenerationDbTable generationTable;

    public NonPersistentBldDatabase(String dbName) throws Exception {
        super(dbName);
    }

    @Override
    protected void initializeTables(boolean restore) throws Exception {
        super.initializeTables(restore);
        this.transmitSeqNumTable = new TransmitSeqNumDbTable(this.connection);
        this.generationTable = new GenerationDbTable(this.connection);
    }

    public long getTransmitSeqNum(UUID bldId) {
        return this.transmitSeqNumTable.getSeqNum(bldId);
    }

    public boolean hasTransmitSeqNum(UUID bldId) {
        return this.transmitSeqNumTable.hasSeqNum(bldId);
    }

    public long nextTransmitSeqNum(UUID bldId) throws SQLException {
        return this.transmitSeqNumTable.nextSeqNum(bldId);
    }

    public long getGeneration() throws BldException, SQLException {
        return this.generationTable.getGeneration();
    }

    public void updateGeneration(long generation) throws SQLException, IOException {
        this.generationTable.updateGeneration(generation);
    }

    @Override
    protected void upgradeTables() throws Exception {
        super.upgradeTables();
        VersionDbTable versionTable = this.getVersionTable();
        this.transmitSeqNumTable.upgrade(versionTable);
        this.generationTable.upgrade(versionTable);
    }

    @Override
    public boolean validate() {
        if (SvaConstants.DISABLE_DATABASE_VALIDATION) {
            return true;
        }
        if (!super.validate()) {
            return false;
        }
        if (!this.transmitSeqNumTable.validate()) {
            return false;
        }
        return this.generationTable.validate();
    }
}

