/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.bld.persistent;

import com.vmware.sva.bld.BldTransaction;
import com.vmware.sva.bld.persistent.BldTransactionLogDbTable;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.database.AbstractPersistentBldDatabase;
import com.vmware.sva.util.LoggerAdapter;
import com.vmware.sva.util.SystemUtils;
import java.sql.SQLException;
import java.util.List;

public class PersistentBldDatabase
extends AbstractPersistentBldDatabase {
    private BldTransactionLogDbTable transactionLogTable;

    public PersistentBldDatabase(String dbName) throws Exception {
        super(dbName);
    }

    public void addTransaction(BldTransaction transaction) throws Exception {
        this.transactionLogTable.addTransaction(transaction);
    }

    public void removeTransaction() throws SQLException {
        this.transactionLogTable.removeTransaction();
    }

    public List<BldTransaction> getTransactions() throws Exception {
        return this.transactionLogTable.getTransactions();
    }

    @Override
    protected void initializeTables(boolean restore) throws Exception {
        super.initializeTables(restore);
        this.transactionLogTable = new BldTransactionLogDbTable(this.connection, this);
    }

    @Override
    protected void upgradeTables() throws Exception {
        super.upgradeTables();
        this.transactionLogTable.upgrade(this.getVersionTable());
    }

    @Override
    public boolean validate() {
        if (SvaConstants.DISABLE_DATABASE_VALIDATION) {
            return true;
        }
        if (!super.validate()) {
            return false;
        }
        return this.transactionLogTable.validate();
    }

    @Override
    public void setDatabaseCorrupt() {
        SystemUtils.reboot(true, null, new LoggerAdapter(logger));
    }
}

