/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.database;

import com.vmware.sva.common.SerialGeneration;
import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaDebug;
import com.vmware.sva.common.SvaVersion;
import com.vmware.sva.database.VersionDbTable;
import com.vmware.sva.util.BasicLoggerInterface;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class AbstractBldDatabase
implements BasicLoggerInterface {
    protected static final String DB_PATH = SvaConstants.SvaConfigPath + "/databases";
    protected static final String DB_BACKUP_PATH = SvaConstants.SvaConfigPath + "/backup_databases";
    protected String dbPath;
    protected String dbName;
    protected Connection connection = null;
    private VersionDbTable versionTable;
    protected static final Logger logger = Logger.getLogger(AbstractBldDatabase.class.getName());

    public AbstractBldDatabase(String dbName) throws Exception {
        this.dbName = dbName;
        SvaConstants.createPath((String)DB_PATH);
        this.dbPath = DB_PATH + "/" + dbName + ".db";
        this.initializeTables(false);
        this.maybeUpgradeTables();
        this.connection.commit();
    }

    public boolean validate() {
        this.log(Level.INFO, "Validating database " + this.dbName);
        return this.versionTable.validate();
    }

    public String getDbName() {
        return this.dbName;
    }

    public void commit() throws SQLException {
        this.connection.commit();
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.rollback();
            this.connection.close();
            this.connection = null;
            try {
                Connection closeConnection = DriverManager.getConnection("jdbc:derby:" + this.dbPath + ";shutdown=true");
                closeConnection.close();
            }
            catch (Exception e) {
                this.log(Level.INFO, e.getMessage());
            }
        }
    }

    public void delete() throws Exception {
        if (this.connection != null) {
            throw new Exception("Cannot delete database with open connection");
        }
        File dbFile = new File(this.dbPath);
        this.deleteTree(dbFile);
    }

    protected void initializeTables(boolean restore) throws Exception {
        if (restore) {
            String fromDB = DB_BACKUP_PATH + "/" + this.dbName + ".db";
            logger.log(Level.INFO, "Restoring connection to " + this.dbPath + " from " + fromDB);
            this.connection = DriverManager.getConnection("jdbc:derby:" + this.dbPath + ";restoreFrom=" + fromDB);
        } else {
            int attempts = 2;
            while (attempts-- > 0) {
                logger.log(Level.INFO, "Creating connection to " + this.dbPath + " attempts remaining " + attempts);
                try {
                    this.connection = DriverManager.getConnection("jdbc:derby:" + this.dbPath + ";create=true");
                    this.recordDBCreate(this.dbPath);
                    break;
                }
                catch (SQLException e) {
                    if (attempts > 0) {
                        this.handleSQLException(e);
                        continue;
                    }
                    throw e;
                }
            }
        }
        this.connection.setAutoCommit(false);
        this.versionTable = new VersionDbTable(this.connection);
        this.checkDowngrade();
    }

    private void checkDowngrade() throws Exception {
        String current;
        String stored = this.versionTable.getSerialGenerationVersion();
        int compare = SvaVersion.compareVersions((String)stored, (String)(current = SerialGeneration.getCurrent().getVersionString()));
        if (compare > 0) {
            String message = "Attempt to downgrade database from version " + stored + " to version " + current + " -- node may need to be replaced";
            logger.log(Level.SEVERE, message);
            throw new Exception(message);
        }
    }

    protected void maybeUpgradeTables() throws Exception {
        if (this.shouldUpgradeTables()) {
            this.upgradeTables();
            this.upgradeTablesCompleted();
        }
    }

    protected boolean shouldUpgradeTables() throws Exception {
        String current;
        String stored = this.versionTable.getSerialGenerationVersion();
        int compare = SvaVersion.compareVersions((String)stored, (String)(current = SerialGeneration.getCurrent().getVersionString()));
        if (compare == 0) {
            return SvaDebug.FORCE_UPGRADE;
        }
        assert (compare < 0) : "Downgrade not permitted";
        logger.log(Level.INFO, this.getClass().getName() + ": Database version " + stored + " differs from current version " + current);
        return true;
    }

    protected void upgradeTables() throws Exception {
        this.versionTable.upgrade(this.versionTable);
    }

    protected void upgradeTablesCompleted() throws Exception {
        this.versionTable.setSerialGenerationVersion();
        logger.log(Level.INFO, this.getClass().getName() + ": Completed upgrade");
    }

    @Override
    public void log(LogRecord logRecord) {
        logger.log(logRecord);
    }

    @Override
    public void log(Level level, String message) {
        logger.log(level, message);
    }

    @Override
    public void log(Level level, String msg, Throwable exception) {
        logger.log(level, msg, exception);
    }

    protected void deleteTree(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.deleteTree(child);
            }
        }
        if (!file.delete()) {
            this.log(Level.SEVERE, "Could not delete " + file.getPath());
        }
    }

    protected VersionDbTable getVersionTable() {
        return this.versionTable;
    }

    public static String[] getDatabasePaths() {
        String[] s = new String[]{DB_PATH, DB_BACKUP_PATH};
        return s;
    }

    private void handleSQLException(SQLException exp) throws Exception {
        logger.log(Level.FINE, "In handleSQLException " + exp.getMessage());
        if (exp.getMessage().toLowerCase().contains("Failed to create database".toLowerCase())) {
            Throwable e = exp.getCause().getCause();
            logger.log(Level.FINE, "Cause is " + e.getMessage());
            if (!e.getMessage().toLowerCase().contains("already exists".toLowerCase()) || new File(SvaConstants.DB_CREATE_DONE_FILE).exists()) {
                throw exp;
            }
        } else {
            throw exp;
        }
        logger.log(Level.INFO, "Deleting database since preivous attempt of creating the database was incomplete");
        this.delete();
    }

    private void recordDBCreate(String path) throws IOException {
        String name = path + "/" + SvaConstants.DB_CREATE_DONE_FILE;
        File f = new File(name);
        try {
            f.createNewFile();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to create " + name, e);
            throw e;
        }
    }
}

