/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.database;

import com.vmware.sva.bld.BldException;
import com.vmware.sva.common.SerialGeneration;
import com.vmware.sva.database.AbstractDbTable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.logging.Level;

public class VersionDbTable
extends AbstractDbTable {
    public static final String SERIAL_GENERATION_KEY = "SERIAL_GENERATION";
    private static final String DB_TABLE_NAME = "VERSION_TABLE";
    private static final String DB_TABLE_COLUMNS = "(name VARCHAR(255), data LONG VARCHAR)";

    public VersionDbTable(Connection connection) throws SQLException, BldException {
        super(connection, DB_TABLE_NAME, DB_TABLE_COLUMNS);
    }

    @Override
    protected void createTable() throws SQLException, BldException {
        super.createTable();
        String storedVersion = this.getVersion(SERIAL_GENERATION_KEY);
        if (storedVersion == null) {
            this.setSerialGenerationVersion();
        }
    }

    public String getSerialGenerationVersion() throws SQLException {
        return this.getVersion(SERIAL_GENERATION_KEY);
    }

    public void setSerialGenerationVersion() throws SQLException, BldException {
        this.setVersion(SERIAL_GENERATION_KEY, SerialGeneration.getCurrent().getVersionString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion(String key) throws SQLException {
        Statement statement = this.connection.createStatement();
        try {
            ResultSet rs = statement.executeQuery(String.format("SELECT data FROM \"%s\" WHERE name = '%s'", this.tableName, key));
            if (!rs.next()) {
                String string = null;
                return string;
            }
            String result = rs.getString("data");
            if (rs.next()) {
                this.log(Level.SEVERE, "Multiple records found for DB object");
            }
            String string = result;
            return string;
        }
        finally {
            statement.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate() {
        this.log(Level.FINE, "Validating database table " + this.tableName);
        try {
            Statement statement = this.connection.createStatement();
            try {
                ResultSet rs = statement.executeQuery("SELECT * FROM \"" + this.tableName + "\"");
                HashSet<String> keys = new HashSet<String>();
                while (rs.next()) {
                    String key = rs.getString("name");
                    if (keys.contains(key)) {
                        throw new Exception("Duplicate key \"" + key + "\" found in " + this.tableName);
                    }
                    keys.add(key);
                    rs.getString("data");
                    this.log(Level.FINE, "version " + key + " is valid");
                }
            }
            finally {
                statement.close();
            }
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to validate table " + this.tableName, e);
            return false;
        }
        this.log(Level.FINE, "Database table " + this.tableName + " is valid");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVersion(String key, String value) throws BldException, SQLException {
        Statement statement = this.connection.createStatement();
        try {
            if (this.getCount(key) == 0L) {
                statement.execute(String.format("INSERT INTO \"%s\" VALUES('%s','%s')", this.tableName, key, value));
            } else {
                statement.execute(String.format("UPDATE \"%s\" SET data = '%s' WHERE name = '%s'", this.tableName, value, key));
            }
        }
        finally {
            statement.close();
        }
    }

    @Override
    public void upgrade(VersionDbTable versionTable) {
    }
}

