/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.domainservice;

import com.vmware.sva.bld.BldType;
import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.domainservice.AbstractDomainService;
import com.vmware.sva.domainservice.AbstractServiceEvent;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.domainservice.UndeliveredServiceEvent;
import java.util.UUID;
import java.util.logging.Level;

public abstract class AbstractSyncService
extends AbstractDomainService {
    private static final long serialVersionUID = 1L;

    public AbstractSyncService(UUID id, String name, BusinessLogicDomainServiceAPI domain) throws Exception {
        super(id, name, domain);
    }

    @Override
    public void persistRequest(AbstractServiceRequest request) {
        if (request instanceof UndeliveredServiceEvent) {
            if (this.domain.getType() != BldType.Nonpersistent) {
                UndeliveredServiceEvent undeliveredServiceEvent = (UndeliveredServiceEvent)request;
                AbstractServiceEvent origEvent = undeliveredServiceEvent.getOrigEvent();
                this.log(Level.WARNING, "Event from service " + this.getName() + " (" + this.getId().toString() + ") was returned as undelivered: " + ((Object)((Object)origEvent)).toString());
            }
        } else {
            this.log(Level.SEVERE, "SyncService cannot handle asynchronous requests");
        }
    }

    @Override
    public void postpersistRequest(AbstractServiceRequest request) {
        if (request instanceof UndeliveredServiceEvent) {
            if (this.domain.getType() == BldType.Nonpersistent) {
                UndeliveredServiceEvent undeliveredServiceEvent = (UndeliveredServiceEvent)request;
                AbstractServiceEvent origEvent = undeliveredServiceEvent.getOrigEvent();
                this.log(Level.WARNING, "Event from service " + this.getName() + " (" + this.getId().toString() + ") was returned as undelivered: " + ((Object)((Object)origEvent)).toString());
            }
        } else {
            this.log(Level.SEVERE, "SyncService cannot handle asynchronous requests");
        }
    }
}

