/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.services.blcevents;

import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.domainservice.AbstractServiceEvent;
import com.vmware.sva.services.blcevents.BlcEventAddressInfo;
import java.util.UUID;

public abstract class AbstractBlcMessage
extends AbstractServiceEvent {
    private static final long serialVersionUID = 1L;
    private BlcEventAddressInfo header;
    private long sequenceNumber;
    private UUID bldInstantiationId = null;

    public AbstractBlcMessage() {
        super(true, SvaConstants.MESSAGE_SERVICE_ID);
        this.header = null;
    }

    public AbstractBlcMessage(BlcEventAddressInfo header) {
        super(true, SvaConstants.MESSAGE_SERVICE_ID);
        this.header = header;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public BlcEventAddressInfo getHeader() {
        return this.header;
    }

    public void setHeader(BlcEventAddressInfo header) {
        this.header = header;
    }

    public boolean isDestinationLocal(UUID localBldId) {
        return this.getHeader().getDestinationBld().equals(localBldId) || this.getHeader().getDestinationBld().equals(SvaConstants.DefaultUUID);
    }

    public boolean isSourceLocal(UUID localBldId) {
        return this.getHeader().getSourceBld().equals(localBldId) || this.getHeader().getSourceBld().equals(SvaConstants.DefaultUUID);
    }

    public void setBldInstantiationId(UUID bldInstantiationId) {
        this.bldInstantiationId = bldInstantiationId;
    }

    public UUID getBldInstantiationId() {
        return this.bldInstantiationId;
    }
}

