/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.services.shareddatabase;

import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.database.AbstractPersistentBldDatabase;
import com.vmware.sva.domainservice.AbstractDomainService;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.domainservice.AbstractServiceResponse;
import com.vmware.sva.services.shareddatabase.DeleteSharedObjectRequest;
import com.vmware.sva.services.shareddatabase.GetSharedObjectRequest;
import com.vmware.sva.services.shareddatabase.GetSharedObjectResponse;
import com.vmware.sva.services.shareddatabase.WriteSharedObjectRequest;
import java.io.Serializable;
import java.util.UUID;
import java.util.logging.Level;

public class SharedObjectService
extends AbstractDomainService {
    private static final long serialVersionUID = 1L;
    public static final UUID SERVICE_ID = UUID.fromString("a108fb9b-181a-470d-bd28-25558278e3e9");
    private static final String SERVICE_NAME = "ShareObjectService";
    private final AbstractPersistentBldDatabase database;

    public SharedObjectService(BusinessLogicDomainServiceAPI domain) throws Exception {
        super(SERVICE_ID, SERVICE_NAME, domain);
        this.database = (AbstractPersistentBldDatabase)domain.getDatabase();
    }

    @Override
    public AbstractServiceResponse syncRequest(AbstractServiceRequest request) {
        if (request instanceof GetSharedObjectRequest) {
            return this.handleGetSharedObjectRequest((GetSharedObjectRequest)request);
        }
        String errorMsg = "Unrecognized shared object request: " + ((Object)((Object)request)).getClass();
        assert (false) : errorMsg;
        this.log(Level.SEVERE, errorMsg);
        return null;
    }

    private GetSharedObjectResponse handleGetSharedObjectRequest(GetSharedObjectRequest request) {
        String key = request.getKey();
        GetSharedObjectResponse response = null;
        try {
            Serializable obj = this.database.getSharedObject(key);
            response = new GetSharedObjectResponse(request.getRequestId(), obj);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to get object " + key + " from shared object database", e);
            response = new GetSharedObjectResponse(request.getRequestId(), e);
        }
        return response;
    }

    @Override
    public void persistRequest(AbstractServiceRequest request) {
        if (request instanceof WriteSharedObjectRequest) {
            this.handleWriteSharedObjectRequest((WriteSharedObjectRequest)request);
        } else if (request instanceof DeleteSharedObjectRequest) {
            this.handleDeleteSharedObjectRequest((DeleteSharedObjectRequest)request);
        } else {
            String errorMsg = "Unknown request received by shared object server: " + ((Object)((Object)request)).toString();
            assert (false) : errorMsg;
            this.log(Level.SEVERE, errorMsg);
        }
    }

    @Override
    public void postpersistRequest(AbstractServiceRequest request) {
    }

    private void handleWriteSharedObjectRequest(WriteSharedObjectRequest request) {
        String key = request.getKey();
        Serializable obj = request.getObj();
        try {
            this.database.writeSharedObject(key, obj);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to write object " + key + " to shared object database");
        }
    }

    private void handleDeleteSharedObjectRequest(DeleteSharedObjectRequest request) {
        String key = request.getKey();
        try {
            this.database.deleteSharedObject(key);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Unable to delete object " + key + " from shared object database");
        }
    }
}

