/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.services.zkupgrade;

import com.vmware.sva.common.SerialFields;
import com.vmware.sva.common.SerialMinorVersion;
import com.vmware.sva.common.SvaUtilities;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.UUID;

@SerialMinorVersion(value=2)
public class ZkUpgradeRequest
extends AbstractServiceRequest {
    private boolean primaryMember;
    private List<String> zkServerAddresses;
    private static final long serialVersionUID = 1L;

    public ZkUpgradeRequest(UUID blcId, boolean primaryMember, List<String> zkServerAddresses) {
        super(blcId);
        this.primaryMember = primaryMember;
        this.zkServerAddresses = zkServerAddresses;
    }

    public boolean isPrimaryMember() {
        return this.primaryMember;
    }

    public List<String> getZkServerAddresses() {
        return this.zkServerAddresses;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, InvalidClassException {
        SerialFields fields = this.getSerialGeneration().setDefaultFields((Object)this, ZkUpgradeRequest.class, in);
        if (fields != null) {
            switch (fields.getSerialMinorVersion()) {
                case 1: {
                    this.primaryMember = true;
                    this.zkServerAddresses = SvaUtilities.getZkServerAddresses();
                    break;
                }
                default: {
                    throw new InvalidClassException("Unknown serial minor version " + fields.getSerialMinorVersion() + " for class " + ZkUpgradeRequest.class.getName());
                }
            }
        }
    }
}

