/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.services.zkupgrade;

import com.vmware.sva.bld.BusinessLogicDomainServiceAPI;
import com.vmware.sva.domainservice.AbstractDomainService;
import com.vmware.sva.domainservice.AbstractServiceRequest;
import com.vmware.sva.domainservice.AbstractServiceResponse;
import com.vmware.sva.services.blcevents.svadomain.ZkUpgradeCompletedEvent;
import com.vmware.sva.services.zkupgrade.ZkUpgradeRequest;
import com.vmware.sva.services.zkupgrade.ZkUpgradeResponse;
import com.vmware.sva.zkservice.ZkUpgradeClient;
import java.util.UUID;
import java.util.logging.Level;

public class ZkUpgradeService
extends AbstractDomainService {
    private static final long serialVersionUID = 1L;
    public static final UUID SERVICE_ID = UUID.fromString("635d3165-062d-48b3-9b19-3f7ef4ee2403");

    public ZkUpgradeService(BusinessLogicDomainServiceAPI domain) throws Exception {
        super(SERVICE_ID, "ZkUpgradeService", domain);
    }

    @Override
    public AbstractServiceResponse syncRequest(AbstractServiceRequest request) throws Exception {
        if (!(request instanceof ZkUpgradeRequest)) {
            String message = "Invalid request type passed to ZkUpgradeService: " + (Object)((Object)request);
            this.log(Level.SEVERE, message);
            throw new Exception(message);
        }
        ZkUpgradeRequest zkUpgradeRequest = (ZkUpgradeRequest)request;
        ZkUpgradeClient.maybeUpgrade(new HandleUpgradeCompleted(request), zkUpgradeRequest.isPrimaryMember(), zkUpgradeRequest.getZkServerAddresses());
        return new ZkUpgradeResponse(request.getRequestId(), this.getServiceId());
    }

    @Override
    public void persistRequest(AbstractServiceRequest request) {
        String errorString = "ZkUpgradeService does not support persistent requests";
        this.log(Level.SEVERE, errorString);
        assert (false) : errorString;
    }

    @Override
    public void postpersistRequest(AbstractServiceRequest request) {
        String errorString = "ZkUpgradeService does not support persistent requests";
        this.log(Level.SEVERE, errorString);
        assert (false) : errorString;
    }

    private class HandleUpgradeCompleted
    implements ZkUpgradeClient.CompletionHandler {
        private final AbstractServiceRequest request;

        HandleUpgradeCompleted(AbstractServiceRequest request) {
            this.request = request;
        }

        @Override
        public void completed(Throwable exception) {
            ZkUpgradeService.this.domain.queueLiveBlcEvent(this.request.getBlcId(), new ZkUpgradeCompletedEvent(SERVICE_ID, exception));
        }
    }
}

