/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.util;

import org.apache.activemq.broker.BrokerPluginSupport;
import org.apache.activemq.broker.ConsumerBrokerExchange;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingBrokerPlugin
extends BrokerPluginSupport {
    private Log log = LogFactory.getLog(LoggingBrokerPlugin.class);
    private Log sendLog = LogFactory.getLog(LoggingBrokerPlugin.class.getName() + ".Send");
    private Log ackLog = LogFactory.getLog(LoggingBrokerPlugin.class.getName() + ".Ack");

    public void send(ProducerBrokerExchange producerExchange, Message messageSend) throws Exception {
        if (this.sendLog.isInfoEnabled()) {
            this.sendLog.info("Sending: " + messageSend);
        }
        super.send(producerExchange, messageSend);
    }

    public void acknowledge(ConsumerBrokerExchange consumerExchange, MessageAck ack) throws Exception {
        if (this.ackLog.isInfoEnabled()) {
            this.ackLog.info("Acknowledge: " + ack);
        }
        super.acknowledge(consumerExchange, ack);
    }

    public Log getAckLog() {
        return this.ackLog;
    }

    public void setAckLog(Log ackLog) {
        this.ackLog = ackLog;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getSendLog() {
        return this.sendLog;
    }

    public void setSendLog(Log sendLog) {
        this.sendLog = sendLog;
    }
}

