/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.sva.zkmgmtserver;

import com.vmware.sva.common.SvaConstants;
import com.vmware.sva.common.SvaUtilities;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public final class ZkMgmtClient
extends Thread
implements Watcher {
    private ZooKeeper zk;
    private final Logger logger;
    private static final int WAIT_TIME = 5000;

    ZkMgmtClient(Logger logger) {
        this.logger = logger;
        this.start();
    }

    @Override
    public void run() {
        this.reCreateZkClient();
    }

    private void createZkClient() throws Exception {
        try {
            this.zk = new ZooKeeper("127.0.0.1:" + SvaConstants.ZK_CLIENT_PORT, SvaConstants.ZK_CLIENT_SESSION_TIMEOUT, this);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unable to create ZooKeeper client: " + e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(WatchedEvent event) {
        ZkMgmtClient zkMgmtClient = this;
        synchronized (zkMgmtClient) {
            this.logger.log(Level.INFO, "Processing event " + event.toString());
            switch (event.getType()) {
                case None: {
                    switch (event.getState()) {
                        case SyncConnected: {
                            break;
                        }
                        case Expired: {
                            this.reCreateZkClient();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                case NodeDeleted: {
                    try {
                        this.createZnode();
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "Failed to create znode /PseudoSvaOnline", e);
                        this.reCreateZkClient();
                    }
                    break;
                }
                case NodeCreated: 
                case NodeDataChanged: {
                    try {
                        this.exists();
                        break;
                    }
                    catch (Exception e) {
                        this.logger.log(Level.SEVERE, "Call to exists failed /PseudoSvaOnline", e);
                        this.reCreateZkClient();
                    }
                }
            }
        }
    }

    private void reCreateZkClient() {
        boolean connected = false;
        while (!connected) {
            this.close();
            try {
                this.createZkClient();
                connected = true;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to restablish connection " + e.getMessage());
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    this.logger.log(Level.SEVERE, "sleep interrupted ", ie);
                }
            }
        }
    }

    private boolean exists() throws Exception {
        boolean ret = false;
        try {
            if (this.zk.exists("/PseudoSvaOnline", true) != null) {
                this.logger.log(Level.FINE, "Node /PseudoSvaOnline Exist");
                ret = true;
            }
        }
        catch (KeeperException ke) {
            if (ke.code() != KeeperException.Code.CONNECTIONLOSS && ke.code() != KeeperException.Code.SESSIONEXPIRED) {
                this.logger.log(Level.SEVERE, "Call to exists failed /PseudoSvaOnline " + ke.getMessage() + " " + ke.code());
                throw ke;
            }
            this.logger.log(Level.INFO, "Ignoring exists failure /PseudoSvaOnline " + ke.getMessage() + " " + ke.code());
            ret = true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Call to exists failed /PseudoSvaOnline", e);
            throw e;
        }
        return ret;
    }

    private void createZnode() throws Exception {
        if (this.exists()) {
            return;
        }
        String str = "time=" + Long.toString(System.currentTimeMillis()) + " ";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            str = str + "ipaddr=" + addr.toString();
        }
        catch (Exception e) {
            str = str + "ipaddr=unknown";
        }
        try {
            this.zk.create("/PseudoSvaOnline", SvaUtilities.objectToBytes(str), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unable to create /PseudoSvaOnline", e);
            throw e;
        }
    }

    public void close() {
        if (this.zk == null) {
            return;
        }
        try {
            this.zk.close();
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Unable to close ZooKeeper client: " + e.getMessage(), e);
        }
    }
}

