//////////////////////////////////////////////////
// Unattend_pass will first locate the Settings element with a given "pass" attribute
// Then under it, Unattend_pass will locate the Component element with a given "name" attribute value
// Then under it, Unattend_pass will either locate or create a path of elements, and assign a value to the end node
//////////////////////////////////////////////////

/** main *****************************************/
function Unattend_path(xmlDoc, passValue, nameValue, nodeNameArray, nodeValue) {
	this.load = function(xmlDoc, passValue, nameValue, nodeNameArray, nodeValue) {
		try {
			var one = xmlDoc.documentElement.childNodes;
			
			// find settings element with pass attribute value of passValue
			for (var iOne = 0; iOne < one.length; iOne++) {
				if (one[iOne].getAttribute("pass") == passValue) {
					//alert("found " + passValue);
					var foundComponent = false;
					var foundshSetup = false;
					var two = one[iOne].childNodes;
					var shsetupNode;
					for (var iTwo = 0; iTwo < two.length; iTwo++) {
						// find component element with name attribute value of nameValue						
						if (two[iTwo].nodeName == "component") {
							//alert(two[iTwo].getAttribute("name"));
							if (two[iTwo].getAttribute("name") == nameValue) {
								//alert("found " + nameValue);
								var curr = two[iTwo];
								foundComponent = true;
							}
							
							if (two[iTwo].getAttribute("name") == "Microsoft-Windows-Shell-Setup") {
								foundshSetup = true;
								shsetupNode = two[iTwo];
								//alert(shsetupNode.attributes.length);								
							}
							
						}	
					}
						
					if ( ! foundComponent) {
						//alert("creating component");
						//curr = xmlDoc.createElement("component");
						curr = xmlDoc.createNode(1, "component", "");
						
						if (foundshSetup) {
							for (var i = 0; i < shsetupNode.attributes.length; i++) {
								curr.setAttribute(shsetupNode.attributes[i].name, shsetupNode.attributes[i].value);
							}
						}
						
						curr.setAttribute("name", nameValue);
						one[iOne].appendChild(curr);	
					}
								
					// nodeNameArray has the element names in the path to the element where
					// we need to set the value equal to nodeValue, so we either follow
					// the path or create the path elements along the way
					var foundNode;
					for (var nodeNameArrayIndex = 0; nodeNameArrayIndex < nodeNameArray.length; nodeNameArrayIndex++) {
						var foundLevel = false;
						var currChildren = curr.childNodes;									
						for (var currChildrenIndex = 0; currChildrenIndex < currChildren.length; currChildrenIndex++) {										
							if (currChildren[currChildrenIndex].nodeName == nodeNameArray[nodeNameArrayIndex]) {
								var foundLevel = true;
								//alert("found path level " + nodeNameArrayIndex);
								foundNode = currChildren[currChildrenIndex];										
								break;
							}
						}

						if ( ! foundLevel) {
							// add the node and link it in
							//alert("created path level " + nodeNameArrayIndex);
							foundNode = xmlDoc.createElement(nodeNameArray[nodeNameArrayIndex]);
							curr.appendChild(foundNode);										
						}

						curr = foundNode;									
					}
								
					// set the value here
					// have to remove existing value first
					for (var i = 0; i < foundNode.childNodes.length; i++) {
						if (foundNode.childNodes[i].nodeType == 3) {
							//alert("removed value");
							foundNode.removeChild(foundNode.childNodes[i]);
							break;
						}
					}
								
					var newText = xmlDoc.createTextNode(nodeValue);
					foundNode.appendChild(newText);
					//alert("set value " + nodeValue);
				}
			}			
		} catch (e) {
			throw e;
		}
	}
	
	this.load(xmlDoc, passValue, nameValue, nodeNameArray, nodeValue);
}

function alert(str) {
//  WScript.echo(str + "\n");
}