//////////////////////////////////////////////////
// diskpart_prep0.js
//
// @author: Christopher Boumenot

/** utility **************************************/

function include(filename) {
    var fso = new ActiveXObject("Scripting.FileSystemObject");
    var f = fso.OpenTextFile(filename);
    var s = f.ReadAll();
    f.Close();
    return s;
};

/** include **************************************/

eval(include("workitem.js"));
eval(include("script_writer.js"));

/** class ****************************************/

function Disk(letter, offset, bag) {
    this.letter = letter;
    this.offset = offset;
    this.bag = bag;

    this.getFileSystem = function() {
        var name = "VirtualMachine.Disk" + this.offset + ".FileSystem";
        if (bag.exists(name)) {
            return bag.get(name);
        }

        return "ntfs";
    };

    this.getLabel = function() {
        var name = "VirtualMachine.Disk" + this.offset + ".Label";
        if (bag.exists(name)) {
            return bag.get(name);
        }
        
        return this.letter + " Drive";
    };

    this.toString = function() {
        var lines = new Array();
        lines.push("select disk " + this.offset);
        lines.push("online disk NOERR");
        lines.push("attribute disk clear readonly NOERR");
        lines.push("create partition primary");
        lines.push("format fs=\"" + this.getFileSystem() + "\" label=\"" + this.getLabel() + "\" quick");
        lines.push("Assign Letter=" + this.letter + ":");
        lines.push("active");

        return lines.join("\r\n");
    };
}


//////////////////////////////////////////////////
// main

try {
    // just do drive 0 in setupos workitem
    sw = new ScriptWriter("diskpart", ".scr");
    bag = new WorkItem("properties.xml");

    var letter;
    if (bag.exists("VirtualMachine.Disk0.Letter")) {
       letter = bag.get("VirtualMachine.Disk0.Letter").substr(0, 1).toUpperCase();
    }
    else {
       letter = "C";
    }
       
    var disk = new Disk(letter, 0, bag);
    sw.write(disk);

} catch (e) {
    throw e;
}

